/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.matrix.serializer;

import com.powsybl.math.matrix.SparseMatrix;
import com.powsybl.math.matrix.SparseMatrixFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.Matrix;
import us.hebi.matlab.mat.ejml.Mat5Ejml;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Sinks;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sources;
import us.hebi.matlab.mat.util.Casts;

public final class SparseMatrixMatSerializer {
    private static final String ENTRY_NAME = "ejmlMatrix";

    private SparseMatrixMatSerializer() {
    }

    public static void exportMat(SparseMatrix m, OutputStream oStream) {
        Objects.requireNonNull(m);
        Objects.requireNonNull(oStream);
        SparseMatrixMatSerializer.writeMatlab((Matrix)SparseMatrixMatSerializer.toEjmlSparseMatrix(m), oStream, ENTRY_NAME);
    }

    public static SparseMatrix importMat(InputStream iStream) {
        Objects.requireNonNull(iStream);
        DMatrixSparseCSC m = SparseMatrixMatSerializer.readMatlab(iStream, null, ENTRY_NAME);
        return SparseMatrixMatSerializer.fromEjmlSparseMatrix(m);
    }

    public static void exportMat(SparseMatrix m, Path file) {
        Objects.requireNonNull(m);
        Objects.requireNonNull(file);
        try (OutputStream oStream = Files.newOutputStream(file, new OpenOption[0]);){
            SparseMatrixMatSerializer.exportMat(m, oStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static SparseMatrix importMat(Path file) {
        SparseMatrix sparseMatrix;
        block8: {
            Objects.requireNonNull(file);
            InputStream iStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                sparseMatrix = SparseMatrixMatSerializer.importMat(iStream);
                if (iStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iStream != null) {
                        try {
                            iStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            iStream.close();
        }
        return sparseMatrix;
    }

    private static DMatrixSparseCSC toEjmlSparseMatrix(SparseMatrix matrix) {
        DMatrixSparseCSC ejmlMatrix = new DMatrixSparseCSC(matrix.getRowCount(), matrix.getColumnCount());
        matrix.iterateNonZeroValue((arg_0, arg_1, arg_2) -> ((DMatrixSparseCSC)ejmlMatrix).set(arg_0, arg_1, arg_2));
        return ejmlMatrix;
    }

    private static SparseMatrix fromEjmlSparseMatrix(DMatrixSparseCSC ejmlMatrix) {
        int numRows = ejmlMatrix.getNumRows();
        int numCols = ejmlMatrix.getNumCols();
        SparseMatrix matrix = new SparseMatrixFactory().create(numRows, numCols, ejmlMatrix.getNonZeroLength());
        for (int col = 0; col < numCols; ++col) {
            int idx0 = ejmlMatrix.col_idx[col];
            int idx1 = ejmlMatrix.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int row = ejmlMatrix.nz_rows[i];
                double value = ejmlMatrix.nz_values[i];
                matrix.set(row, col, value);
            }
        }
        return matrix;
    }

    private static ByteBuffer getBuffer(MatFile matFile) throws IOException {
        int bufferSize = Casts.sint32((long)matFile.getUncompressedSerializedSize());
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.nativeOrder());
        matFile.writeTo(Sinks.wrap((ByteBuffer)buffer));
        buffer.flip();
        return buffer;
    }

    private static void writeMatlab(Matrix ejmlMatrix, OutputStream outputStream, String entryName) {
        try (WritableByteChannel channel = Channels.newChannel(outputStream);
             MatFile mat = Mat5.newMatFile().addArray(entryName, Mat5Ejml.asArray((Matrix)ejmlMatrix));){
            channel.write(SparseMatrixMatSerializer.getBuffer(mat));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends Matrix> T readMatlab(InputStream inputStream, T output, String entryName) {
        try (Mat5File mat = Mat5.newReader((Source)Sources.wrapInputStream((InputStream)inputStream)).setEntryFilter(entry -> entry.getName().equals(entryName)).readMat();){
            if (mat.getNumEntries() == 0) {
                throw new IllegalArgumentException("expected matrix named '" + entryName + "' not found.");
            }
            Matrix matrix = Mat5Ejml.convert((Array)mat.getArray(entryName), output);
            return (T)matrix;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

