/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.casting;

import java.util.Objects;

public final class Double2Float {
    public static float safeCasting(double d) {
        if (Double.isNaN(d)) {
            return Float.NaN;
        }
        if (Math.abs(d) == Double.MAX_VALUE) {
            return Float.MAX_VALUE * (float)(d > 0.0 ? 1 : -1);
        }
        if (Math.abs(d) > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Can't casting " + d + " to float");
        }
        return (float)d;
    }

    public static Float safeCasting(Double d) {
        return Objects.isNull(d) ? null : Float.valueOf(Double2Float.safeCasting((double)d));
    }

    private Double2Float() {
    }
}

