/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.matrix;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.MatrixException;
import java.util.Objects;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.FastMath;

public class ComplexMatrix {
    private static final double EPSILON = 1.0E-8;
    private final DenseMatrix realPartMatrix;
    private final DenseMatrix imagPartMatrix;

    public ComplexMatrix(int rowCount, int columnCount) {
        this.realPartMatrix = new DenseMatrix(rowCount, columnCount);
        this.imagPartMatrix = new DenseMatrix(rowCount, columnCount);
    }

    public void set(int i, int j, Complex complex) {
        Objects.requireNonNull(complex);
        this.realPartMatrix.set(i, j, complex.getReal());
        this.imagPartMatrix.set(i, j, complex.getImaginary());
    }

    public int getRowCount() {
        return this.realPartMatrix.getRowCount();
    }

    public int getColumnCount() {
        return this.realPartMatrix.getColumnCount();
    }

    public Complex get(int i, int j) {
        return new Complex(this.realPartMatrix.get(i, j), this.imagPartMatrix.get(i, j));
    }

    public static ComplexMatrix createIdentity(int nbRow) {
        ComplexMatrix complexMatrix = new ComplexMatrix(nbRow, nbRow);
        for (int i = 0; i < nbRow; ++i) {
            complexMatrix.realPartMatrix.set(i, i, 1.0);
        }
        return complexMatrix;
    }

    public ComplexMatrix transpose() {
        ComplexMatrix transposed = new ComplexMatrix(this.getColumnCount(), this.getRowCount());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            for (int j = 0; j < this.getRowCount(); ++j) {
                transposed.realPartMatrix.set(i, j, this.realPartMatrix.get(j, i));
                transposed.imagPartMatrix.set(i, j, this.imagPartMatrix.get(j, i));
            }
        }
        return transposed;
    }

    public ComplexMatrix scale(Complex factor) {
        Objects.requireNonNull(factor);
        ComplexMatrix scaled = new ComplexMatrix(this.getRowCount(), this.getColumnCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                scaled.realPartMatrix.set(i, j, this.realPartMatrix.get(i, j) * factor.getReal() - this.imagPartMatrix.get(i, j) * factor.getImaginary());
                scaled.imagPartMatrix.set(i, j, this.imagPartMatrix.get(i, j) * factor.getReal() + this.realPartMatrix.get(i, j) * factor.getImaginary());
            }
        }
        return scaled;
    }

    public ComplexMatrix scale(double factor) {
        return this.scale(new Complex(factor, 0.0));
    }

    public DenseMatrix toRealCartesianMatrix() {
        DenseMatrix realMatrix = new DenseMatrix(this.getRowCount() * 2, this.getColumnCount() * 2);
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Complex complexTerm = new Complex(this.realPartMatrix.get(i, j), this.imagPartMatrix.get(i, j));
                realMatrix.add(2 * i, 2 * j, complexTerm.getReal());
                realMatrix.add(2 * i + 1, 2 * j + 1, complexTerm.getReal());
                realMatrix.add(2 * i, 2 * j + 1, -complexTerm.getImaginary());
                realMatrix.add(2 * i + 1, 2 * j, complexTerm.getImaginary());
            }
        }
        return realMatrix;
    }

    public static ComplexMatrix fromRealCartesian(DenseMatrix realMatrix) {
        Objects.requireNonNull(realMatrix);
        int columnCount = realMatrix.getColumnCount();
        int rowCount = realMatrix.getRowCount();
        if (columnCount % 2 != 0 || rowCount % 2 != 0) {
            throw new MatrixException("Incompatible matrices dimensions to build a complex matrix from a real cartesian");
        }
        ComplexMatrix complexMatrix = new ComplexMatrix(rowCount / 2, columnCount / 2);
        for (int i = 0; i < rowCount / 2; ++i) {
            for (int j = 0; j < columnCount / 2; ++j) {
                int rowIndexInCartesian = 2 * i;
                int colIndexInCartesian = 2 * j;
                double t11 = realMatrix.get(rowIndexInCartesian, colIndexInCartesian);
                double t12 = realMatrix.get(rowIndexInCartesian, colIndexInCartesian + 1);
                double t21 = realMatrix.get(rowIndexInCartesian + 1, colIndexInCartesian);
                double t22 = realMatrix.get(rowIndexInCartesian + 1, colIndexInCartesian + 1);
                if (FastMath.abs((double)(t11 - t22)) > 1.0E-8 || FastMath.abs((double)(t12 + t21)) > 1.0E-8) {
                    throw new MatrixException("Incompatible bloc matrices terms to build a complex matrix from a real cartesian");
                }
                complexMatrix.set(i, j, new Complex(t11, t21));
            }
        }
        return complexMatrix;
    }
}

