/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.matrix;

import Jama.Matrix;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.math.matrix.MatrixException;
import java.util.Objects;

class DenseLUDecomposition
implements LUDecomposition {
    private final DenseMatrix matrix;
    private Jama.LUDecomposition decomposition;
    private Jama.LUDecomposition transposedDecomposition;

    DenseLUDecomposition(DenseMatrix matrix) {
        this.matrix = Objects.requireNonNull(matrix);
    }

    @Override
    public void update(boolean allowIncrementalUpdate) {
        this.decomposition = null;
        this.transposedDecomposition = null;
    }

    @Override
    public void solve(double[] b) {
        try {
            if (this.decomposition == null) {
                this.decomposition = this.matrix.toJamaMatrix().lu();
            }
            Matrix x = this.decomposition.solve(new Matrix(b, b.length));
            System.arraycopy(x.getColumnPackedCopy(), 0, b, 0, b.length);
        }
        catch (RuntimeException e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public void solveTransposed(double[] b) {
        try {
            if (this.transposedDecomposition == null) {
                this.transposedDecomposition = this.matrix.toJamaMatrix().transpose().lu();
            }
            Matrix x = this.transposedDecomposition.solve(new Matrix(b, b.length));
            System.arraycopy(x.getColumnPackedCopy(), 0, b, 0, b.length);
        }
        catch (RuntimeException e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public void solve(DenseMatrix b) {
        try {
            if (this.decomposition == null) {
                this.decomposition = this.matrix.toJamaMatrix().lu();
            }
            Matrix x = this.decomposition.solve(b.toJamaMatrix());
            b.setValues(x.getColumnPackedCopy());
        }
        catch (RuntimeException e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public void solveTransposed(DenseMatrix b) {
        try {
            if (this.transposedDecomposition == null) {
                this.transposedDecomposition = this.matrix.toJamaMatrix().transpose().lu();
            }
            Matrix x = this.transposedDecomposition.solve(b.toJamaMatrix());
            b.setValues(x.getColumnPackedCopy());
        }
        catch (RuntimeException e) {
            throw new MatrixException(e);
        }
    }

    @Override
    public void close() {
    }
}

