/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.math.solver;

import com.powsybl.math.AbstractMathNative;
import com.powsybl.math.matrix.SparseMatrix;
import com.powsybl.math.solver.KinsolContext;
import com.powsybl.math.solver.KinsolParameters;
import com.powsybl.math.solver.KinsolResult;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Kinsol
extends AbstractMathNative {
    private static final Logger LOGGER = LoggerFactory.getLogger(Kinsol.class);
    private final SparseMatrix j;
    private final FunctionUpdater functionUpdater;
    private final JacobianUpdater jacobianUpdater;

    public Kinsol(SparseMatrix j, FunctionUpdater functionUpdater, JacobianUpdater jacobianUpdater) {
        this.j = Objects.requireNonNull(j);
        this.functionUpdater = Objects.requireNonNull(functionUpdater);
        this.jacobianUpdater = Objects.requireNonNull(jacobianUpdater);
    }

    public native KinsolResult solve(double[] var1, int[] var2, int[] var3, double[] var4, KinsolContext var5, boolean var6, int var7, int var8, int var9, double var10, double var12, boolean var14, int var15);

    private static Level getLogLevel() {
        if (LOGGER.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (LOGGER.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (LOGGER.isInfoEnabled()) {
            return Level.INFO;
        }
        return Level.WARN;
    }

    private static int getPrintLevel(Level level) {
        return switch (level) {
            case Level.INFO -> 1;
            case Level.DEBUG -> 2;
            case Level.TRACE -> 3;
            default -> 0;
        };
    }

    public KinsolResult solve(double[] x, KinsolParameters parameters) {
        return this.solve(x, parameters, false);
    }

    public KinsolResult solveTransposed(double[] x, KinsolParameters parameters) {
        return this.solve(x, parameters, true);
    }

    private KinsolResult solve(double[] x, KinsolParameters parameters, boolean transpose) {
        LOGGER.info("Running Kinsol using parameters: maxIters={}, msbset={}, msbsetsub={}, fnormtol={}, scsteptol={}, lineSearch={}", new Object[]{parameters.getMaxIters(), parameters.getMsbset(), parameters.getMsbsetsub(), parameters.getFnormtol(), parameters.getScsteptol(), parameters.isLineSearch()});
        Level logLevel = Kinsol.getLogLevel();
        KinsolContext context = new KinsolContext(x, this.j, this.functionUpdater, this.jacobianUpdater, logLevel);
        return this.solve(x, this.j.getColumnStart(), this.j.getRowIndices(), this.j.getValues(), context, transpose, parameters.getMaxIters(), parameters.getMsbset(), parameters.getMsbsetsub(), parameters.getFnormtol(), parameters.getScsteptol(), parameters.isLineSearch(), Kinsol.getPrintLevel(logLevel));
    }

    public static interface FunctionUpdater {
        public void update(double[] var1, double[] var2);
    }

    public static interface JacobianUpdater {
        public void update(double[] var1, SparseMatrix var2);
    }
}

