/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow;

import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.AcOuterLoopConfig;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.outerloop.AbstractShuntVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.AbstractTransformerVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.AcIncrementalPhaseControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.AutomationSystemOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.DistributedSlackOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.IncrementalShuntVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.IncrementalTransformerReactivePowerControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.IncrementalTransformerVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.MonitoringVoltageOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.PhaseControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.ReactiveLimitsOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.SecondaryVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.ShuntVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.SimpleTransformerVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.TransformerVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteriaType;
import com.powsybl.openloadflow.lf.outerloop.AbstractPhaseControlOuterLoop;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import java.util.Optional;

abstract class AbstractAcOuterLoopConfig
implements AcOuterLoopConfig {
    protected AbstractAcOuterLoopConfig() {
    }

    protected static Optional<AcOuterLoop> createDistributedSlackOuterLoop(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        if (parameters.isDistributedSlack()) {
            ActivePowerDistribution activePowerDistribution = ActivePowerDistribution.create(parameters.getBalanceType(), parametersExt.isLoadPowerFactorConstant(), parametersExt.isUseActiveLimits());
            return Optional.of(new DistributedSlackOuterLoop(activePowerDistribution, parametersExt.getSlackBusPMaxMismatch()));
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createReactiveLimitsOuterLoop(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        if (parameters.isUseReactiveLimits()) {
            double effectiveMaxReactivePowerMismatch = switch (parametersExt.getNewtonRaphsonStoppingCriteriaType()) {
                default -> throw new IncompatibleClassChangeError();
                case NewtonRaphsonStoppingCriteriaType.UNIFORM_CRITERIA -> parametersExt.getNewtonRaphsonConvEpsPerEq();
                case NewtonRaphsonStoppingCriteriaType.PER_EQUATION_TYPE_CRITERIA -> parametersExt.getMaxReactivePowerMismatch() / 100.0;
            };
            return Optional.of(new ReactiveLimitsOuterLoop(parametersExt.getReactiveLimitsMaxPqPvSwitch(), effectiveMaxReactivePowerMismatch));
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createSecondaryVoltageControlOuterLoop(OpenLoadFlowParameters parametersExt) {
        if (parametersExt.isSecondaryVoltageControl()) {
            return Optional.of(new SecondaryVoltageControlOuterLoop(parametersExt.getMinPlausibleTargetVoltage(), parametersExt.getMaxPlausibleTargetVoltage()));
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createMonitoringVoltageOuterLoop(OpenLoadFlowParameters parametersExt) {
        if (parametersExt.isSvcVoltageMonitoring()) {
            return Optional.of(new MonitoringVoltageOuterLoop());
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createTransformerVoltageControlOuterLoop(LoadFlowParameters parameters, boolean useInitialTapPosition, OpenLoadFlowParameters.TransformerVoltageControlMode controlMode, int incrementalTransformerVoltageControlOuterLoopMaxTapShift, double generatorVoltageControlMinNominalVoltage) {
        if (parameters.isTransformerVoltageControlOn()) {
            AbstractTransformerVoltageControlOuterLoop outerLoop = switch (controlMode) {
                default -> throw new IncompatibleClassChangeError();
                case OpenLoadFlowParameters.TransformerVoltageControlMode.WITH_GENERATOR_VOLTAGE_CONTROL -> new SimpleTransformerVoltageControlOuterLoop();
                case OpenLoadFlowParameters.TransformerVoltageControlMode.AFTER_GENERATOR_VOLTAGE_CONTROL -> new TransformerVoltageControlOuterLoop(useInitialTapPosition, generatorVoltageControlMinNominalVoltage);
                case OpenLoadFlowParameters.TransformerVoltageControlMode.INCREMENTAL_VOLTAGE_CONTROL -> new IncrementalTransformerVoltageControlOuterLoop(incrementalTransformerVoltageControlOuterLoopMaxTapShift);
            };
            return Optional.of(outerLoop);
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createTransformerVoltageControlOuterLoop(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        return AbstractAcOuterLoopConfig.createTransformerVoltageControlOuterLoop(parameters, parametersExt.isTransformerVoltageControlUseInitialTapPosition(), parametersExt.getTransformerVoltageControlMode(), parametersExt.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(), parametersExt.getGeneratorVoltageControlMinNominalVoltage());
    }

    protected static Optional<AcOuterLoop> createTransformerReactivePowerControlOuterLoop(OpenLoadFlowParameters parametersExt) {
        if (parametersExt.isTransformerReactivePowerControl()) {
            return Optional.of(new IncrementalTransformerReactivePowerControlOuterLoop(parametersExt.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift()));
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createShuntVoltageControlOuterLoop(LoadFlowParameters parameters, OpenLoadFlowParameters.ShuntVoltageControlMode controlMode) {
        if (parameters.isShuntCompensatorVoltageControlOn()) {
            AbstractShuntVoltageControlOuterLoop outerLoop = switch (controlMode) {
                default -> throw new IncompatibleClassChangeError();
                case OpenLoadFlowParameters.ShuntVoltageControlMode.WITH_GENERATOR_VOLTAGE_CONTROL -> new ShuntVoltageControlOuterLoop();
                case OpenLoadFlowParameters.ShuntVoltageControlMode.INCREMENTAL_VOLTAGE_CONTROL -> new IncrementalShuntVoltageControlOuterLoop();
            };
            return Optional.of(outerLoop);
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createShuntVoltageControlOuterLoop(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        return AbstractAcOuterLoopConfig.createShuntVoltageControlOuterLoop(parameters, parametersExt.getShuntVoltageControlMode());
    }

    protected static Optional<AcOuterLoop> createPhaseControlOuterLoop(LoadFlowParameters parameters, OpenLoadFlowParameters.PhaseShifterControlMode controlMode) {
        if (parameters.isPhaseShifterRegulationOn()) {
            AbstractPhaseControlOuterLoop outerLoop = switch (controlMode) {
                default -> throw new IncompatibleClassChangeError();
                case OpenLoadFlowParameters.PhaseShifterControlMode.CONTINUOUS_WITH_DISCRETISATION -> new PhaseControlOuterLoop();
                case OpenLoadFlowParameters.PhaseShifterControlMode.INCREMENTAL -> new AcIncrementalPhaseControlOuterLoop();
            };
            return Optional.of(outerLoop);
        }
        return Optional.empty();
    }

    protected static Optional<AcOuterLoop> createPhaseControlOuterLoop(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        return AbstractAcOuterLoopConfig.createPhaseControlOuterLoop(parameters, parametersExt.getPhaseShifterControlMode());
    }

    protected static Optional<AcOuterLoop> createAutomationSystemOuterLoop(OpenLoadFlowParameters parametersExt) {
        if (parametersExt.isSimulateAutomationSystems()) {
            return Optional.of(new AutomationSystemOuterLoop());
        }
        return Optional.empty();
    }
}

