/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.NetworkCache;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.AcloadFlowEngine;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.Networks;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcLoadFlowFromCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcLoadFlowFromCache.class);
    private final Network network;
    private final LoadFlowParameters parameters;
    private final OpenLoadFlowParameters parametersExt;
    private final AcLoadFlowParameters acParameters;
    private final ReportNode reportNode;

    public AcLoadFlowFromCache(Network network, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, AcLoadFlowParameters acParameters, ReportNode reportNode) {
        this.network = Objects.requireNonNull(network);
        this.parameters = Objects.requireNonNull(parameters);
        this.parametersExt = Objects.requireNonNull(parametersExt);
        this.acParameters = Objects.requireNonNull(acParameters);
        this.reportNode = Objects.requireNonNull(reportNode);
    }

    private void configureTopoConfig(LfTopoConfig topoConfig) {
        for (String switchId : this.parametersExt.getActionableSwitchesIds()) {
            Switch sw = this.network.getSwitch(switchId);
            if (sw != null) {
                if (sw.isOpen()) {
                    topoConfig.getSwitchesToClose().add(sw);
                    continue;
                }
                topoConfig.getSwitchesToOpen().add(sw);
                continue;
            }
            LOGGER.warn("Actionable switch '{}' does not exist", (Object)switchId);
        }
        for (String transformerId : this.parametersExt.getActionableTransformersIds()) {
            Branch branch = this.network.getBranch(transformerId);
            if (branch != null) {
                topoConfig.addBranchIdWithRtcToRetain(transformerId);
                topoConfig.addBranchIdWithPtcToRetain(transformerId);
                continue;
            }
            ThreeWindingsTransformer tw3 = this.network.getThreeWindingsTransformer(transformerId);
            if (tw3 != null) {
                for (ThreeSides side : ThreeSides.values()) {
                    topoConfig.addBranchIdWithRtcToRetain(LfLegBranch.getId(side, transformerId));
                    topoConfig.addBranchIdWithPtcToRetain(LfLegBranch.getId(side, transformerId));
                }
            }
            LOGGER.warn("Actionable transformer '{}' does not exist", (Object)transformerId);
        }
        if (topoConfig.isBreaker()) {
            this.acParameters.getNetworkParameters().setBreakers(true);
        }
    }

    private List<AcLoadFlowContext> initContexts(NetworkCache.Entry entry) {
        List<AcLoadFlowContext> contexts;
        LfTopoConfig topoConfig = new LfTopoConfig();
        this.configureTopoConfig(topoConfig);
        try (LfNetworkList lfNetworkList = Networks.load(this.network, this.acParameters.getNetworkParameters(), topoConfig, LfNetworkList.WorkingVariantReverter::new, this.reportNode);){
            contexts = lfNetworkList.getList().stream().map(n -> new AcLoadFlowContext((LfNetwork)n, this.acParameters)).collect(Collectors.toList());
            entry.setContexts(contexts);
            LfNetworkList.VariantCleaner variantCleaner = lfNetworkList.getVariantCleaner();
            if (variantCleaner != null) {
                entry.setTmpVariantId(variantCleaner.getTmpVariantId());
            }
        }
        return contexts;
    }

    private static AcLoadFlowResult run(AcLoadFlowContext context) {
        if (context.getNetwork().getValidity() != LfNetwork.Validity.VALID) {
            return AcLoadFlowResult.createNoCalculationResult(context.getNetwork());
        }
        if (context.isNetworkUpdated()) {
            AcLoadFlowResult result = new AcloadFlowEngine(context).run();
            context.setNetworkUpdated(false);
            return result;
        }
        return new AcLoadFlowResult(context.getNetwork(), 0, 0, AcSolverStatus.CONVERGED, OuterLoopResult.stable(), 0.0, 0.0);
    }

    public List<AcLoadFlowResult> run() {
        NetworkCache.Entry entry = NetworkCache.INSTANCE.get(this.network, this.parameters);
        List<AcLoadFlowContext> contexts = entry.getContexts();
        if (contexts == null) {
            contexts = this.initContexts(entry);
        }
        return contexts.stream().map(AcLoadFlowFromCache::run).collect(Collectors.toList());
    }
}

