/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterScope;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.AcOuterLoopConfig;
import com.powsybl.openloadflow.DefaultAcOuterLoopConfig;
import com.powsybl.openloadflow.ExplicitAcOuterLoopConfig;
import com.powsybl.openloadflow.FullVoltageInitializer;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.VoltageMagnitudeInitializer;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreationParameters;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.ac.solver.AcSolverFactory;
import com.powsybl.openloadflow.ac.solver.AcSolverType;
import com.powsybl.openloadflow.ac.solver.DefaultNewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.MaxVoltageChangeStateVectorScaling;
import com.powsybl.openloadflow.ac.solver.NewtonKrylovFactory;
import com.powsybl.openloadflow.ac.solver.NewtonKrylovParameters;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonFactory;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonParameters;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteriaType;
import com.powsybl.openloadflow.ac.solver.PerEquationTypeStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.StateVectorScalingMode;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcValueVoltageInitializer;
import com.powsybl.openloadflow.dc.equations.DcApproximationType;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemCreationParameters;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LinePerUnitMode;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.NetworkSlackBusSelector;
import com.powsybl.openloadflow.network.ReactivePowerDispatchMode;
import com.powsybl.openloadflow.network.ReferenceBusSelectionMode;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.network.SlackBusSelectionMode;
import com.powsybl.openloadflow.network.SlackBusSelector;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLoadFlowParameters
extends AbstractExtension<LoadFlowParameters> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenLoadFlowParameters.class);
    public static final SlackBusSelectionMode SLACK_BUS_SELECTION_MODE_DEFAULT_VALUE = SlackBusSelectionMode.MOST_MESHED;
    public static final LowImpedanceBranchMode LOW_IMPEDANCE_BRANCH_MODE_DEFAULT_VALUE = LowImpedanceBranchMode.REPLACE_BY_ZERO_IMPEDANCE_LINE;
    public static final SlackDistributionFailureBehavior SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_DEFAULT_VALUE = SlackDistributionFailureBehavior.LEAVE_ON_SLACK_BUS;
    public static final boolean VOLTAGE_REMOTE_CONTROL_DEFAULT_VALUE = true;
    public static final boolean GENERATOR_REACTIVE_POWER_REMOTE_CONTROL_DEFAULT_VALUE = false;
    public static final boolean TRANSFORMER_REACTIVE_POWER_REMOTE_CONTROL_DEFAULT_VALUE = false;
    public static final boolean LOAD_POWER_FACTOR_CONSTANT_DEFAULT_VALUE = false;
    public static final double SLACK_BUS_P_MAX_MISMATCH_DEFAULT_VALUE = 1.0;
    public static final NewtonRaphsonStoppingCriteriaType NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_DEFAULT_VALUE = NewtonRaphsonStoppingCriteriaType.UNIFORM_CRITERIA;
    public static final double MAX_ACTIVE_POWER_MISMATCH_DEFAULT_VALUE = 0.01;
    public static final double MAX_REACTIVE_POWER_MISMATCH_DEFAULT_VALUE = 0.01;
    public static final double MAX_VOLTAGE_MISMATCH_DEFAULT_VALUE = 1.0E-4;
    public static final double MAX_ANGLE_MISMATCH_DEFAULT_VALUE = 1.0E-5;
    public static final double MAX_RATIO_MISMATCH_DEFAULT_VALUE = 1.0E-5;
    public static final double MAX_SUSCEPTANCE_MISMATCH_DEFAULT_VALUE = 1.0E-4;
    public static final boolean VOLTAGE_PER_REACTIVE_POWER_CONTROL_DEFAULT_VALUE = false;
    public static final boolean SVC_VOLTAGE_MONITORING_DEFAULT_VALUE = true;
    public static final VoltageInitModeOverride VOLTAGE_INIT_MODE_OVERRIDE_DEFAULT_VALUE = VoltageInitModeOverride.NONE;
    public static final TransformerVoltageControlMode TRANSFORMER_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE = TransformerVoltageControlMode.WITH_GENERATOR_VOLTAGE_CONTROL;
    public static final ShuntVoltageControlMode SHUNT_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE = ShuntVoltageControlMode.WITH_GENERATOR_VOLTAGE_CONTROL;
    public static final PhaseShifterControlMode PHASE_SHIFTER_CONTROL_MODE_DEFAULT_VALUE = PhaseShifterControlMode.CONTINUOUS_WITH_DISCRETISATION;
    public static final Set<String> ACTIONABLE_SWITCH_IDS_DEFAULT_VALUE = Collections.emptySet();
    public static final Set<String> ACTIONABLE_TRANSFORMERS_IDS_DEFAULT_VALUE = Collections.emptySet();
    public static final Set<ReportedFeatures> REPORTED_FEATURES_DEFAULT_VALUE = Collections.emptySet();
    private static final ReactivePowerDispatchMode REACTIVE_POWER_DISPATCH_MODE_DEFAULT_VALUE = ReactivePowerDispatchMode.Q_EQUAL_PROPORTION;
    protected static final List<String> OUTER_LOOP_NAMES_DEFAULT_VALUE = null;
    protected static final int INCREMENTAL_TRANSFORMER_RATIO_TAP_CONTROL_OUTER_LOOP_MAX_TAP_SHIFT_DEFAULT_VALUE = 3;
    public static final boolean WRITE_REFERENCE_TERMINALS_DEFAULT_VALUE = true;
    protected static final double GENERATOR_VOLTAGE_CONTROL_MIN_NOMINAL_VOLTAGE_DEFAULT_VALUE = -1.0;
    protected static final FictitiousGeneratorVoltageControlCheckMode FICTITIOUS_GENERATOR_VOLTAGE_CONTROL_CHECK_MODE_DEFAULT_VALUE = FictitiousGeneratorVoltageControlCheckMode.FORCED;
    public static final String SLACK_BUS_SELECTION_MODE_PARAM_NAME = "slackBusSelectionMode";
    public static final String SLACK_BUSES_IDS_PARAM_NAME = "slackBusesIds";
    public static final String SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_PARAM_NAME = "slackDistributionFailureBehavior";
    public static final String VOLTAGE_REMOTE_CONTROL_PARAM_NAME = "voltageRemoteControl";
    public static final String GENERATOR_REACTIVE_POWER_REMOTE_CONTROL_PARAM_NAME = "generatorReactivePowerRemoteControl";
    public static final String TRANSFORMER_REACTIVE_POWER_CONTROL_PARAM_NAME = "transformerReactivePowerControl";
    public static final String LOW_IMPEDANCE_BRANCH_MODE_PARAM_NAME = "lowImpedanceBranchMode";
    public static final String LOAD_POWER_FACTOR_CONSTANT_PARAM_NAME = "loadPowerFactorConstant";
    public static final String PLAUSIBLE_ACTIVE_POWER_LIMIT_PARAM_NAME = "plausibleActivePowerLimit";
    public static final String NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_PARAM_NAME = "newtonRaphsonStoppingCriteriaType";
    public static final String MAX_ACTIVE_POWER_MISMATCH_PARAM_NAME = "maxActivePowerMismatch";
    public static final String MAX_REACTIVE_POWER_MISMATCH_PARAM_NAME = "maxReactivePowerMismatch";
    public static final String MAX_VOLTAGE_MISMATCH_PARAM_NAME = "maxVoltageMismatch";
    public static final String MAX_ANGLE_MISMATCH_PARAM_NAME = "maxAngleMismatch";
    public static final String MAX_RATIO_MISMATCH_PARAM_NAME = "maxRatioMismatch";
    public static final String MAX_SUSCEPTANCE_MISMATCH_PARAM_NAME = "maxSusceptanceMismatch";
    public static final String SLACK_BUS_P_MAX_MISMATCH_PARAM_NAME = "slackBusPMaxMismatch";
    public static final String VOLTAGE_PER_REACTIVE_POWER_CONTROL_PARAM_NAME = "voltagePerReactivePowerControl";
    public static final String MAX_NEWTON_RAPHSON_ITERATIONS_PARAM_NAME = "maxNewtonRaphsonIterations";
    public static final String MAX_OUTER_LOOP_ITERATIONS_PARAM_NAME = "maxOuterLoopIterations";
    public static final String NEWTON_RAPHSON_CONV_EPS_PER_EQ_PARAM_NAME = "newtonRaphsonConvEpsPerEq";
    public static final String VOLTAGE_INIT_MODE_OVERRIDE_PARAM_NAME = "voltageInitModeOverride";
    public static final String TRANSFORMER_VOLTAGE_CONTROL_MODE_PARAM_NAME = "transformerVoltageControlMode";
    public static final String SHUNT_VOLTAGE_CONTROL_MODE_PARAM_NAME = "shuntVoltageControlMode";
    public static final String MIN_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME = "minPlausibleTargetVoltage";
    public static final String MAX_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME = "maxPlausibleTargetVoltage";
    public static final String MIN_REALISTIC_VOLTAGE_PARAM_NAME = "minRealisticVoltage";
    public static final String MAX_REALISTIC_VOLTAGE_PARAM_NAME = "maxRealisticVoltage";
    public static final String MIN_NOMINAL_VOLTAGE_TARGET_VOLTAGE_CHECK_PARAM_NAME = "minNominalVoltageTargetVoltageCheck";
    public static final String REACTIVE_RANGE_CHECK_MODE_PARAM_NAME = "reactiveRangeCheckMode";
    public static final String LOW_IMPEDANCE_THRESHOLD_PARAM_NAME = "lowImpedanceThreshold";
    public static final String NETWORK_CACHE_ENABLED_PARAM_NAME = "networkCacheEnabled";
    public static final String SVC_VOLTAGE_MONITORING_PARAM_NAME = "svcVoltageMonitoring";
    public static final String STATE_VECTOR_SCALING_MODE_PARAM_NAME = "stateVectorScalingMode";
    public static final String MAX_SLACK_BUS_COUNT_PARAM_NAME = "maxSlackBusCount";
    public static final String DEBUG_DIR_PARAM_NAME = "debugDir";
    public static final String INCREMENTAL_TRANSFORMER_RATIO_TAP_CONTROL_OUTER_LOOP_MAX_TAP_SHIFT_PARAM_NAME = "incrementalTransformerRatioTapControlOuterLoopMaxTapShift";
    public static final String SECONDARY_VOLTAGE_CONTROL_PARAM_NAME = "secondaryVoltageControl";
    public static final String REACTIVE_LIMITS_MAX_SWITCH_PQ_PV_PARAM_NAME = "reactiveLimitsMaxPqPvSwitch";
    public static final String PHASE_SHIFTER_CONTROL_MODE_PARAM_NAME = "phaseShifterControlMode";
    private static final String ALWAYS_UPDATE_NETWORK_PARAM_NAME = "alwaysUpdateNetwork";
    private static final String MOST_MESHED_SLACK_BUS_SELECTOR_MAX_NOMINAL_VOLTAGE_PERCENTILE_PARAM_NAME = "mostMeshedSlackBusSelectorMaxNominalVoltagePercentile";
    public static final String REPORTED_FEATURES_PARAM_NAME = "reportedFeatures";
    public static final String SLACK_BUS_COUNTRY_FILTER_PARAM_NAME = "slackBusCountryFilter";
    private static final String ACTIONABLE_SWITCHES_IDS_PARAM_NAME = "actionableSwitchesIds";
    private static final String ACTIONABLE_TRANSFORMERS_IDS_PARAM_NAME = "actionableTransformersIds";
    private static final String ASYMMETRICAL_PARAM_NAME = "asymmetrical";
    private static final String REACTIVE_POWER_DISPATCH_MODE_PARAM_NAME = "reactivePowerDispatchMode";
    static final String OUTER_LOOP_NAMES_PARAM_NAME = "outerLoopNames";
    public static final String USE_ACTIVE_LIMITS_PARAM_NAME = "useActiveLimits";
    public static final String DISABLE_VOLTAGE_CONTROL_OF_GENERATORS_OUTSIDE_ACTIVE_POWER_LIMITS_PARAM_NAME = "disableVoltageControlOfGeneratorsOutsideActivePowerLimits";
    private static final String LINE_SEARCH_STATE_VECTOR_SCALING_MAX_ITERATION_PARAM_NAME = "lineSearchStateVectorScalingMaxIteration";
    private static final String LINE_SEARCH_STATE_VECTOR_SCALING_STEP_FOLD_PARAM_NAME = "lineSearchStateVectorScalingStepFold";
    private static final String MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DV_PARAM_NAME = "maxVoltageChangeStateVectorScalingMaxDv";
    private static final String MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DPHI_PARAM_NAME = "maxVoltageChangeStateVectorScalingMaxDphi";
    private static final String LINE_PER_UNIT_MODE_PARAM_NAME = "linePerUnitMode";
    private static final String USE_LOAD_MODEL_PARAM_NAME = "useLoadModel";
    private static final String DC_APPROXIMATION_TYPE_PARAM_NAME = "dcApproximationType";
    public static final String SIMULATE_AUTOMATION_SYSTEMS_PARAM_NAME = "simulateAutomationSystems";
    public static final String AC_SOLVER_TYPE_PARAM_NAME = "acSolverType";
    public static final String MAX_NEWTON_KRYLOV_ITERATIONS_PARAM_NAME = "maxNewtonKrylovIterations";
    public static final String NEWTON_KRYLOV_LINE_SEARCH_PARAM_NAME = "newtonKrylovLineSearch";
    public static final String REFERENCE_BUS_SELECTION_MODE_PARAM_NAME = "referenceBusSelectionMode";
    public static final String WRITE_REFERENCE_TERMINALS_PARAM_NAME = "writeReferenceTerminals";
    public static final String VOLTAGE_TARGET_PRIORITIES_PARAM_NAME = "voltageTargetPriorities";
    public static final String TRANSFORMER_VOLTAGE_CONTROL_USE_INITIAL_TAP_POSITION_PARAM_NAME = "transformerVoltageControlUseInitialTapPosition";
    public static final String GENERATOR_VOLTAGE_CONTROL_MIN_NOMINAL_VOLTAGE_PARAM_NAME = "generatorVoltageControlMinNominalVoltage";
    public static final String FICTITIOUS_GENERATOR_VOLTAGE_CONTROL_CHECK_MODE = "fictitiousGeneratorVoltageControlCheckMode";
    public static final List<Parameter> SPECIFIC_PARAMETERS = List.of(new Parameter("slackBusSelectionMode", ParameterType.STRING, "Slack bus selection mode", (Object)SLACK_BUS_SELECTION_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(SlackBusSelectionMode.class)), new Parameter("slackBusesIds", ParameterType.STRING_LIST, "Slack bus IDs", null), new Parameter("lowImpedanceBranchMode", ParameterType.STRING, "Low impedance branch mode", (Object)LOW_IMPEDANCE_BRANCH_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(LowImpedanceBranchMode.class)), new Parameter("voltageRemoteControl", ParameterType.BOOLEAN, "Generator voltage remote control", (Object)true), new Parameter("slackDistributionFailureBehavior", ParameterType.STRING, "Behavior in case of slack distribution failure", (Object)SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(SlackDistributionFailureBehavior.class)), new Parameter("loadPowerFactorConstant", ParameterType.BOOLEAN, "Load power factor is constant", (Object)false), new Parameter("plausibleActivePowerLimit", ParameterType.DOUBLE, "Plausible active power limit", (Object)5000.0), new Parameter("slackBusPMaxMismatch", ParameterType.DOUBLE, "Slack bus max active power mismatch", (Object)1.0), new Parameter("voltagePerReactivePowerControl", ParameterType.BOOLEAN, "Voltage per reactive power slope", (Object)false), new Parameter("generatorReactivePowerRemoteControl", ParameterType.BOOLEAN, "Generator remote reactive power control", (Object)false), new Parameter("transformerReactivePowerControl", ParameterType.BOOLEAN, "Transformer reactive power control", (Object)false), new Parameter("maxNewtonRaphsonIterations", ParameterType.INTEGER, "Max iterations per Newton-Raphson", (Object)15), new Parameter("maxOuterLoopIterations", ParameterType.INTEGER, "Max outer loop iterations", (Object)20), new Parameter("newtonRaphsonConvEpsPerEq", ParameterType.DOUBLE, "Newton-Raphson convergence epsilon per equation", (Object)NewtonRaphsonStoppingCriteria.DEFAULT_CONV_EPS_PER_EQ), new Parameter("voltageInitModeOverride", ParameterType.STRING, "Voltage init mode override", (Object)VOLTAGE_INIT_MODE_OVERRIDE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(VoltageInitModeOverride.class)), new Parameter("transformerVoltageControlMode", ParameterType.STRING, "Transformer voltage control mode", (Object)TRANSFORMER_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(TransformerVoltageControlMode.class)), new Parameter("shuntVoltageControlMode", ParameterType.STRING, "Shunt voltage control mode", (Object)SHUNT_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(ShuntVoltageControlMode.class)), new Parameter("minPlausibleTargetVoltage", ParameterType.DOUBLE, "Min plausible target voltage", (Object)0.8), new Parameter("maxPlausibleTargetVoltage", ParameterType.DOUBLE, "Max plausible target voltage", (Object)1.2), new Parameter("minRealisticVoltage", ParameterType.DOUBLE, "Min realistic voltage", (Object)0.5), new Parameter("maxRealisticVoltage", ParameterType.DOUBLE, "Max realistic voltage", (Object)2.0), new Parameter("reactiveRangeCheckMode", ParameterType.STRING, "Reactive range check mode", (Object)LfNetworkParameters.REACTIVE_RANGE_CHECK_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(ReactiveRangeCheckMode.class)), new Parameter("lowImpedanceThreshold", ParameterType.DOUBLE, "Low impedance threshold in per unit", (Object)LfNetworkParameters.LOW_IMPEDANCE_THRESHOLD_DEFAULT_VALUE), new Parameter("networkCacheEnabled", ParameterType.BOOLEAN, "Network cache enabled", (Object)false), new Parameter("svcVoltageMonitoring", ParameterType.BOOLEAN, "SVC voltage monitoring", (Object)true), new Parameter("stateVectorScalingMode", ParameterType.STRING, "State vector scaling mode", (Object)NewtonRaphsonParameters.DEFAULT_STATE_VECTOR_SCALING_MODE.name(), OpenLoadFlowParameters.getEnumPossibleValues(StateVectorScalingMode.class)), new Parameter("maxSlackBusCount", ParameterType.INTEGER, "Maximum slack buses count", (Object)1), new Parameter("debugDir", ParameterType.STRING, "Directory to dump debug files", (Object)LfNetworkParameters.DEBUG_DIR_DEFAULT_VALUE, null, ParameterScope.TECHNICAL), new Parameter("incrementalTransformerRatioTapControlOuterLoopMaxTapShift", ParameterType.INTEGER, "Incremental transformer ratio tap control maximum tap shift per outer loop", (Object)3), new Parameter("secondaryVoltageControl", ParameterType.BOOLEAN, "Secondary voltage control simulation", (Object)false), new Parameter("reactiveLimitsMaxPqPvSwitch", ParameterType.INTEGER, "Reactive limits maximum Pq Pv switch", (Object)3), new Parameter("newtonRaphsonStoppingCriteriaType", ParameterType.STRING, "Newton-Raphson stopping criteria type", (Object)NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(NewtonRaphsonStoppingCriteriaType.class)), new Parameter("maxActivePowerMismatch", ParameterType.DOUBLE, "Maximum active power for per equation stopping criteria", (Object)0.01), new Parameter("maxReactivePowerMismatch", ParameterType.DOUBLE, "Maximum reactive power for per equation stopping criteria", (Object)0.01), new Parameter("maxVoltageMismatch", ParameterType.DOUBLE, "Maximum voltage for per equation stopping criteria", (Object)1.0E-4), new Parameter("maxAngleMismatch", ParameterType.DOUBLE, "Maximum angle for per equation stopping criteria", (Object)1.0E-5), new Parameter("maxRatioMismatch", ParameterType.DOUBLE, "Maximum ratio for per equation stopping criteria", (Object)1.0E-5), new Parameter("maxSusceptanceMismatch", ParameterType.DOUBLE, "Maximum susceptance for per equation stopping criteria", (Object)1.0E-4), new Parameter("phaseShifterControlMode", ParameterType.STRING, "Phase shifter control mode", (Object)PHASE_SHIFTER_CONTROL_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(PhaseShifterControlMode.class)), new Parameter("alwaysUpdateNetwork", ParameterType.BOOLEAN, "Update network even if Newton-Raphson algorithm has diverged", (Object)false), new Parameter("mostMeshedSlackBusSelectorMaxNominalVoltagePercentile", ParameterType.DOUBLE, "In case of most meshed slack bus selection, the max nominal voltage percentile", (Object)95.0), new Parameter("reportedFeatures", ParameterType.STRING_LIST, "List of extra reported features to be added to report", null, OpenLoadFlowParameters.getEnumPossibleValues(ReportedFeatures.class)), new Parameter("slackBusCountryFilter", ParameterType.STRING_LIST, "Slack bus selection country filter (no filtering if empty)", new ArrayList<Country>(LfNetworkParameters.SLACK_BUS_COUNTRY_FILTER_DEFAULT_VALUE), OpenLoadFlowParameters.getEnumPossibleValues(Country.class)), new Parameter("actionableSwitchesIds", ParameterType.STRING_LIST, "List of actionable switches IDs (used with fast restart)", new ArrayList<String>(ACTIONABLE_SWITCH_IDS_DEFAULT_VALUE)), new Parameter("actionableTransformersIds", ParameterType.STRING_LIST, "List of actionable transformers IDs (used with fast restart for tap position change)", new ArrayList<String>(ACTIONABLE_TRANSFORMERS_IDS_DEFAULT_VALUE)), new Parameter("asymmetrical", ParameterType.BOOLEAN, "Asymmetrical calculation", (Object)false), new Parameter("minNominalVoltageTargetVoltageCheck", ParameterType.DOUBLE, "Min nominal voltage for target voltage check", (Object)20.0), new Parameter("reactivePowerDispatchMode", ParameterType.STRING, "Generators reactive power from bus dispatch mode", (Object)REACTIVE_POWER_DISPATCH_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(ReactivePowerDispatchMode.class)), new Parameter("outerLoopNames", ParameterType.STRING_LIST, "Ordered explicit list of outer loop names, supported outer loops are " + String.join((CharSequence)", ", ExplicitAcOuterLoopConfig.NAMES), OUTER_LOOP_NAMES_DEFAULT_VALUE), new Parameter("useActiveLimits", ParameterType.BOOLEAN, "Use active power limits in slack distribution", (Object)true), new Parameter("disableVoltageControlOfGeneratorsOutsideActivePowerLimits", ParameterType.BOOLEAN, "Disable voltage control of generators outside active power limits", (Object)false), new Parameter("lineSearchStateVectorScalingMaxIteration", ParameterType.INTEGER, "Max iteration for the line search state vector scaling", (Object)10), new Parameter("lineSearchStateVectorScalingStepFold", ParameterType.DOUBLE, "Step fold for the line search state vector scaling", (Object)1.3333333333333333), new Parameter("maxVoltageChangeStateVectorScalingMaxDv", ParameterType.DOUBLE, "Max voltage magnitude change for the max voltage change state vector scaling", (Object)0.1), new Parameter("maxVoltageChangeStateVectorScalingMaxDphi", ParameterType.DOUBLE, "Max voltage angle change for the max voltage change state vector scaling", (Object)MaxVoltageChangeStateVectorScaling.DEFAULT_MAX_DPHI), new Parameter("linePerUnitMode", ParameterType.STRING, "Line per unit mode", (Object)LinePerUnitMode.IMPEDANCE.name(), OpenLoadFlowParameters.getEnumPossibleValues(LinePerUnitMode.class)), new Parameter("useLoadModel", ParameterType.BOOLEAN, "Use load model (with voltage dependency) for simulation", (Object)false), new Parameter("dcApproximationType", ParameterType.STRING, "DC approximation type", (Object)DcEquationSystemCreationParameters.DC_APPROXIMATION_TYPE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(DcApproximationType.class)), new Parameter("simulateAutomationSystems", ParameterType.BOOLEAN, "Automation systems simulation", (Object)false), new Parameter("acSolverType", ParameterType.STRING, "AC solver type", (Object)AcSolverType.NEWTON_RAPHSON.name(), OpenLoadFlowParameters.getEnumPossibleValues(AcSolverType.class)), new Parameter("maxNewtonKrylovIterations", ParameterType.INTEGER, "Newton Krylov max number of iterations", (Object)100), new Parameter("newtonKrylovLineSearch", ParameterType.BOOLEAN, "Newton Krylov line search activation", (Object)false), new Parameter("referenceBusSelectionMode", ParameterType.STRING, "Reference bus selection mode", (Object)ReferenceBusSelector.DEFAULT_MODE.name(), OpenLoadFlowParameters.getEnumPossibleValues(ReferenceBusSelectionMode.class)), new Parameter("writeReferenceTerminals", ParameterType.BOOLEAN, "Write Reference Terminals", (Object)true), new Parameter("voltageTargetPriorities", ParameterType.STRING_LIST, "Voltage target priorities for voltage controls", LfNetworkParameters.VOLTAGE_CONTROL_PRIORITIES_DEFAULT_VALUE, OpenLoadFlowParameters.getEnumPossibleValues(VoltageControl.Type.class)), new Parameter("transformerVoltageControlUseInitialTapPosition", ParameterType.BOOLEAN, "Maintain initial tap position if possible", (Object)false), new Parameter("generatorVoltageControlMinNominalVoltage", ParameterType.DOUBLE, "Nominal voltage under which generator voltage controls are disabled during transformer voltage control outer loop of mode AFTER_GENERATOR_VOLTAGE_CONTROL, < 0 means automatic detection", (Object)-1.0), new Parameter("fictitiousGeneratorVoltageControlCheckMode", ParameterType.STRING, "Specifies fictitious generators active power checks exemption for voltage control", (Object)FICTITIOUS_GENERATOR_VOLTAGE_CONTROL_CHECK_MODE_DEFAULT_VALUE.name(), OpenLoadFlowParameters.getEnumPossibleValues(FictitiousGeneratorVoltageControlCheckMode.class)));
    private SlackBusSelectionMode slackBusSelectionMode = SLACK_BUS_SELECTION_MODE_DEFAULT_VALUE;
    private List<String> slackBusesIds = Collections.emptyList();
    private SlackDistributionFailureBehavior slackDistributionFailureBehavior = SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_DEFAULT_VALUE;
    private boolean voltageRemoteControl = true;
    private LowImpedanceBranchMode lowImpedanceBranchMode = LOW_IMPEDANCE_BRANCH_MODE_DEFAULT_VALUE;
    private boolean loadPowerFactorConstant = false;
    private double plausibleActivePowerLimit = 5000.0;
    private NewtonRaphsonStoppingCriteriaType newtonRaphsonStoppingCriteriaType = NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_DEFAULT_VALUE;
    private double maxActivePowerMismatch = 0.01;
    private double maxReactivePowerMismatch = 0.01;
    private double maxVoltageMismatch = 1.0E-4;
    private double maxAngleMismatch = 1.0E-5;
    private double maxRatioMismatch = 1.0E-5;
    private double maxSusceptanceMismatch = 1.0E-4;
    private double slackBusPMaxMismatch = 1.0;
    private boolean voltagePerReactivePowerControl = false;
    private boolean generatorReactivePowerRemoteControl = false;
    private boolean transformerReactivePowerControl = false;
    private int maxNewtonRaphsonIterations = 15;
    private int maxOuterLoopIterations = 20;
    private double newtonRaphsonConvEpsPerEq = NewtonRaphsonStoppingCriteria.DEFAULT_CONV_EPS_PER_EQ;
    private VoltageInitModeOverride voltageInitModeOverride = VOLTAGE_INIT_MODE_OVERRIDE_DEFAULT_VALUE;
    private TransformerVoltageControlMode transformerVoltageControlMode = TRANSFORMER_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE;
    private ShuntVoltageControlMode shuntVoltageControlMode = SHUNT_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE;
    private double minPlausibleTargetVoltage = 0.8;
    private double maxPlausibleTargetVoltage = 1.2;
    private double minNominalVoltageTargetVoltageCheck = 20.0;
    private double minRealisticVoltage = 0.5;
    private double maxRealisticVoltage = 2.0;
    private double lowImpedanceThreshold = LfNetworkParameters.LOW_IMPEDANCE_THRESHOLD_DEFAULT_VALUE;
    private ReactiveRangeCheckMode reactiveRangeCheckMode = LfNetworkParameters.REACTIVE_RANGE_CHECK_MODE_DEFAULT_VALUE;
    private boolean networkCacheEnabled = false;
    private boolean svcVoltageMonitoring = true;
    private StateVectorScalingMode stateVectorScalingMode = NewtonRaphsonParameters.DEFAULT_STATE_VECTOR_SCALING_MODE;
    private int maxSlackBusCount = 1;
    private String debugDir = LfNetworkParameters.DEBUG_DIR_DEFAULT_VALUE;
    private int incrementalTransformerRatioTapControlOuterLoopMaxTapShift = 3;
    private boolean secondaryVoltageControl = false;
    private int reactiveLimitsMaxPqPvSwitch = 3;
    private PhaseShifterControlMode phaseShifterControlMode = PHASE_SHIFTER_CONTROL_MODE_DEFAULT_VALUE;
    private boolean alwaysUpdateNetwork = false;
    private double mostMeshedSlackBusSelectorMaxNominalVoltagePercentile = 95.0;
    private Set<ReportedFeatures> reportedFeatures = REPORTED_FEATURES_DEFAULT_VALUE;
    private Set<Country> slackBusCountryFilter = LfNetworkParameters.SLACK_BUS_COUNTRY_FILTER_DEFAULT_VALUE;
    private Set<String> actionableSwitchesIds = ACTIONABLE_SWITCH_IDS_DEFAULT_VALUE;
    private Set<String> actionableTransformersIds = ACTIONABLE_TRANSFORMERS_IDS_DEFAULT_VALUE;
    private boolean asymmetrical = false;
    private ReactivePowerDispatchMode reactivePowerDispatchMode = REACTIVE_POWER_DISPATCH_MODE_DEFAULT_VALUE;
    private List<String> outerLoopNames = OUTER_LOOP_NAMES_DEFAULT_VALUE;
    private boolean useActiveLimits = true;
    private boolean disableVoltageControlOfGeneratorsOutsideActivePowerLimits = false;
    private int lineSearchStateVectorScalingMaxIteration = 10;
    private double lineSearchStateVectorScalingStepFold = 1.3333333333333333;
    private double maxVoltageChangeStateVectorScalingMaxDv = 0.1;
    private double maxVoltageChangeStateVectorScalingMaxDphi = MaxVoltageChangeStateVectorScaling.DEFAULT_MAX_DPHI;
    private LinePerUnitMode linePerUnitMode = LfNetworkParameters.LINE_PER_UNIT_MODE_DEFAULT_VALUE;
    private boolean useLoadModel = false;
    private DcApproximationType dcApproximationType = DcEquationSystemCreationParameters.DC_APPROXIMATION_TYPE_DEFAULT_VALUE;
    private boolean simulateAutomationSystems = false;
    private AcSolverType acSolverType = AcSolverType.NEWTON_RAPHSON;
    private int maxNewtonKrylovIterations = 100;
    private boolean newtonKrylovLineSearch = false;
    private ReferenceBusSelectionMode referenceBusSelectionMode = ReferenceBusSelector.DEFAULT_MODE;
    private boolean writeReferenceTerminals = true;
    private List<String> voltageTargetPriorities = LfNetworkParameters.VOLTAGE_CONTROL_PRIORITIES_DEFAULT_VALUE;
    private boolean transformerVoltageControlUseInitialTapPosition = false;
    private double generatorVoltageControlMinNominalVoltage = -1.0;
    private FictitiousGeneratorVoltageControlCheckMode fictitiousGeneratorVoltageControlCheckMode = FICTITIOUS_GENERATOR_VOLTAGE_CONTROL_CHECK_MODE_DEFAULT_VALUE;

    public static <E extends Enum<E>> List<Object> getEnumPossibleValues(Class<E> enumClass) {
        return EnumSet.allOf(enumClass).stream().map(Enum::name).collect(Collectors.toList());
    }

    public static double checkParameterValue(double parameterValue, boolean condition, String parameterName) {
        if (!condition) {
            throw new IllegalArgumentException("Invalid value for parameter " + parameterName + ": " + parameterValue);
        }
        return parameterValue;
    }

    public static int checkParameterValue(int parameterValue, boolean condition, String parameterName) {
        if (!condition) {
            throw new IllegalArgumentException("Invalid value for parameter " + parameterName + ": " + parameterValue);
        }
        return parameterValue;
    }

    public String getName() {
        return "open-load-flow-parameters";
    }

    public SlackBusSelectionMode getSlackBusSelectionMode() {
        return this.slackBusSelectionMode;
    }

    public OpenLoadFlowParameters setSlackBusSelectionMode(SlackBusSelectionMode slackBusSelectionMode) {
        this.slackBusSelectionMode = Objects.requireNonNull(slackBusSelectionMode);
        return this;
    }

    public List<String> getSlackBusesIds() {
        return this.slackBusesIds;
    }

    public OpenLoadFlowParameters setSlackBusesIds(List<String> slackBusesIds) {
        this.slackBusesIds = Objects.requireNonNull(slackBusesIds);
        return this;
    }

    public OpenLoadFlowParameters setSlackBusId(String slackBusId) {
        this.slackBusesIds = List.of(Objects.requireNonNull(slackBusId));
        return this;
    }

    public SlackDistributionFailureBehavior getSlackDistributionFailureBehavior() {
        return this.slackDistributionFailureBehavior;
    }

    public OpenLoadFlowParameters setSlackDistributionFailureBehavior(SlackDistributionFailureBehavior slackDistributionFailureBehavior) {
        this.slackDistributionFailureBehavior = Objects.requireNonNull(slackDistributionFailureBehavior);
        return this;
    }

    public boolean isVoltageRemoteControl() {
        return this.voltageRemoteControl;
    }

    public OpenLoadFlowParameters setVoltageRemoteControl(boolean voltageRemoteControl) {
        this.voltageRemoteControl = voltageRemoteControl;
        return this;
    }

    public LowImpedanceBranchMode getLowImpedanceBranchMode() {
        return this.lowImpedanceBranchMode;
    }

    public OpenLoadFlowParameters setLowImpedanceBranchMode(LowImpedanceBranchMode lowImpedanceBranchMode) {
        this.lowImpedanceBranchMode = Objects.requireNonNull(lowImpedanceBranchMode);
        return this;
    }

    public boolean isLoadPowerFactorConstant() {
        return this.loadPowerFactorConstant;
    }

    public OpenLoadFlowParameters setLoadPowerFactorConstant(boolean loadPowerFactorConstant) {
        this.loadPowerFactorConstant = loadPowerFactorConstant;
        return this;
    }

    public double getPlausibleActivePowerLimit() {
        return this.plausibleActivePowerLimit;
    }

    public OpenLoadFlowParameters setPlausibleActivePowerLimit(double plausibleActivePowerLimit) {
        if (plausibleActivePowerLimit <= 0.0) {
            throw new IllegalArgumentException("Invalid plausible active power limit: " + plausibleActivePowerLimit);
        }
        this.plausibleActivePowerLimit = plausibleActivePowerLimit;
        return this;
    }

    public double getSlackBusPMaxMismatch() {
        return this.slackBusPMaxMismatch;
    }

    public OpenLoadFlowParameters setSlackBusPMaxMismatch(double slackBusPMaxMismatch) {
        this.slackBusPMaxMismatch = OpenLoadFlowParameters.checkParameterValue(slackBusPMaxMismatch, slackBusPMaxMismatch >= 0.0, SLACK_BUS_P_MAX_MISMATCH_PARAM_NAME);
        return this;
    }

    public boolean isVoltagePerReactivePowerControl() {
        return this.voltagePerReactivePowerControl;
    }

    public OpenLoadFlowParameters setVoltagePerReactivePowerControl(boolean voltagePerReactivePowerControl) {
        this.voltagePerReactivePowerControl = voltagePerReactivePowerControl;
        return this;
    }

    public boolean isGeneratorReactivePowerRemoteControl() {
        return this.generatorReactivePowerRemoteControl;
    }

    public OpenLoadFlowParameters setGeneratorReactivePowerRemoteControl(boolean generatorReactivePowerRemoteControl) {
        this.generatorReactivePowerRemoteControl = generatorReactivePowerRemoteControl;
        return this;
    }

    public boolean isTransformerReactivePowerControl() {
        return this.transformerReactivePowerControl;
    }

    public OpenLoadFlowParameters setTransformerReactivePowerControl(boolean transformerReactivePowerControl) {
        this.transformerReactivePowerControl = transformerReactivePowerControl;
        return this;
    }

    public int getMaxNewtonRaphsonIterations() {
        return this.maxNewtonRaphsonIterations;
    }

    public OpenLoadFlowParameters setMaxNewtonRaphsonIterations(int maxNewtonRaphsonIterations) {
        this.maxNewtonRaphsonIterations = OpenLoadFlowParameters.checkParameterValue(maxNewtonRaphsonIterations, maxNewtonRaphsonIterations >= 1, MAX_NEWTON_RAPHSON_ITERATIONS_PARAM_NAME);
        return this;
    }

    public int getMaxOuterLoopIterations() {
        return this.maxOuterLoopIterations;
    }

    public OpenLoadFlowParameters setMaxOuterLoopIterations(int maxOuterLoopIterations) {
        this.maxOuterLoopIterations = OpenLoadFlowParameters.checkParameterValue(maxOuterLoopIterations, maxOuterLoopIterations >= 1, MAX_OUTER_LOOP_ITERATIONS_PARAM_NAME);
        return this;
    }

    public double getNewtonRaphsonConvEpsPerEq() {
        return this.newtonRaphsonConvEpsPerEq;
    }

    public OpenLoadFlowParameters setNewtonRaphsonConvEpsPerEq(double newtonRaphsonConvEpsPerEq) {
        this.newtonRaphsonConvEpsPerEq = OpenLoadFlowParameters.checkParameterValue(newtonRaphsonConvEpsPerEq, newtonRaphsonConvEpsPerEq > 0.0, NEWTON_RAPHSON_CONV_EPS_PER_EQ_PARAM_NAME);
        return this;
    }

    public NewtonRaphsonStoppingCriteriaType getNewtonRaphsonStoppingCriteriaType() {
        return this.newtonRaphsonStoppingCriteriaType;
    }

    public OpenLoadFlowParameters setNewtonRaphsonStoppingCriteriaType(NewtonRaphsonStoppingCriteriaType newtonRaphsonStoppingCriteriaType) {
        this.newtonRaphsonStoppingCriteriaType = Objects.requireNonNull(newtonRaphsonStoppingCriteriaType);
        return this;
    }

    public double getMaxActivePowerMismatch() {
        return this.maxActivePowerMismatch;
    }

    public OpenLoadFlowParameters setMaxActivePowerMismatch(double maxActivePowerMismatch) {
        this.maxActivePowerMismatch = OpenLoadFlowParameters.checkParameterValue(maxActivePowerMismatch, maxActivePowerMismatch > 0.0, MAX_ACTIVE_POWER_MISMATCH_PARAM_NAME);
        return this;
    }

    public double getMaxReactivePowerMismatch() {
        return this.maxReactivePowerMismatch;
    }

    public OpenLoadFlowParameters setMaxReactivePowerMismatch(double maxReactivePowerMismatch) {
        this.maxReactivePowerMismatch = OpenLoadFlowParameters.checkParameterValue(maxReactivePowerMismatch, maxReactivePowerMismatch > 0.0, MAX_REACTIVE_POWER_MISMATCH_PARAM_NAME);
        return this;
    }

    public double getMaxVoltageMismatch() {
        return this.maxVoltageMismatch;
    }

    public OpenLoadFlowParameters setMaxVoltageMismatch(double maxVoltageMismatch) {
        this.maxVoltageMismatch = OpenLoadFlowParameters.checkParameterValue(maxVoltageMismatch, maxVoltageMismatch > 0.0, MAX_VOLTAGE_MISMATCH_PARAM_NAME);
        return this;
    }

    public double getMaxAngleMismatch() {
        return this.maxAngleMismatch;
    }

    public OpenLoadFlowParameters setMaxAngleMismatch(double maxAngleMismatch) {
        this.maxAngleMismatch = OpenLoadFlowParameters.checkParameterValue(maxAngleMismatch, maxAngleMismatch > 0.0, MAX_ANGLE_MISMATCH_PARAM_NAME);
        return this;
    }

    public double getMaxRatioMismatch() {
        return this.maxRatioMismatch;
    }

    public OpenLoadFlowParameters setMaxRatioMismatch(double maxRatioMismatch) {
        this.maxRatioMismatch = OpenLoadFlowParameters.checkParameterValue(maxRatioMismatch, maxRatioMismatch > 0.0, MAX_RATIO_MISMATCH_PARAM_NAME);
        return this;
    }

    public double getMaxSusceptanceMismatch() {
        return this.maxSusceptanceMismatch;
    }

    public OpenLoadFlowParameters setMaxSusceptanceMismatch(double maxSusceptanceMismatch) {
        this.maxSusceptanceMismatch = OpenLoadFlowParameters.checkParameterValue(maxSusceptanceMismatch, maxSusceptanceMismatch > 0.0, MAX_SUSCEPTANCE_MISMATCH_PARAM_NAME);
        return this;
    }

    public VoltageInitModeOverride getVoltageInitModeOverride() {
        return this.voltageInitModeOverride;
    }

    public OpenLoadFlowParameters setVoltageInitModeOverride(VoltageInitModeOverride voltageInitModeOverride) {
        this.voltageInitModeOverride = Objects.requireNonNull(voltageInitModeOverride);
        return this;
    }

    public TransformerVoltageControlMode getTransformerVoltageControlMode() {
        return this.transformerVoltageControlMode;
    }

    public OpenLoadFlowParameters setTransformerVoltageControlMode(TransformerVoltageControlMode transformerVoltageControlMode) {
        this.transformerVoltageControlMode = Objects.requireNonNull(transformerVoltageControlMode);
        return this;
    }

    public ShuntVoltageControlMode getShuntVoltageControlMode() {
        return this.shuntVoltageControlMode;
    }

    public OpenLoadFlowParameters setShuntVoltageControlMode(ShuntVoltageControlMode shuntVoltageControlMode) {
        this.shuntVoltageControlMode = Objects.requireNonNull(shuntVoltageControlMode);
        return this;
    }

    public double getMinPlausibleTargetVoltage() {
        return this.minPlausibleTargetVoltage;
    }

    public OpenLoadFlowParameters setMinPlausibleTargetVoltage(double minPlausibleTargetVoltage) {
        this.minPlausibleTargetVoltage = OpenLoadFlowParameters.checkParameterValue(minPlausibleTargetVoltage, minPlausibleTargetVoltage >= 0.0, MIN_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME);
        return this;
    }

    public double getMaxPlausibleTargetVoltage() {
        return this.maxPlausibleTargetVoltage;
    }

    public OpenLoadFlowParameters setMaxPlausibleTargetVoltage(double maxPlausibleTargetVoltage) {
        this.maxPlausibleTargetVoltage = OpenLoadFlowParameters.checkParameterValue(maxPlausibleTargetVoltage, maxPlausibleTargetVoltage >= 0.0, MAX_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME);
        return this;
    }

    public double getMinNominalVoltageTargetVoltageCheck() {
        return this.minNominalVoltageTargetVoltageCheck;
    }

    public OpenLoadFlowParameters setMinNominalVoltageTargetVoltageCheck(double minNominalVoltageTargetVoltageCheck) {
        this.minNominalVoltageTargetVoltageCheck = OpenLoadFlowParameters.checkParameterValue(minNominalVoltageTargetVoltageCheck, minNominalVoltageTargetVoltageCheck >= 0.0, MIN_NOMINAL_VOLTAGE_TARGET_VOLTAGE_CHECK_PARAM_NAME);
        return this;
    }

    public double getMinRealisticVoltage() {
        return this.minRealisticVoltage;
    }

    public OpenLoadFlowParameters setMinRealisticVoltage(double minRealisticVoltage) {
        this.minRealisticVoltage = OpenLoadFlowParameters.checkParameterValue(minRealisticVoltage, minRealisticVoltage >= 0.0, MIN_REALISTIC_VOLTAGE_PARAM_NAME);
        return this;
    }

    public double getMaxRealisticVoltage() {
        return this.maxRealisticVoltage;
    }

    public OpenLoadFlowParameters setMaxRealisticVoltage(double maxRealisticVoltage) {
        this.maxRealisticVoltage = OpenLoadFlowParameters.checkParameterValue(maxRealisticVoltage, maxRealisticVoltage >= 0.0, MAX_REALISTIC_VOLTAGE_PARAM_NAME);
        return this;
    }

    public ReactiveRangeCheckMode getReactiveRangeCheckMode() {
        return this.reactiveRangeCheckMode;
    }

    public OpenLoadFlowParameters setReactiveRangeCheckMode(ReactiveRangeCheckMode reactiveRangeCheckMode) {
        this.reactiveRangeCheckMode = reactiveRangeCheckMode;
        return this;
    }

    public double getLowImpedanceThreshold() {
        return this.lowImpedanceThreshold;
    }

    public OpenLoadFlowParameters setLowImpedanceThreshold(double lowImpedanceThreshold) {
        this.lowImpedanceThreshold = OpenLoadFlowParameters.checkParameterValue(lowImpedanceThreshold, lowImpedanceThreshold > 0.0, LOW_IMPEDANCE_THRESHOLD_PARAM_NAME);
        return this;
    }

    public boolean isNetworkCacheEnabled() {
        return this.networkCacheEnabled;
    }

    public OpenLoadFlowParameters setNetworkCacheEnabled(boolean networkCacheEnabled) {
        this.networkCacheEnabled = networkCacheEnabled;
        return this;
    }

    public boolean isSvcVoltageMonitoring() {
        return this.svcVoltageMonitoring;
    }

    public OpenLoadFlowParameters setSvcVoltageMonitoring(boolean svcVoltageMonitoring) {
        this.svcVoltageMonitoring = svcVoltageMonitoring;
        return this;
    }

    public StateVectorScalingMode getStateVectorScalingMode() {
        return this.stateVectorScalingMode;
    }

    public OpenLoadFlowParameters setStateVectorScalingMode(StateVectorScalingMode stateVectorScalingMode) {
        this.stateVectorScalingMode = Objects.requireNonNull(stateVectorScalingMode);
        return this;
    }

    public int getMaxSlackBusCount() {
        return this.maxSlackBusCount;
    }

    public OpenLoadFlowParameters setMaxSlackBusCount(int maxSlackBusCount) {
        this.maxSlackBusCount = LfNetworkParameters.checkMaxSlackBusCount(maxSlackBusCount);
        return this;
    }

    public boolean isSecondaryVoltageControl() {
        return this.secondaryVoltageControl;
    }

    public OpenLoadFlowParameters setSecondaryVoltageControl(boolean secondaryVoltageControl) {
        this.secondaryVoltageControl = secondaryVoltageControl;
        return this;
    }

    public boolean isUseActiveLimits() {
        return this.useActiveLimits;
    }

    public OpenLoadFlowParameters setUseActiveLimits(boolean useActiveLimits) {
        this.useActiveLimits = useActiveLimits;
        return this;
    }

    public boolean isDisableVoltageControlOfGeneratorsOutsideActivePowerLimits() {
        return this.disableVoltageControlOfGeneratorsOutsideActivePowerLimits;
    }

    public OpenLoadFlowParameters setDisableVoltageControlOfGeneratorsOutsideActivePowerLimits(boolean disableVoltageControlOfGeneratorsOutsideActivePowerLimits) {
        this.disableVoltageControlOfGeneratorsOutsideActivePowerLimits = disableVoltageControlOfGeneratorsOutsideActivePowerLimits;
        return this;
    }

    public String getDebugDir() {
        return this.debugDir;
    }

    public OpenLoadFlowParameters setDebugDir(String debugDir) {
        this.debugDir = debugDir;
        return this;
    }

    public int getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift() {
        return this.incrementalTransformerRatioTapControlOuterLoopMaxTapShift;
    }

    public OpenLoadFlowParameters setIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(int incrementalTransformerRatioTapControlOuterLoopMaxTapShift) {
        this.incrementalTransformerRatioTapControlOuterLoopMaxTapShift = OpenLoadFlowParameters.checkParameterValue(incrementalTransformerRatioTapControlOuterLoopMaxTapShift, incrementalTransformerRatioTapControlOuterLoopMaxTapShift >= 1, INCREMENTAL_TRANSFORMER_RATIO_TAP_CONTROL_OUTER_LOOP_MAX_TAP_SHIFT_PARAM_NAME);
        return this;
    }

    public int getReactiveLimitsMaxPqPvSwitch() {
        return this.reactiveLimitsMaxPqPvSwitch;
    }

    public OpenLoadFlowParameters setReactiveLimitsMaxPqPvSwitch(int reactiveLimitsMaxPqPvSwitch) {
        this.reactiveLimitsMaxPqPvSwitch = OpenLoadFlowParameters.checkParameterValue(reactiveLimitsMaxPqPvSwitch, reactiveLimitsMaxPqPvSwitch >= 0, REACTIVE_LIMITS_MAX_SWITCH_PQ_PV_PARAM_NAME);
        return this;
    }

    public PhaseShifterControlMode getPhaseShifterControlMode() {
        return this.phaseShifterControlMode;
    }

    public OpenLoadFlowParameters setPhaseShifterControlMode(PhaseShifterControlMode phaseShifterControlMode) {
        this.phaseShifterControlMode = Objects.requireNonNull(phaseShifterControlMode);
        return this;
    }

    public boolean isAlwaysUpdateNetwork() {
        return this.alwaysUpdateNetwork;
    }

    public OpenLoadFlowParameters setAlwaysUpdateNetwork(boolean alwaysUpdateNetwork) {
        this.alwaysUpdateNetwork = alwaysUpdateNetwork;
        return this;
    }

    public double getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile() {
        return this.mostMeshedSlackBusSelectorMaxNominalVoltagePercentile;
    }

    public OpenLoadFlowParameters setMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(double mostMeshedSlackBusSelectorMaxNominalVoltagePercentile) {
        this.mostMeshedSlackBusSelectorMaxNominalVoltagePercentile = OpenLoadFlowParameters.checkParameterValue(mostMeshedSlackBusSelectorMaxNominalVoltagePercentile, mostMeshedSlackBusSelectorMaxNominalVoltagePercentile >= 0.0 && mostMeshedSlackBusSelectorMaxNominalVoltagePercentile <= 100.0, MOST_MESHED_SLACK_BUS_SELECTOR_MAX_NOMINAL_VOLTAGE_PERCENTILE_PARAM_NAME);
        return this;
    }

    public Set<ReportedFeatures> getReportedFeatures() {
        return this.reportedFeatures;
    }

    public OpenLoadFlowParameters setReportedFeatures(Set<ReportedFeatures> reportedFeatures) {
        this.reportedFeatures = Objects.requireNonNull(reportedFeatures);
        return this;
    }

    public Set<Country> getSlackBusCountryFilter() {
        return this.slackBusCountryFilter;
    }

    public OpenLoadFlowParameters setSlackBusCountryFilter(Set<Country> slackBusCountryFilter) {
        this.slackBusCountryFilter = Objects.requireNonNull(slackBusCountryFilter);
        return this;
    }

    public Set<String> getActionableSwitchesIds() {
        return this.actionableSwitchesIds;
    }

    public OpenLoadFlowParameters setActionableSwitchesIds(Set<String> actionableSwitchesIds) {
        this.actionableSwitchesIds = Objects.requireNonNull(actionableSwitchesIds);
        return this;
    }

    public Set<String> getActionableTransformersIds() {
        return this.actionableTransformersIds;
    }

    public OpenLoadFlowParameters setActionableTransformersIds(Set<String> actionableTransformersIds) {
        this.actionableTransformersIds = Objects.requireNonNull(actionableTransformersIds);
        return this;
    }

    public boolean isAsymmetrical() {
        return this.asymmetrical;
    }

    public OpenLoadFlowParameters setAsymmetrical(boolean asymmetrical) {
        this.asymmetrical = asymmetrical;
        return this;
    }

    public ReactivePowerDispatchMode getReactivePowerDispatchMode() {
        return this.reactivePowerDispatchMode;
    }

    public OpenLoadFlowParameters setReactivePowerDispatchMode(ReactivePowerDispatchMode reactivePowerDispatchMode) {
        this.reactivePowerDispatchMode = Objects.requireNonNull(reactivePowerDispatchMode);
        return this;
    }

    public List<String> getOuterLoopNames() {
        return this.outerLoopNames;
    }

    public OpenLoadFlowParameters setOuterLoopNames(List<String> outerLoopNames) {
        this.outerLoopNames = outerLoopNames;
        return this;
    }

    public int getLineSearchStateVectorScalingMaxIteration() {
        return this.lineSearchStateVectorScalingMaxIteration;
    }

    public OpenLoadFlowParameters setLineSearchStateVectorScalingMaxIteration(int lineSearchStateVectorScalingMaxIteration) {
        this.lineSearchStateVectorScalingMaxIteration = OpenLoadFlowParameters.checkParameterValue(lineSearchStateVectorScalingMaxIteration, lineSearchStateVectorScalingMaxIteration >= 1, LINE_SEARCH_STATE_VECTOR_SCALING_MAX_ITERATION_PARAM_NAME);
        return this;
    }

    public double getLineSearchStateVectorScalingStepFold() {
        return this.lineSearchStateVectorScalingStepFold;
    }

    public OpenLoadFlowParameters setLineSearchStateVectorScalingStepFold(double lineSearchStateVectorScalingStepFold) {
        this.lineSearchStateVectorScalingStepFold = OpenLoadFlowParameters.checkParameterValue(lineSearchStateVectorScalingStepFold, lineSearchStateVectorScalingStepFold > 1.0, LINE_SEARCH_STATE_VECTOR_SCALING_STEP_FOLD_PARAM_NAME);
        return this;
    }

    public double getMaxVoltageChangeStateVectorScalingMaxDv() {
        return this.maxVoltageChangeStateVectorScalingMaxDv;
    }

    public OpenLoadFlowParameters setMaxVoltageChangeStateVectorScalingMaxDv(double maxVoltageChangeStateVectorScalingMaxDv) {
        this.maxVoltageChangeStateVectorScalingMaxDv = OpenLoadFlowParameters.checkParameterValue(maxVoltageChangeStateVectorScalingMaxDv, maxVoltageChangeStateVectorScalingMaxDv > 0.0, MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DV_PARAM_NAME);
        return this;
    }

    public double getMaxVoltageChangeStateVectorScalingMaxDphi() {
        return this.maxVoltageChangeStateVectorScalingMaxDphi;
    }

    public OpenLoadFlowParameters setMaxVoltageChangeStateVectorScalingMaxDphi(double maxVoltageChangeStateVectorScalingMaxDphi) {
        this.maxVoltageChangeStateVectorScalingMaxDphi = OpenLoadFlowParameters.checkParameterValue(maxVoltageChangeStateVectorScalingMaxDphi, maxVoltageChangeStateVectorScalingMaxDphi > 0.0, MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DPHI_PARAM_NAME);
        return this;
    }

    public LinePerUnitMode getLinePerUnitMode() {
        return this.linePerUnitMode;
    }

    public OpenLoadFlowParameters setLinePerUnitMode(LinePerUnitMode linePerUnitMode) {
        this.linePerUnitMode = Objects.requireNonNull(linePerUnitMode);
        return this;
    }

    public boolean isUseLoadModel() {
        return this.useLoadModel;
    }

    public OpenLoadFlowParameters setUseLoadModel(boolean useLoadModel) {
        this.useLoadModel = useLoadModel;
        return this;
    }

    public DcApproximationType getDcApproximationType() {
        return this.dcApproximationType;
    }

    public OpenLoadFlowParameters setDcApproximationType(DcApproximationType dcApproximationType) {
        this.dcApproximationType = Objects.requireNonNull(dcApproximationType);
        return this;
    }

    public boolean isSimulateAutomationSystems() {
        return this.simulateAutomationSystems;
    }

    public OpenLoadFlowParameters setSimulateAutomationSystems(boolean simulateAutomationSystems) {
        this.simulateAutomationSystems = simulateAutomationSystems;
        return this;
    }

    public AcSolverType getAcSolverType() {
        return this.acSolverType;
    }

    public OpenLoadFlowParameters setAcSolverType(AcSolverType acSolverType) {
        this.acSolverType = Objects.requireNonNull(acSolverType);
        return this;
    }

    public int getMaxNewtonKrylovIterations() {
        return this.maxNewtonKrylovIterations;
    }

    public OpenLoadFlowParameters setMaxNewtonKrylovIterations(int maxNewtonKrylovIterations) {
        this.maxNewtonKrylovIterations = OpenLoadFlowParameters.checkParameterValue(maxNewtonKrylovIterations, maxNewtonKrylovIterations >= 1, MAX_NEWTON_KRYLOV_ITERATIONS_PARAM_NAME);
        return this;
    }

    public boolean isNewtonKrylovLineSearch() {
        return this.newtonKrylovLineSearch;
    }

    public OpenLoadFlowParameters setNewtonKrylovLineSearch(boolean newtonKrylovLineSearch) {
        this.newtonKrylovLineSearch = newtonKrylovLineSearch;
        return this;
    }

    public ReferenceBusSelectionMode getReferenceBusSelectionMode() {
        return this.referenceBusSelectionMode;
    }

    public OpenLoadFlowParameters setReferenceBusSelectionMode(ReferenceBusSelectionMode referenceBusSelectionMode) {
        this.referenceBusSelectionMode = referenceBusSelectionMode;
        return this;
    }

    public boolean isWriteReferenceTerminals() {
        return this.writeReferenceTerminals;
    }

    public OpenLoadFlowParameters setWriteReferenceTerminals(boolean writeReferenceTerminals) {
        this.writeReferenceTerminals = writeReferenceTerminals;
        return this;
    }

    public List<String> getVoltageTargetPriorities() {
        return this.voltageTargetPriorities;
    }

    public OpenLoadFlowParameters setVoltageTargetPriorities(List<String> voltageTargetPriorities) {
        LfNetworkParameters.checkVoltageTargetPriorities(voltageTargetPriorities);
        this.voltageTargetPriorities = voltageTargetPriorities;
        return this;
    }

    public boolean isTransformerVoltageControlUseInitialTapPosition() {
        return this.transformerVoltageControlUseInitialTapPosition;
    }

    public OpenLoadFlowParameters setTransformerVoltageControlUseInitialTapPosition(boolean transformerVoltageControlUseInitialTapPosition) {
        this.transformerVoltageControlUseInitialTapPosition = transformerVoltageControlUseInitialTapPosition;
        return this;
    }

    public OpenLoadFlowParameters setGeneratorVoltageControlMinNominalVoltage(double generatorVoltageControlMinNominalVoltage) {
        this.generatorVoltageControlMinNominalVoltage = generatorVoltageControlMinNominalVoltage;
        return this;
    }

    public double getGeneratorVoltageControlMinNominalVoltage() {
        return this.generatorVoltageControlMinNominalVoltage;
    }

    public FictitiousGeneratorVoltageControlCheckMode getFictitiousGeneratorVoltageControlCheckMode() {
        return this.fictitiousGeneratorVoltageControlCheckMode;
    }

    public OpenLoadFlowParameters setFictitiousGeneratorVoltageControlCheckMode(FictitiousGeneratorVoltageControlCheckMode fictitiousGeneratorVoltageControlCheckMode) {
        this.fictitiousGeneratorVoltageControlCheckMode = Objects.requireNonNull(fictitiousGeneratorVoltageControlCheckMode);
        return this;
    }

    public static OpenLoadFlowParameters load() {
        return OpenLoadFlowParameters.load(PlatformConfig.defaultConfig());
    }

    public static OpenLoadFlowParameters load(PlatformConfig platformConfig) {
        OpenLoadFlowParameters parameters = new OpenLoadFlowParameters();
        platformConfig.getOptionalModuleConfig("open-loadflow-default-parameters").ifPresent(config -> parameters.setSlackBusSelectionMode((SlackBusSelectionMode)config.getEnumProperty(SLACK_BUS_SELECTION_MODE_PARAM_NAME, SlackBusSelectionMode.class, (Enum)SLACK_BUS_SELECTION_MODE_DEFAULT_VALUE)).setSlackBusesIds(config.getStringListProperty(SLACK_BUSES_IDS_PARAM_NAME, Collections.emptyList())).setLowImpedanceBranchMode((LowImpedanceBranchMode)config.getEnumProperty(LOW_IMPEDANCE_BRANCH_MODE_PARAM_NAME, LowImpedanceBranchMode.class, (Enum)LOW_IMPEDANCE_BRANCH_MODE_DEFAULT_VALUE)).setVoltageRemoteControl(config.getBooleanProperty(VOLTAGE_REMOTE_CONTROL_PARAM_NAME, true)).setSlackDistributionFailureBehavior((SlackDistributionFailureBehavior)config.getEnumProperty(SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_PARAM_NAME, SlackDistributionFailureBehavior.class, (Enum)SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_DEFAULT_VALUE)).setLoadPowerFactorConstant(config.getBooleanProperty(LOAD_POWER_FACTOR_CONSTANT_PARAM_NAME, false)).setPlausibleActivePowerLimit(config.getDoubleProperty(PLAUSIBLE_ACTIVE_POWER_LIMIT_PARAM_NAME, 5000.0)).setNewtonRaphsonStoppingCriteriaType((NewtonRaphsonStoppingCriteriaType)config.getEnumProperty(NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_PARAM_NAME, NewtonRaphsonStoppingCriteriaType.class, (Enum)NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_DEFAULT_VALUE)).setMaxActivePowerMismatch(config.getDoubleProperty(MAX_ACTIVE_POWER_MISMATCH_PARAM_NAME, 0.01)).setMaxReactivePowerMismatch(config.getDoubleProperty(MAX_REACTIVE_POWER_MISMATCH_PARAM_NAME, 0.01)).setMaxVoltageMismatch(config.getDoubleProperty(MAX_VOLTAGE_MISMATCH_PARAM_NAME, 1.0E-4)).setMaxAngleMismatch(config.getDoubleProperty(MAX_ANGLE_MISMATCH_PARAM_NAME, 1.0E-5)).setMaxRatioMismatch(config.getDoubleProperty(MAX_RATIO_MISMATCH_PARAM_NAME, 1.0E-5)).setMaxSusceptanceMismatch(config.getDoubleProperty(MAX_SUSCEPTANCE_MISMATCH_PARAM_NAME, 1.0E-4)).setSlackBusPMaxMismatch(config.getDoubleProperty(SLACK_BUS_P_MAX_MISMATCH_PARAM_NAME, 1.0)).setVoltagePerReactivePowerControl(config.getBooleanProperty(VOLTAGE_PER_REACTIVE_POWER_CONTROL_PARAM_NAME, false)).setGeneratorReactivePowerRemoteControl(config.getBooleanProperty(GENERATOR_REACTIVE_POWER_REMOTE_CONTROL_PARAM_NAME, false)).setTransformerReactivePowerControl(config.getBooleanProperty(TRANSFORMER_REACTIVE_POWER_CONTROL_PARAM_NAME, false)).setMaxNewtonRaphsonIterations(config.getIntProperty(MAX_NEWTON_RAPHSON_ITERATIONS_PARAM_NAME, 15)).setMaxOuterLoopIterations(config.getIntProperty(MAX_OUTER_LOOP_ITERATIONS_PARAM_NAME, 20)).setNewtonRaphsonConvEpsPerEq(config.getDoubleProperty(NEWTON_RAPHSON_CONV_EPS_PER_EQ_PARAM_NAME, NewtonRaphsonStoppingCriteria.DEFAULT_CONV_EPS_PER_EQ)).setVoltageInitModeOverride((VoltageInitModeOverride)config.getEnumProperty(VOLTAGE_INIT_MODE_OVERRIDE_PARAM_NAME, VoltageInitModeOverride.class, (Enum)VOLTAGE_INIT_MODE_OVERRIDE_DEFAULT_VALUE)).setTransformerVoltageControlMode((TransformerVoltageControlMode)config.getEnumProperty(TRANSFORMER_VOLTAGE_CONTROL_MODE_PARAM_NAME, TransformerVoltageControlMode.class, (Enum)TRANSFORMER_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE)).setShuntVoltageControlMode((ShuntVoltageControlMode)config.getEnumProperty(SHUNT_VOLTAGE_CONTROL_MODE_PARAM_NAME, ShuntVoltageControlMode.class, (Enum)SHUNT_VOLTAGE_CONTROL_MODE_DEFAULT_VALUE)).setMinPlausibleTargetVoltage(config.getDoubleProperty(MIN_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME, 0.8)).setMaxPlausibleTargetVoltage(config.getDoubleProperty(MAX_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME, 1.2)).setMinRealisticVoltage(config.getDoubleProperty(MIN_REALISTIC_VOLTAGE_PARAM_NAME, 0.5)).setMaxRealisticVoltage(config.getDoubleProperty(MAX_REALISTIC_VOLTAGE_PARAM_NAME, 2.0)).setReactiveRangeCheckMode((ReactiveRangeCheckMode)config.getEnumProperty(REACTIVE_RANGE_CHECK_MODE_PARAM_NAME, ReactiveRangeCheckMode.class, (Enum)LfNetworkParameters.REACTIVE_RANGE_CHECK_MODE_DEFAULT_VALUE)).setLowImpedanceThreshold(config.getDoubleProperty(LOW_IMPEDANCE_THRESHOLD_PARAM_NAME, LfNetworkParameters.LOW_IMPEDANCE_THRESHOLD_DEFAULT_VALUE)).setNetworkCacheEnabled(config.getBooleanProperty(NETWORK_CACHE_ENABLED_PARAM_NAME, false)).setSvcVoltageMonitoring(config.getBooleanProperty(SVC_VOLTAGE_MONITORING_PARAM_NAME, true)).setNetworkCacheEnabled(config.getBooleanProperty(NETWORK_CACHE_ENABLED_PARAM_NAME, false)).setStateVectorScalingMode((StateVectorScalingMode)config.getEnumProperty(STATE_VECTOR_SCALING_MODE_PARAM_NAME, StateVectorScalingMode.class, (Enum)NewtonRaphsonParameters.DEFAULT_STATE_VECTOR_SCALING_MODE)).setMaxSlackBusCount(config.getIntProperty(MAX_SLACK_BUS_COUNT_PARAM_NAME, 1)).setDebugDir(config.getStringProperty(DEBUG_DIR_PARAM_NAME, LfNetworkParameters.DEBUG_DIR_DEFAULT_VALUE)).setIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(config.getIntProperty(INCREMENTAL_TRANSFORMER_RATIO_TAP_CONTROL_OUTER_LOOP_MAX_TAP_SHIFT_PARAM_NAME, 3)).setSecondaryVoltageControl(config.getBooleanProperty(SECONDARY_VOLTAGE_CONTROL_PARAM_NAME, false)).setReactiveLimitsMaxPqPvSwitch(config.getIntProperty(REACTIVE_LIMITS_MAX_SWITCH_PQ_PV_PARAM_NAME, 3)).setPhaseShifterControlMode((PhaseShifterControlMode)config.getEnumProperty(PHASE_SHIFTER_CONTROL_MODE_PARAM_NAME, PhaseShifterControlMode.class, (Enum)PHASE_SHIFTER_CONTROL_MODE_DEFAULT_VALUE)).setAlwaysUpdateNetwork(config.getBooleanProperty(ALWAYS_UPDATE_NETWORK_PARAM_NAME, false)).setMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(config.getDoubleProperty(MOST_MESHED_SLACK_BUS_SELECTOR_MAX_NOMINAL_VOLTAGE_PERCENTILE_PARAM_NAME, 95.0)).setReportedFeatures(config.getEnumSetProperty(REPORTED_FEATURES_PARAM_NAME, ReportedFeatures.class, REPORTED_FEATURES_DEFAULT_VALUE)).setSlackBusCountryFilter(config.getEnumSetProperty(SLACK_BUS_COUNTRY_FILTER_PARAM_NAME, Country.class, LfNetworkParameters.SLACK_BUS_COUNTRY_FILTER_DEFAULT_VALUE)).setActionableSwitchesIds(new HashSet<String>(config.getStringListProperty(ACTIONABLE_SWITCHES_IDS_PARAM_NAME, new ArrayList<String>(ACTIONABLE_SWITCH_IDS_DEFAULT_VALUE)))).setActionableTransformersIds(new HashSet<String>(config.getStringListProperty(ACTIONABLE_TRANSFORMERS_IDS_PARAM_NAME, new ArrayList<String>(ACTIONABLE_TRANSFORMERS_IDS_DEFAULT_VALUE)))).setAsymmetrical(config.getBooleanProperty(ASYMMETRICAL_PARAM_NAME, false)).setMinNominalVoltageTargetVoltageCheck(config.getDoubleProperty(MIN_NOMINAL_VOLTAGE_TARGET_VOLTAGE_CHECK_PARAM_NAME, 20.0)).setReactivePowerDispatchMode((ReactivePowerDispatchMode)config.getEnumProperty(REACTIVE_POWER_DISPATCH_MODE_PARAM_NAME, ReactivePowerDispatchMode.class, (Enum)REACTIVE_POWER_DISPATCH_MODE_DEFAULT_VALUE)).setOuterLoopNames(config.getStringListProperty(OUTER_LOOP_NAMES_PARAM_NAME, OUTER_LOOP_NAMES_DEFAULT_VALUE)).setUseActiveLimits(config.getBooleanProperty(USE_ACTIVE_LIMITS_PARAM_NAME, true)).setDisableVoltageControlOfGeneratorsOutsideActivePowerLimits(config.getBooleanProperty(DISABLE_VOLTAGE_CONTROL_OF_GENERATORS_OUTSIDE_ACTIVE_POWER_LIMITS_PARAM_NAME, false)).setLineSearchStateVectorScalingMaxIteration(config.getIntProperty(LINE_SEARCH_STATE_VECTOR_SCALING_MAX_ITERATION_PARAM_NAME, 10)).setLineSearchStateVectorScalingStepFold(config.getDoubleProperty(LINE_SEARCH_STATE_VECTOR_SCALING_STEP_FOLD_PARAM_NAME, 1.3333333333333333)).setMaxVoltageChangeStateVectorScalingMaxDv(config.getDoubleProperty(MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DV_PARAM_NAME, 0.1)).setMaxVoltageChangeStateVectorScalingMaxDphi(config.getDoubleProperty(MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DPHI_PARAM_NAME, MaxVoltageChangeStateVectorScaling.DEFAULT_MAX_DPHI)).setLinePerUnitMode((LinePerUnitMode)config.getEnumProperty(LINE_PER_UNIT_MODE_PARAM_NAME, LinePerUnitMode.class, (Enum)LfNetworkParameters.LINE_PER_UNIT_MODE_DEFAULT_VALUE)).setUseLoadModel(config.getBooleanProperty(USE_LOAD_MODEL_PARAM_NAME, false)).setDcApproximationType((DcApproximationType)config.getEnumProperty(DC_APPROXIMATION_TYPE_PARAM_NAME, DcApproximationType.class, (Enum)DcEquationSystemCreationParameters.DC_APPROXIMATION_TYPE_DEFAULT_VALUE)).setSimulateAutomationSystems(config.getBooleanProperty(SIMULATE_AUTOMATION_SYSTEMS_PARAM_NAME, false)).setAcSolverType((AcSolverType)config.getEnumProperty(AC_SOLVER_TYPE_PARAM_NAME, AcSolverType.class, (Enum)AcSolverType.NEWTON_RAPHSON)).setMaxNewtonKrylovIterations(config.getIntProperty(MAX_NEWTON_KRYLOV_ITERATIONS_PARAM_NAME, 100)).setNewtonKrylovLineSearch(config.getBooleanProperty(NEWTON_KRYLOV_LINE_SEARCH_PARAM_NAME, false)).setReferenceBusSelectionMode((ReferenceBusSelectionMode)config.getEnumProperty(REFERENCE_BUS_SELECTION_MODE_PARAM_NAME, ReferenceBusSelectionMode.class, (Enum)ReferenceBusSelector.DEFAULT_MODE)).setWriteReferenceTerminals(config.getBooleanProperty(WRITE_REFERENCE_TERMINALS_PARAM_NAME, true)).setVoltageTargetPriorities(config.getStringListProperty(VOLTAGE_TARGET_PRIORITIES_PARAM_NAME, LfNetworkParameters.VOLTAGE_CONTROL_PRIORITIES_DEFAULT_VALUE)).setTransformerVoltageControlUseInitialTapPosition(config.getBooleanProperty(TRANSFORMER_VOLTAGE_CONTROL_USE_INITIAL_TAP_POSITION_PARAM_NAME, false)).setGeneratorVoltageControlMinNominalVoltage(config.getDoubleProperty(GENERATOR_VOLTAGE_CONTROL_MIN_NOMINAL_VOLTAGE_PARAM_NAME, -1.0)));
        return parameters;
    }

    public static OpenLoadFlowParameters load(Map<String, String> properties) {
        return new OpenLoadFlowParameters().update(properties);
    }

    private static List<String> parseStringListProp(String prop) {
        if (prop.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(prop.split("[:,]"));
    }

    public OpenLoadFlowParameters update(Map<String, String> properties) {
        Optional.ofNullable(properties.get(SLACK_BUS_SELECTION_MODE_PARAM_NAME)).ifPresent(prop -> this.setSlackBusSelectionMode(SlackBusSelectionMode.valueOf(prop)));
        Optional.ofNullable(properties.get(SLACK_BUSES_IDS_PARAM_NAME)).ifPresent(prop -> this.setSlackBusesIds(OpenLoadFlowParameters.parseStringListProp(prop)));
        Optional.ofNullable(properties.get(LOW_IMPEDANCE_BRANCH_MODE_PARAM_NAME)).ifPresent(prop -> this.setLowImpedanceBranchMode(LowImpedanceBranchMode.valueOf(prop)));
        Optional.ofNullable(properties.get(VOLTAGE_REMOTE_CONTROL_PARAM_NAME)).ifPresent(prop -> this.setVoltageRemoteControl(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_PARAM_NAME)).ifPresent(prop -> this.setSlackDistributionFailureBehavior(SlackDistributionFailureBehavior.valueOf(prop)));
        Optional.ofNullable(properties.get(LOAD_POWER_FACTOR_CONSTANT_PARAM_NAME)).ifPresent(prop -> this.setLoadPowerFactorConstant(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(PLAUSIBLE_ACTIVE_POWER_LIMIT_PARAM_NAME)).ifPresent(prop -> this.setPlausibleActivePowerLimit(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_PARAM_NAME)).ifPresent(prop -> this.setNewtonRaphsonStoppingCriteriaType(NewtonRaphsonStoppingCriteriaType.valueOf(prop)));
        Optional.ofNullable(properties.get(MAX_ACTIVE_POWER_MISMATCH_PARAM_NAME)).ifPresent(prop -> this.setMaxActivePowerMismatch(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_REACTIVE_POWER_MISMATCH_PARAM_NAME)).ifPresent(prop -> this.setMaxReactivePowerMismatch(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_VOLTAGE_MISMATCH_PARAM_NAME)).ifPresent(prop -> this.setMaxVoltageMismatch(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_ANGLE_MISMATCH_PARAM_NAME)).ifPresent(prop -> this.setMaxAngleMismatch(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_RATIO_MISMATCH_PARAM_NAME)).ifPresent(prop -> this.setMaxRatioMismatch(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_SUSCEPTANCE_MISMATCH_PARAM_NAME)).ifPresent(prop -> this.setMaxSusceptanceMismatch(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(SLACK_BUS_P_MAX_MISMATCH_PARAM_NAME)).ifPresent(prop -> this.setSlackBusPMaxMismatch(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(VOLTAGE_PER_REACTIVE_POWER_CONTROL_PARAM_NAME)).ifPresent(prop -> this.setVoltagePerReactivePowerControl(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(GENERATOR_REACTIVE_POWER_REMOTE_CONTROL_PARAM_NAME)).ifPresent(prop -> this.setGeneratorReactivePowerRemoteControl(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(TRANSFORMER_REACTIVE_POWER_CONTROL_PARAM_NAME)).ifPresent(prop -> this.setTransformerReactivePowerControl(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(MAX_NEWTON_RAPHSON_ITERATIONS_PARAM_NAME)).ifPresent(prop -> this.setMaxNewtonRaphsonIterations(Integer.parseInt(prop)));
        Optional.ofNullable(properties.get(MAX_OUTER_LOOP_ITERATIONS_PARAM_NAME)).ifPresent(prop -> this.setMaxOuterLoopIterations(Integer.parseInt(prop)));
        Optional.ofNullable(properties.get(NEWTON_RAPHSON_CONV_EPS_PER_EQ_PARAM_NAME)).ifPresent(prop -> this.setNewtonRaphsonConvEpsPerEq(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(VOLTAGE_INIT_MODE_OVERRIDE_PARAM_NAME)).ifPresent(prop -> this.setVoltageInitModeOverride(VoltageInitModeOverride.valueOf(prop)));
        Optional.ofNullable(properties.get(TRANSFORMER_VOLTAGE_CONTROL_MODE_PARAM_NAME)).ifPresent(prop -> this.setTransformerVoltageControlMode(TransformerVoltageControlMode.valueOf(prop)));
        Optional.ofNullable(properties.get(SHUNT_VOLTAGE_CONTROL_MODE_PARAM_NAME)).ifPresent(prop -> this.setShuntVoltageControlMode(ShuntVoltageControlMode.valueOf(prop)));
        Optional.ofNullable(properties.get(MIN_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME)).ifPresent(prop -> this.setMinPlausibleTargetVoltage(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME)).ifPresent(prop -> this.setMaxPlausibleTargetVoltage(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MIN_REALISTIC_VOLTAGE_PARAM_NAME)).ifPresent(prop -> this.setMinRealisticVoltage(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_REALISTIC_VOLTAGE_PARAM_NAME)).ifPresent(prop -> this.setMaxRealisticVoltage(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(REACTIVE_RANGE_CHECK_MODE_PARAM_NAME)).ifPresent(prop -> this.setReactiveRangeCheckMode(ReactiveRangeCheckMode.valueOf(prop)));
        Optional.ofNullable(properties.get(LOW_IMPEDANCE_THRESHOLD_PARAM_NAME)).ifPresent(prop -> this.setLowImpedanceThreshold(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(NETWORK_CACHE_ENABLED_PARAM_NAME)).ifPresent(prop -> this.setNetworkCacheEnabled(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(SVC_VOLTAGE_MONITORING_PARAM_NAME)).ifPresent(prop -> this.setSvcVoltageMonitoring(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(STATE_VECTOR_SCALING_MODE_PARAM_NAME)).ifPresent(prop -> this.setStateVectorScalingMode(StateVectorScalingMode.valueOf(prop)));
        Optional.ofNullable(properties.get(MAX_SLACK_BUS_COUNT_PARAM_NAME)).ifPresent(prop -> this.setMaxSlackBusCount(Integer.parseInt(prop)));
        Optional.ofNullable(properties.get(DEBUG_DIR_PARAM_NAME)).ifPresent(this::setDebugDir);
        Optional.ofNullable(properties.get(INCREMENTAL_TRANSFORMER_RATIO_TAP_CONTROL_OUTER_LOOP_MAX_TAP_SHIFT_PARAM_NAME)).ifPresent(prop -> this.setIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(Integer.parseInt(prop)));
        Optional.ofNullable(properties.get(SECONDARY_VOLTAGE_CONTROL_PARAM_NAME)).ifPresent(prop -> this.setSecondaryVoltageControl(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(REACTIVE_LIMITS_MAX_SWITCH_PQ_PV_PARAM_NAME)).ifPresent(prop -> this.setReactiveLimitsMaxPqPvSwitch(Integer.parseInt(prop)));
        Optional.ofNullable(properties.get(PHASE_SHIFTER_CONTROL_MODE_PARAM_NAME)).ifPresent(prop -> this.setPhaseShifterControlMode(PhaseShifterControlMode.valueOf(prop)));
        Optional.ofNullable(properties.get(ALWAYS_UPDATE_NETWORK_PARAM_NAME)).ifPresent(prop -> this.setAlwaysUpdateNetwork(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(MOST_MESHED_SLACK_BUS_SELECTOR_MAX_NOMINAL_VOLTAGE_PERCENTILE_PARAM_NAME)).ifPresent(prop -> this.setMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(REPORTED_FEATURES_PARAM_NAME)).ifPresent(prop -> this.setReportedFeatures(OpenLoadFlowParameters.parseStringListProp(prop).stream().map(ReportedFeatures::valueOf).collect(Collectors.toSet())));
        Optional.ofNullable(properties.get(SLACK_BUS_COUNTRY_FILTER_PARAM_NAME)).ifPresent(prop -> this.setSlackBusCountryFilter(OpenLoadFlowParameters.parseStringListProp(prop).stream().map(Country::valueOf).collect(Collectors.toSet())));
        Optional.ofNullable(properties.get(ACTIONABLE_SWITCHES_IDS_PARAM_NAME)).ifPresent(prop -> this.setActionableSwitchesIds(new HashSet<String>(OpenLoadFlowParameters.parseStringListProp(prop))));
        Optional.ofNullable(properties.get(ACTIONABLE_TRANSFORMERS_IDS_PARAM_NAME)).ifPresent(prop -> this.setActionableTransformersIds(new HashSet<String>(OpenLoadFlowParameters.parseStringListProp(prop))));
        Optional.ofNullable(properties.get(ASYMMETRICAL_PARAM_NAME)).ifPresent(prop -> this.setAsymmetrical(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(MIN_NOMINAL_VOLTAGE_TARGET_VOLTAGE_CHECK_PARAM_NAME)).ifPresent(prop -> this.setMinNominalVoltageTargetVoltageCheck(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(REACTIVE_POWER_DISPATCH_MODE_PARAM_NAME)).ifPresent(prop -> this.setReactivePowerDispatchMode(ReactivePowerDispatchMode.valueOf(prop)));
        Optional.ofNullable(properties.get(OUTER_LOOP_NAMES_PARAM_NAME)).ifPresent(prop -> this.setOuterLoopNames(OpenLoadFlowParameters.parseStringListProp(prop)));
        Optional.ofNullable(properties.get(USE_ACTIVE_LIMITS_PARAM_NAME)).ifPresent(prop -> this.setUseActiveLimits(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(DISABLE_VOLTAGE_CONTROL_OF_GENERATORS_OUTSIDE_ACTIVE_POWER_LIMITS_PARAM_NAME)).ifPresent(prop -> this.setDisableVoltageControlOfGeneratorsOutsideActivePowerLimits(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(LINE_SEARCH_STATE_VECTOR_SCALING_MAX_ITERATION_PARAM_NAME)).ifPresent(prop -> this.setLineSearchStateVectorScalingMaxIteration(Integer.parseInt(prop)));
        Optional.ofNullable(properties.get(LINE_SEARCH_STATE_VECTOR_SCALING_STEP_FOLD_PARAM_NAME)).ifPresent(prop -> this.setLineSearchStateVectorScalingStepFold(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DV_PARAM_NAME)).ifPresent(prop -> this.setMaxVoltageChangeStateVectorScalingMaxDv(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DPHI_PARAM_NAME)).ifPresent(prop -> this.setMaxVoltageChangeStateVectorScalingMaxDphi(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(LINE_PER_UNIT_MODE_PARAM_NAME)).ifPresent(prop -> this.setLinePerUnitMode(LinePerUnitMode.valueOf(prop)));
        Optional.ofNullable(properties.get(USE_LOAD_MODEL_PARAM_NAME)).ifPresent(prop -> this.setUseLoadModel(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(DC_APPROXIMATION_TYPE_PARAM_NAME)).ifPresent(prop -> this.setDcApproximationType(DcApproximationType.valueOf(prop)));
        Optional.ofNullable(properties.get(SIMULATE_AUTOMATION_SYSTEMS_PARAM_NAME)).ifPresent(prop -> this.setSimulateAutomationSystems(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(AC_SOLVER_TYPE_PARAM_NAME)).ifPresent(prop -> this.setAcSolverType(AcSolverType.valueOf(prop)));
        Optional.ofNullable(properties.get(MAX_NEWTON_KRYLOV_ITERATIONS_PARAM_NAME)).ifPresent(prop -> this.setMaxNewtonKrylovIterations(Integer.parseInt(prop)));
        Optional.ofNullable(properties.get(NEWTON_KRYLOV_LINE_SEARCH_PARAM_NAME)).ifPresent(prop -> this.setNewtonKrylovLineSearch(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(REFERENCE_BUS_SELECTION_MODE_PARAM_NAME)).ifPresent(prop -> this.setReferenceBusSelectionMode(ReferenceBusSelectionMode.valueOf(prop)));
        Optional.ofNullable(properties.get(WRITE_REFERENCE_TERMINALS_PARAM_NAME)).ifPresent(prop -> this.setWriteReferenceTerminals(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(VOLTAGE_TARGET_PRIORITIES_PARAM_NAME)).ifPresent(prop -> this.setVoltageTargetPriorities(OpenLoadFlowParameters.parseStringListProp(prop)));
        Optional.ofNullable(properties.get(TRANSFORMER_VOLTAGE_CONTROL_USE_INITIAL_TAP_POSITION_PARAM_NAME)).ifPresent(prop -> this.setTransformerVoltageControlUseInitialTapPosition(Boolean.parseBoolean(prop)));
        Optional.ofNullable(properties.get(GENERATOR_VOLTAGE_CONTROL_MIN_NOMINAL_VOLTAGE_PARAM_NAME)).ifPresent(prop -> this.setGeneratorVoltageControlMinNominalVoltage(Double.parseDouble(prop)));
        Optional.ofNullable(properties.get(FICTITIOUS_GENERATOR_VOLTAGE_CONTROL_CHECK_MODE)).ifPresent(prop -> this.setFictitiousGeneratorVoltageControlCheckMode(FictitiousGeneratorVoltageControlCheckMode.valueOf(prop)));
        return this;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(66);
        map.put(SLACK_BUS_SELECTION_MODE_PARAM_NAME, (Object)this.slackBusSelectionMode);
        map.put(SLACK_BUSES_IDS_PARAM_NAME, this.slackBusesIds);
        map.put(SLACK_DISTRIBUTION_FAILURE_BEHAVIOR_PARAM_NAME, (Object)this.slackDistributionFailureBehavior);
        map.put(VOLTAGE_REMOTE_CONTROL_PARAM_NAME, this.voltageRemoteControl);
        map.put(LOW_IMPEDANCE_BRANCH_MODE_PARAM_NAME, (Object)this.lowImpedanceBranchMode);
        map.put(LOAD_POWER_FACTOR_CONSTANT_PARAM_NAME, this.loadPowerFactorConstant);
        map.put(PLAUSIBLE_ACTIVE_POWER_LIMIT_PARAM_NAME, this.plausibleActivePowerLimit);
        map.put(NEWTONRAPHSON_STOPPING_CRITERIA_TYPE_PARAM_NAME, (Object)this.newtonRaphsonStoppingCriteriaType);
        map.put(SLACK_BUS_P_MAX_MISMATCH_PARAM_NAME, this.slackBusPMaxMismatch);
        map.put(MAX_ACTIVE_POWER_MISMATCH_PARAM_NAME, this.maxActivePowerMismatch);
        map.put(MAX_REACTIVE_POWER_MISMATCH_PARAM_NAME, this.maxReactivePowerMismatch);
        map.put(MAX_VOLTAGE_MISMATCH_PARAM_NAME, this.maxVoltageMismatch);
        map.put(MAX_ANGLE_MISMATCH_PARAM_NAME, this.maxAngleMismatch);
        map.put(MAX_RATIO_MISMATCH_PARAM_NAME, this.maxRatioMismatch);
        map.put(MAX_SUSCEPTANCE_MISMATCH_PARAM_NAME, this.maxSusceptanceMismatch);
        map.put(VOLTAGE_PER_REACTIVE_POWER_CONTROL_PARAM_NAME, this.voltagePerReactivePowerControl);
        map.put(GENERATOR_REACTIVE_POWER_REMOTE_CONTROL_PARAM_NAME, this.generatorReactivePowerRemoteControl);
        map.put(TRANSFORMER_REACTIVE_POWER_CONTROL_PARAM_NAME, this.transformerReactivePowerControl);
        map.put(MAX_NEWTON_RAPHSON_ITERATIONS_PARAM_NAME, this.maxNewtonRaphsonIterations);
        map.put(MAX_OUTER_LOOP_ITERATIONS_PARAM_NAME, this.maxOuterLoopIterations);
        map.put(NEWTON_RAPHSON_CONV_EPS_PER_EQ_PARAM_NAME, this.newtonRaphsonConvEpsPerEq);
        map.put(VOLTAGE_INIT_MODE_OVERRIDE_PARAM_NAME, (Object)this.voltageInitModeOverride);
        map.put(TRANSFORMER_VOLTAGE_CONTROL_MODE_PARAM_NAME, (Object)this.transformerVoltageControlMode);
        map.put(SHUNT_VOLTAGE_CONTROL_MODE_PARAM_NAME, (Object)this.shuntVoltageControlMode);
        map.put(MIN_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME, this.minPlausibleTargetVoltage);
        map.put(MAX_PLAUSIBLE_TARGET_VOLTAGE_PARAM_NAME, this.maxPlausibleTargetVoltage);
        map.put(MIN_REALISTIC_VOLTAGE_PARAM_NAME, this.minRealisticVoltage);
        map.put(MAX_REALISTIC_VOLTAGE_PARAM_NAME, this.maxRealisticVoltage);
        map.put(REACTIVE_RANGE_CHECK_MODE_PARAM_NAME, (Object)this.reactiveRangeCheckMode);
        map.put(LOW_IMPEDANCE_THRESHOLD_PARAM_NAME, this.lowImpedanceThreshold);
        map.put(NETWORK_CACHE_ENABLED_PARAM_NAME, this.networkCacheEnabled);
        map.put(SVC_VOLTAGE_MONITORING_PARAM_NAME, this.svcVoltageMonitoring);
        map.put(STATE_VECTOR_SCALING_MODE_PARAM_NAME, (Object)this.stateVectorScalingMode);
        map.put(MAX_SLACK_BUS_COUNT_PARAM_NAME, this.maxSlackBusCount);
        map.put(DEBUG_DIR_PARAM_NAME, this.debugDir);
        map.put(INCREMENTAL_TRANSFORMER_RATIO_TAP_CONTROL_OUTER_LOOP_MAX_TAP_SHIFT_PARAM_NAME, this.incrementalTransformerRatioTapControlOuterLoopMaxTapShift);
        map.put(SECONDARY_VOLTAGE_CONTROL_PARAM_NAME, this.secondaryVoltageControl);
        map.put(REACTIVE_LIMITS_MAX_SWITCH_PQ_PV_PARAM_NAME, this.reactiveLimitsMaxPqPvSwitch);
        map.put(PHASE_SHIFTER_CONTROL_MODE_PARAM_NAME, (Object)this.phaseShifterControlMode);
        map.put(ALWAYS_UPDATE_NETWORK_PARAM_NAME, this.alwaysUpdateNetwork);
        map.put(MOST_MESHED_SLACK_BUS_SELECTOR_MAX_NOMINAL_VOLTAGE_PERCENTILE_PARAM_NAME, this.mostMeshedSlackBusSelectorMaxNominalVoltagePercentile);
        map.put(REPORTED_FEATURES_PARAM_NAME, this.reportedFeatures);
        map.put(SLACK_BUS_COUNTRY_FILTER_PARAM_NAME, this.slackBusCountryFilter);
        map.put(ACTIONABLE_SWITCHES_IDS_PARAM_NAME, this.actionableSwitchesIds);
        map.put(ACTIONABLE_TRANSFORMERS_IDS_PARAM_NAME, this.actionableTransformersIds);
        map.put(ASYMMETRICAL_PARAM_NAME, this.asymmetrical);
        map.put(MIN_NOMINAL_VOLTAGE_TARGET_VOLTAGE_CHECK_PARAM_NAME, this.minNominalVoltageTargetVoltageCheck);
        map.put(REACTIVE_POWER_DISPATCH_MODE_PARAM_NAME, (Object)this.reactivePowerDispatchMode);
        map.put(OUTER_LOOP_NAMES_PARAM_NAME, this.outerLoopNames);
        map.put(USE_ACTIVE_LIMITS_PARAM_NAME, this.useActiveLimits);
        map.put(DISABLE_VOLTAGE_CONTROL_OF_GENERATORS_OUTSIDE_ACTIVE_POWER_LIMITS_PARAM_NAME, this.disableVoltageControlOfGeneratorsOutsideActivePowerLimits);
        map.put(LINE_SEARCH_STATE_VECTOR_SCALING_MAX_ITERATION_PARAM_NAME, this.lineSearchStateVectorScalingMaxIteration);
        map.put(LINE_SEARCH_STATE_VECTOR_SCALING_STEP_FOLD_PARAM_NAME, this.lineSearchStateVectorScalingStepFold);
        map.put(MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DV_PARAM_NAME, this.maxVoltageChangeStateVectorScalingMaxDv);
        map.put(MAX_VOLTAGE_CHANGE_STATE_VECTOR_SCALING_MAX_DPHI_PARAM_NAME, this.maxVoltageChangeStateVectorScalingMaxDphi);
        map.put(LINE_PER_UNIT_MODE_PARAM_NAME, (Object)this.linePerUnitMode);
        map.put(USE_LOAD_MODEL_PARAM_NAME, this.useLoadModel);
        map.put(DC_APPROXIMATION_TYPE_PARAM_NAME, (Object)this.dcApproximationType);
        map.put(SIMULATE_AUTOMATION_SYSTEMS_PARAM_NAME, this.simulateAutomationSystems);
        map.put(AC_SOLVER_TYPE_PARAM_NAME, (Object)this.acSolverType);
        map.put(MAX_NEWTON_KRYLOV_ITERATIONS_PARAM_NAME, this.maxNewtonKrylovIterations);
        map.put(NEWTON_KRYLOV_LINE_SEARCH_PARAM_NAME, this.newtonKrylovLineSearch);
        map.put(REFERENCE_BUS_SELECTION_MODE_PARAM_NAME, (Object)this.referenceBusSelectionMode);
        map.put(WRITE_REFERENCE_TERMINALS_PARAM_NAME, this.writeReferenceTerminals);
        map.put(VOLTAGE_TARGET_PRIORITIES_PARAM_NAME, this.voltageTargetPriorities);
        map.put(TRANSFORMER_VOLTAGE_CONTROL_USE_INITIAL_TAP_POSITION_PARAM_NAME, this.transformerVoltageControlUseInitialTapPosition);
        map.put(GENERATOR_VOLTAGE_CONTROL_MIN_NOMINAL_VOLTAGE_PARAM_NAME, this.generatorVoltageControlMinNominalVoltage);
        map.put(FICTITIOUS_GENERATOR_VOLTAGE_CONTROL_CHECK_MODE, (Object)this.fictitiousGeneratorVoltageControlCheckMode);
        return map;
    }

    public String toString() {
        return "OpenLoadFlowParameters(" + this.toMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }

    public static OpenLoadFlowParameters get(LoadFlowParameters parameters) {
        OpenLoadFlowParameters parametersExt = (OpenLoadFlowParameters)parameters.getExtension(OpenLoadFlowParameters.class);
        if (parametersExt == null) {
            parametersExt = new OpenLoadFlowParameters();
        }
        return parametersExt;
    }

    private static OpenLoadFlowParameters create(LoadFlowParameters parameters, Supplier<OpenLoadFlowParameters> parametersExtSupplier) {
        Objects.requireNonNull(parameters);
        OpenLoadFlowParameters parametersExt = parametersExtSupplier.get();
        parameters.addExtension(OpenLoadFlowParameters.class, (Extension)parametersExt);
        return parametersExt;
    }

    public static OpenLoadFlowParameters create(LoadFlowParameters parameters) {
        return OpenLoadFlowParameters.create(parameters, OpenLoadFlowParameters::new);
    }

    public static OpenLoadFlowParameters load(LoadFlowParameters parameters) {
        return OpenLoadFlowParameters.create(parameters, OpenLoadFlowParameters::load);
    }

    public static void log(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        if (LOGGER.isInfoEnabled()) {
            AsciiTable at = new AsciiTable();
            at.addRule();
            at.addRow(new Object[]{"Name", "Value"});
            at.addRule();
            for (Map.Entry entry : parameters.toMap().entrySet()) {
                at.addRow(new Object[]{entry.getKey(), entry.getValue()});
            }
            for (Map.Entry<Object, Object> entry : parametersExt.toMap().entrySet()) {
                at.addRow(new Object[]{entry.getKey(), Objects.toString(entry.getValue(), "")});
            }
            at.addRule();
            at.getRenderer().setCWC((AT_ColumnWidthCalculator)new CWC_LongestWord());
            at.setPaddingLeftRight(1, 1);
            LOGGER.info("Parameters:\n{}", (Object)at.render());
        }
    }

    static VoltageInitializer getVoltageInitializer(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, LfNetworkParameters networkParameters, MatrixFactory matrixFactory) {
        switch (parameters.getVoltageInitMode()) {
            case UNIFORM_VALUES: {
                return new UniformValueVoltageInitializer();
            }
            case PREVIOUS_VALUES: {
                return new PreviousValueVoltageInitializer();
            }
            case DC_VALUES: {
                return new DcValueVoltageInitializer(networkParameters, parameters.isDistributedSlack(), parameters.getBalanceType(), parameters.isDcUseTransformerRatio(), parametersExt.getDcApproximationType(), matrixFactory, parametersExt.getMaxOuterLoopIterations());
            }
        }
        throw new UnsupportedOperationException("Unsupported voltage init mode: " + parameters.getVoltageInitMode());
    }

    static VoltageInitializer getExtendedVoltageInitializer(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, LfNetworkParameters networkParameters, MatrixFactory matrixFactory) {
        switch (parametersExt.getVoltageInitModeOverride()) {
            case NONE: {
                return OpenLoadFlowParameters.getVoltageInitializer(parameters, parametersExt, networkParameters, matrixFactory);
            }
            case VOLTAGE_MAGNITUDE: {
                return new VoltageMagnitudeInitializer(parameters.isTransformerVoltageControlOn(), matrixFactory, networkParameters.getLowImpedanceThreshold());
            }
            case FULL_VOLTAGE: {
                return new FullVoltageInitializer(new VoltageMagnitudeInitializer(parameters.isTransformerVoltageControlOn(), matrixFactory, networkParameters.getLowImpedanceThreshold()), new DcValueVoltageInitializer(networkParameters, parameters.isDistributedSlack(), parameters.getBalanceType(), parameters.isDcUseTransformerRatio(), parametersExt.getDcApproximationType(), matrixFactory, parametersExt.getMaxOuterLoopIterations()));
            }
        }
        throw new PowsyblException("Unknown voltage init mode override: " + parametersExt.getVoltageInitModeOverride());
    }

    static LfNetworkParameters getNetworkParameters(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, SlackBusSelector slackBusSelector, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, boolean breakers) {
        return new LfNetworkParameters().setSlackBusSelector(slackBusSelector).setConnectivityFactory(connectivityFactory).setGeneratorVoltageRemoteControl(parametersExt.isVoltageRemoteControl()).setMinImpedance(parametersExt.getLowImpedanceBranchMode() == LowImpedanceBranchMode.REPLACE_BY_MIN_IMPEDANCE_LINE).setTwtSplitShuntAdmittance(parameters.isTwtSplitShuntAdmittance()).setBreakers(breakers).setPlausibleActivePowerLimit(parametersExt.getPlausibleActivePowerLimit()).setUseActiveLimits(parametersExt.isUseActiveLimits()).setDisableVoltageControlOfGeneratorsOutsideActivePowerLimits(parametersExt.isDisableVoltageControlOfGeneratorsOutsideActivePowerLimits()).setComputeMainConnectedComponentOnly(parameters.getConnectedComponentMode() == LoadFlowParameters.ConnectedComponentMode.MAIN).setCountriesToBalance(parameters.getCountriesToBalance()).setDistributedOnConformLoad(parameters.isDistributedSlack() && parameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setPhaseControl(parameters.isPhaseShifterRegulationOn()).setTransformerVoltageControl(parameters.isTransformerVoltageControlOn()).setVoltagePerReactivePowerControl(parametersExt.isVoltagePerReactivePowerControl()).setGeneratorReactivePowerRemoteControl(parametersExt.isGeneratorReactivePowerRemoteControl()).setTransformerReactivePowerControl(parametersExt.isTransformerReactivePowerControl()).setLoadFlowModel(parameters.isDc() ? LoadFlowModel.DC : LoadFlowModel.AC).setShuntVoltageControl(parameters.isShuntCompensatorVoltageControlOn()).setReactiveLimits(parameters.isUseReactiveLimits()).setHvdcAcEmulation(parameters.isHvdcAcEmulation()).setMinPlausibleTargetVoltage(parametersExt.getMinPlausibleTargetVoltage()).setMaxPlausibleTargetVoltage(parametersExt.getMaxPlausibleTargetVoltage()).setReactiveRangeCheckMode(parametersExt.getReactiveRangeCheckMode()).setLowImpedanceThreshold(parametersExt.getLowImpedanceThreshold()).setSvcVoltageMonitoring(parametersExt.isSvcVoltageMonitoring()).setMaxSlackBusCount(parametersExt.getMaxSlackBusCount()).setDebugDir(parametersExt.getDebugDir()).setSecondaryVoltageControl(parametersExt.isSecondaryVoltageControl()).setCacheEnabled(parametersExt.isNetworkCacheEnabled()).setAsymmetrical(parametersExt.isAsymmetrical()).setMinNominalVoltageTargetVoltageCheck(parametersExt.getMinNominalVoltageTargetVoltageCheck()).setLinePerUnitMode(parametersExt.getLinePerUnitMode()).setUseLoadModel(parametersExt.isUseLoadModel()).setSimulateAutomationSystems(parametersExt.isSimulateAutomationSystems()).setReferenceBusSelector(ReferenceBusSelector.fromMode(parametersExt.getReferenceBusSelectionMode())).setVoltageTargetPriorities(parametersExt.getVoltageTargetPriorities()).setFictitiousGeneratorVoltageControlCheckMode(parametersExt.getFictitiousGeneratorVoltageControlCheckMode());
    }

    public static AcLoadFlowParameters createAcParameters(Network network, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory) {
        return OpenLoadFlowParameters.createAcParameters(network, parameters, parametersExt, matrixFactory, connectivityFactory, false, false);
    }

    public static AcLoadFlowParameters createAcParameters(Network network, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, boolean breakers, boolean forceA1Var) {
        AcLoadFlowParameters acParameters = OpenLoadFlowParameters.createAcParameters(parameters, parametersExt, matrixFactory, connectivityFactory, breakers, forceA1Var);
        if (parameters.isReadSlackBus()) {
            acParameters.getNetworkParameters().setSlackBusSelector(new NetworkSlackBusSelector(network, parametersExt.getSlackBusCountryFilter(), acParameters.getNetworkParameters().getSlackBusSelector()));
        }
        return acParameters;
    }

    private static NewtonRaphsonStoppingCriteria createNewtonRaphsonStoppingCriteria(OpenLoadFlowParameters parametersExt) {
        return switch (parametersExt.getNewtonRaphsonStoppingCriteriaType()) {
            default -> throw new IncompatibleClassChangeError();
            case NewtonRaphsonStoppingCriteriaType.UNIFORM_CRITERIA -> new DefaultNewtonRaphsonStoppingCriteria(parametersExt.getNewtonRaphsonConvEpsPerEq());
            case NewtonRaphsonStoppingCriteriaType.PER_EQUATION_TYPE_CRITERIA -> new PerEquationTypeStoppingCriteria(parametersExt.getNewtonRaphsonConvEpsPerEq(), parametersExt.getMaxActivePowerMismatch(), parametersExt.getMaxReactivePowerMismatch(), parametersExt.getMaxVoltageMismatch(), parametersExt.getMaxAngleMismatch(), parametersExt.getMaxRatioMismatch(), parametersExt.getMaxSusceptanceMismatch());
        };
    }

    static List<AcOuterLoop> createOuterLoops(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        AcOuterLoopConfig outerLoopConfig = AcOuterLoopConfig.findOuterLoopConfig().orElseGet(() -> parametersExt.getOuterLoopNames() != null ? new ExplicitAcOuterLoopConfig() : new DefaultAcOuterLoopConfig());
        return outerLoopConfig.configure(parameters, parametersExt);
    }

    public static AcLoadFlowParameters createAcParameters(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, boolean breakers, boolean forceA1Var) {
        SlackBusSelector slackBusSelector = SlackBusSelector.fromMode(parametersExt.getSlackBusSelectionMode(), parametersExt.getSlackBusesIds(), parametersExt.getPlausibleActivePowerLimit(), parametersExt.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(), parametersExt.getSlackBusCountryFilter());
        LfNetworkParameters networkParameters = OpenLoadFlowParameters.getNetworkParameters(parameters, parametersExt, slackBusSelector, connectivityFactory, breakers);
        AcEquationSystemCreationParameters equationSystemCreationParameters = new AcEquationSystemCreationParameters(forceA1Var);
        VoltageInitializer voltageInitializer = OpenLoadFlowParameters.getExtendedVoltageInitializer(parameters, parametersExt, networkParameters, matrixFactory);
        NewtonRaphsonParameters newtonRaphsonParameters = ((NewtonRaphsonParameters)new NewtonRaphsonParameters().setStoppingCriteria(OpenLoadFlowParameters.createNewtonRaphsonStoppingCriteria(parametersExt)).setMaxIterations(parametersExt.getMaxNewtonRaphsonIterations())).setMinRealisticVoltage(parametersExt.getMinRealisticVoltage()).setMaxRealisticVoltage(parametersExt.getMaxRealisticVoltage()).setStateVectorScalingMode(parametersExt.getStateVectorScalingMode()).setLineSearchStateVectorScalingMaxIteration(parametersExt.getLineSearchStateVectorScalingMaxIteration()).setLineSearchStateVectorScalingStepFold(parametersExt.getLineSearchStateVectorScalingStepFold()).setMaxVoltageChangeStateVectorScalingMaxDv(parametersExt.getMaxVoltageChangeStateVectorScalingMaxDv()).setMaxVoltageChangeStateVectorScalingMaxDphi(parametersExt.getMaxVoltageChangeStateVectorScalingMaxDphi()).setAlwaysUpdateNetwork(parametersExt.isAlwaysUpdateNetwork());
        NewtonKrylovParameters newtonKrylovParameters = (NewtonKrylovParameters)new NewtonKrylovParameters().setLineSearch(parametersExt.isNewtonKrylovLineSearch()).setMaxIterations(parametersExt.getMaxNewtonKrylovIterations());
        List<AcOuterLoop> outerLoops = OpenLoadFlowParameters.createOuterLoops(parameters, parametersExt);
        AcSolverFactory solverFactory = switch (parametersExt.getAcSolverType()) {
            default -> throw new IncompatibleClassChangeError();
            case AcSolverType.NEWTON_RAPHSON -> new NewtonRaphsonFactory();
            case AcSolverType.NEWTON_KRYLOV -> new NewtonKrylovFactory();
        };
        return ((AcLoadFlowParameters)((AcLoadFlowParameters)new AcLoadFlowParameters().setNetworkParameters(networkParameters)).setEquationSystemCreationParameters(equationSystemCreationParameters).setNewtonRaphsonParameters(newtonRaphsonParameters).setNewtonKrylovParameters(newtonKrylovParameters).setOuterLoops(outerLoops).setMaxOuterLoopIterations(parametersExt.getMaxOuterLoopIterations()).setMatrixFactory(matrixFactory)).setVoltageInitializer(voltageInitializer).setAsymmetrical(parametersExt.isAsymmetrical()).setSlackDistributionFailureBehavior(parametersExt.getSlackDistributionFailureBehavior()).setSolverFactory(solverFactory);
    }

    public static DcLoadFlowParameters createDcParameters(Network network, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, boolean forcePhaseControlOffAndAddAngle1Var) {
        DcLoadFlowParameters dcParameters = OpenLoadFlowParameters.createDcParameters(parameters, parametersExt, matrixFactory, connectivityFactory, forcePhaseControlOffAndAddAngle1Var);
        if (parameters.isReadSlackBus()) {
            dcParameters.getNetworkParameters().setSlackBusSelector(new NetworkSlackBusSelector(network, parametersExt.getSlackBusCountryFilter(), dcParameters.getNetworkParameters().getSlackBusSelector()));
        }
        return dcParameters;
    }

    public static DcLoadFlowParameters createDcParameters(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, boolean forcePhaseControlOffAndAddAngle1Var) {
        SlackBusSelector slackBusSelector = SlackBusSelector.fromMode(parametersExt.getSlackBusSelectionMode(), parametersExt.getSlackBusesIds(), parametersExt.getPlausibleActivePowerLimit(), parametersExt.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(), parametersExt.getSlackBusCountryFilter());
        LfNetworkParameters networkParameters = new LfNetworkParameters().setSlackBusSelector(slackBusSelector).setConnectivityFactory(connectivityFactory).setGeneratorVoltageRemoteControl(false).setMinImpedance(parametersExt.getLowImpedanceBranchMode() == LowImpedanceBranchMode.REPLACE_BY_MIN_IMPEDANCE_LINE).setTwtSplitShuntAdmittance(false).setBreakers(false).setPlausibleActivePowerLimit(parametersExt.getPlausibleActivePowerLimit()).setUseActiveLimits(parametersExt.isUseActiveLimits()).setDisableVoltageControlOfGeneratorsOutsideActivePowerLimits(parametersExt.isDisableVoltageControlOfGeneratorsOutsideActivePowerLimits()).setComputeMainConnectedComponentOnly(parameters.getConnectedComponentMode() == LoadFlowParameters.ConnectedComponentMode.MAIN).setCountriesToBalance(parameters.getCountriesToBalance()).setDistributedOnConformLoad(parameters.isDistributedSlack() && parameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setPhaseControl(parameters.isPhaseShifterRegulationOn()).setTransformerVoltageControl(false).setVoltagePerReactivePowerControl(false).setGeneratorReactivePowerRemoteControl(false).setTransformerReactivePowerControl(false).setLoadFlowModel(LoadFlowModel.DC).setShuntVoltageControl(false).setReactiveLimits(false).setHvdcAcEmulation(parameters.isHvdcAcEmulation()).setLowImpedanceThreshold(parametersExt.getLowImpedanceThreshold()).setSvcVoltageMonitoring(false).setMaxSlackBusCount(1).setLinePerUnitMode(parametersExt.getLinePerUnitMode());
        DcEquationSystemCreationParameters equationSystemCreationParameters = new DcEquationSystemCreationParameters().setUpdateFlows(true).setForcePhaseControlOffAndAddAngle1Var(forcePhaseControlOffAndAddAngle1Var).setUseTransformerRatio(parameters.isDcUseTransformerRatio()).setDcApproximationType(parametersExt.getDcApproximationType()).setDcPowerFactor(parameters.getDcPowerFactor());
        return ((DcLoadFlowParameters)((DcLoadFlowParameters)new DcLoadFlowParameters().setNetworkParameters(networkParameters)).setEquationSystemCreationParameters(equationSystemCreationParameters).setMatrixFactory(matrixFactory)).setDistributedSlack(parameters.isDistributedSlack()).setBalanceType(parameters.getBalanceType()).setSetVToNan(true).setMaxOuterLoopIterations(parametersExt.getMaxOuterLoopIterations());
    }

    public static boolean equals(LoadFlowParameters parameters1, LoadFlowParameters parameters2) {
        boolean equals;
        Objects.requireNonNull(parameters1);
        Objects.requireNonNull(parameters2);
        boolean bl = equals = parameters1.getVoltageInitMode() == parameters2.getVoltageInitMode() && parameters1.isTransformerVoltageControlOn() == parameters2.isTransformerVoltageControlOn() && parameters1.isUseReactiveLimits() == parameters2.isUseReactiveLimits() && parameters1.isPhaseShifterRegulationOn() == parameters2.isPhaseShifterRegulationOn() && parameters1.isTwtSplitShuntAdmittance() == parameters2.isTwtSplitShuntAdmittance() && parameters1.isShuntCompensatorVoltageControlOn() == parameters2.isShuntCompensatorVoltageControlOn() && parameters1.isReadSlackBus() == parameters2.isReadSlackBus() && parameters1.isWriteSlackBus() == parameters2.isWriteSlackBus() && parameters1.isDc() == parameters2.isDc() && parameters1.isDistributedSlack() == parameters2.isDistributedSlack() && parameters1.getBalanceType() == parameters2.getBalanceType() && parameters1.isDcUseTransformerRatio() == parameters2.isDcUseTransformerRatio() && parameters1.getCountriesToBalance().equals(parameters2.getCountriesToBalance()) && parameters1.getConnectedComponentMode() == parameters2.getConnectedComponentMode() && parameters1.isHvdcAcEmulation() == parameters2.isHvdcAcEmulation() && parameters1.getDcPowerFactor() == parameters2.getDcPowerFactor();
        if (!equals) {
            return false;
        }
        OpenLoadFlowParameters extension1 = (OpenLoadFlowParameters)parameters1.getExtension(OpenLoadFlowParameters.class);
        OpenLoadFlowParameters extension2 = (OpenLoadFlowParameters)parameters2.getExtension(OpenLoadFlowParameters.class);
        if (extension1 == null && extension2 == null) {
            return true;
        }
        if (extension1 == null) {
            return false;
        }
        if (extension2 == null) {
            return false;
        }
        return extension1.getSlackBusSelectionMode() == extension2.getSlackBusSelectionMode() && extension1.getSlackBusesIds().equals(extension2.getSlackBusesIds()) && extension1.getSlackDistributionFailureBehavior() == extension2.getSlackDistributionFailureBehavior() && extension1.isVoltageRemoteControl() == extension2.isVoltageRemoteControl() && extension1.getLowImpedanceBranchMode() == extension2.getLowImpedanceBranchMode() && extension1.isLoadPowerFactorConstant() == extension2.isLoadPowerFactorConstant() && extension1.getPlausibleActivePowerLimit() == extension2.getPlausibleActivePowerLimit() && extension1.getSlackBusPMaxMismatch() == extension2.getSlackBusPMaxMismatch() && extension1.isVoltagePerReactivePowerControl() == extension2.isVoltagePerReactivePowerControl() && extension1.isGeneratorReactivePowerRemoteControl() == extension2.isGeneratorReactivePowerRemoteControl() && extension1.isTransformerReactivePowerControl() == extension2.isTransformerReactivePowerControl() && extension1.getMaxNewtonRaphsonIterations() == extension2.getMaxNewtonRaphsonIterations() && extension1.getMaxOuterLoopIterations() == extension2.getMaxOuterLoopIterations() && extension1.getNewtonRaphsonConvEpsPerEq() == extension2.getNewtonRaphsonConvEpsPerEq() && extension1.getVoltageInitModeOverride() == extension2.getVoltageInitModeOverride() && extension1.getTransformerVoltageControlMode() == extension2.getTransformerVoltageControlMode() && extension1.getShuntVoltageControlMode() == extension2.getShuntVoltageControlMode() && extension1.getMinPlausibleTargetVoltage() == extension2.getMinPlausibleTargetVoltage() && extension1.getMaxPlausibleTargetVoltage() == extension2.getMaxPlausibleTargetVoltage() && extension1.getMinRealisticVoltage() == extension2.getMinRealisticVoltage() && extension1.getMaxRealisticVoltage() == extension2.getMaxRealisticVoltage() && extension1.getReactiveRangeCheckMode() == extension2.getReactiveRangeCheckMode() && extension1.getLowImpedanceThreshold() == extension2.getLowImpedanceThreshold() && extension1.isNetworkCacheEnabled() == extension2.isNetworkCacheEnabled() && extension1.isSvcVoltageMonitoring() == extension2.isSvcVoltageMonitoring() && extension1.getStateVectorScalingMode() == extension2.getStateVectorScalingMode() && extension1.getMaxSlackBusCount() == extension2.getMaxSlackBusCount() && Objects.equals(extension1.getDebugDir(), extension2.getDebugDir()) && extension1.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift() == extension2.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift() && extension1.isSecondaryVoltageControl() == extension2.isSecondaryVoltageControl() && extension1.getReactiveLimitsMaxPqPvSwitch() == extension2.getReactiveLimitsMaxPqPvSwitch() && extension1.getPhaseShifterControlMode() == extension2.getPhaseShifterControlMode() && extension1.isAlwaysUpdateNetwork() == extension2.isAlwaysUpdateNetwork() && extension1.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile() == extension2.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile() && extension1.getReportedFeatures().equals(extension2.getReportedFeatures()) && extension1.getSlackBusCountryFilter().equals(extension2.getSlackBusCountryFilter()) && extension1.getActionableSwitchesIds().equals(extension2.getActionableSwitchesIds()) && extension1.getActionableTransformersIds().equals(extension2.getActionableTransformersIds()) && extension1.isAsymmetrical() == extension2.isAsymmetrical() && extension1.getMinNominalVoltageTargetVoltageCheck() == extension2.getMinNominalVoltageTargetVoltageCheck() && extension1.getReactivePowerDispatchMode() == extension2.getReactivePowerDispatchMode() && Objects.equals(extension1.getOuterLoopNames(), extension2.getOuterLoopNames()) && extension1.isUseActiveLimits() == extension2.isUseActiveLimits() && extension1.isDisableVoltageControlOfGeneratorsOutsideActivePowerLimits() == extension2.isDisableVoltageControlOfGeneratorsOutsideActivePowerLimits() && extension1.getLineSearchStateVectorScalingMaxIteration() == extension2.getLineSearchStateVectorScalingMaxIteration() && extension1.getLineSearchStateVectorScalingStepFold() == extension2.getLineSearchStateVectorScalingStepFold() && extension1.getMaxVoltageChangeStateVectorScalingMaxDv() == extension2.getMaxVoltageChangeStateVectorScalingMaxDv() && extension1.getMaxVoltageChangeStateVectorScalingMaxDphi() == extension2.getMaxVoltageChangeStateVectorScalingMaxDphi() && extension1.getLinePerUnitMode() == extension2.getLinePerUnitMode() && extension1.isUseLoadModel() == extension2.isUseLoadModel() && extension1.getDcApproximationType() == extension2.getDcApproximationType() && extension1.isSimulateAutomationSystems() == extension2.isSimulateAutomationSystems() && extension1.getAcSolverType() == extension2.getAcSolverType() && extension1.getMaxNewtonKrylovIterations() == extension2.getMaxNewtonKrylovIterations() && extension1.isNewtonKrylovLineSearch() == extension2.isNewtonKrylovLineSearch() && extension1.getReferenceBusSelectionMode() == extension2.getReferenceBusSelectionMode() && extension1.isWriteReferenceTerminals() == extension2.isWriteReferenceTerminals() && extension1.getMaxActivePowerMismatch() == extension2.getMaxActivePowerMismatch() && extension1.getMaxReactivePowerMismatch() == extension2.getMaxReactivePowerMismatch() && extension1.getMaxVoltageMismatch() == extension2.getMaxVoltageMismatch() && extension1.getMaxAngleMismatch() == extension2.getMaxAngleMismatch() && extension1.getMaxRatioMismatch() == extension2.getMaxRatioMismatch() && extension1.getMaxSusceptanceMismatch() == extension2.getMaxSusceptanceMismatch() && extension1.getNewtonRaphsonStoppingCriteriaType() == extension2.getNewtonRaphsonStoppingCriteriaType() && Objects.equals(extension1.getVoltageTargetPriorities(), extension2.getVoltageTargetPriorities()) && extension1.isTransformerVoltageControlUseInitialTapPosition() == extension2.isTransformerVoltageControlUseInitialTapPosition() && extension1.getGeneratorVoltageControlMinNominalVoltage() == extension2.getGeneratorVoltageControlMinNominalVoltage() && extension1.getFictitiousGeneratorVoltageControlCheckMode() == extension2.getFictitiousGeneratorVoltageControlCheckMode();
    }

    public static LoadFlowParameters clone(LoadFlowParameters parameters) {
        OpenLoadFlowParameters extension2;
        Objects.requireNonNull(parameters);
        LoadFlowParameters parameters2 = new LoadFlowParameters().setVoltageInitMode(parameters.getVoltageInitMode()).setTransformerVoltageControlOn(parameters.isTransformerVoltageControlOn()).setUseReactiveLimits(parameters.isUseReactiveLimits()).setPhaseShifterRegulationOn(parameters.isPhaseShifterRegulationOn()).setTwtSplitShuntAdmittance(parameters.isTwtSplitShuntAdmittance()).setShuntCompensatorVoltageControlOn(parameters.isShuntCompensatorVoltageControlOn()).setReadSlackBus(parameters.isReadSlackBus()).setWriteSlackBus(parameters.isWriteSlackBus()).setDc(parameters.isDc()).setDistributedSlack(parameters.isDistributedSlack()).setBalanceType(parameters.getBalanceType()).setDcUseTransformerRatio(parameters.isDcUseTransformerRatio()).setCountriesToBalance(new HashSet(parameters.getCountriesToBalance())).setConnectedComponentMode(parameters.getConnectedComponentMode()).setHvdcAcEmulation(parameters.isHvdcAcEmulation()).setDcPowerFactor(parameters.getDcPowerFactor());
        OpenLoadFlowParameters extension = (OpenLoadFlowParameters)parameters.getExtension(OpenLoadFlowParameters.class);
        if (extension != null && (extension2 = new OpenLoadFlowParameters().setSlackBusSelectionMode(extension.getSlackBusSelectionMode()).setSlackBusesIds(new ArrayList<String>(extension.getSlackBusesIds())).setSlackDistributionFailureBehavior(extension.getSlackDistributionFailureBehavior()).setVoltageRemoteControl(extension.isVoltageRemoteControl()).setLowImpedanceBranchMode(extension.getLowImpedanceBranchMode()).setLoadPowerFactorConstant(extension.isLoadPowerFactorConstant()).setPlausibleActivePowerLimit(extension.getPlausibleActivePowerLimit()).setSlackBusPMaxMismatch(extension.getSlackBusPMaxMismatch()).setVoltagePerReactivePowerControl(extension.isVoltagePerReactivePowerControl()).setGeneratorReactivePowerRemoteControl(extension.isGeneratorReactivePowerRemoteControl()).setTransformerReactivePowerControl(extension.isTransformerReactivePowerControl()).setMaxNewtonRaphsonIterations(extension.getMaxNewtonRaphsonIterations()).setMaxOuterLoopIterations(extension.getMaxOuterLoopIterations()).setNewtonRaphsonConvEpsPerEq(extension.getNewtonRaphsonConvEpsPerEq()).setVoltageInitModeOverride(extension.getVoltageInitModeOverride()).setTransformerVoltageControlMode(extension.getTransformerVoltageControlMode()).setShuntVoltageControlMode(extension.getShuntVoltageControlMode()).setMinPlausibleTargetVoltage(extension.getMinPlausibleTargetVoltage()).setMaxPlausibleTargetVoltage(extension.getMaxPlausibleTargetVoltage()).setMinRealisticVoltage(extension.getMinRealisticVoltage()).setMaxRealisticVoltage(extension.getMaxRealisticVoltage()).setReactiveRangeCheckMode(extension.getReactiveRangeCheckMode()).setLowImpedanceThreshold(extension.getLowImpedanceThreshold()).setNetworkCacheEnabled(extension.isNetworkCacheEnabled()).setSvcVoltageMonitoring(extension.isSvcVoltageMonitoring()).setStateVectorScalingMode(extension.getStateVectorScalingMode()).setMaxSlackBusCount(extension.getMaxSlackBusCount()).setDebugDir(extension.getDebugDir()).setIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(extension.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift()).setSecondaryVoltageControl(extension.isSecondaryVoltageControl()).setReactiveLimitsMaxPqPvSwitch(extension.getReactiveLimitsMaxPqPvSwitch()).setPhaseShifterControlMode(extension.getPhaseShifterControlMode()).setAlwaysUpdateNetwork(extension.isAlwaysUpdateNetwork()).setMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(extension.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile()).setReportedFeatures(extension.getReportedFeatures()).setSlackBusCountryFilter(new HashSet<Country>(extension.getSlackBusCountryFilter())).setActionableSwitchesIds(new HashSet<String>(extension.getActionableSwitchesIds())).setActionableTransformersIds(new HashSet<String>(extension.getActionableTransformersIds())).setAsymmetrical(extension.isAsymmetrical()).setMinNominalVoltageTargetVoltageCheck(extension.getMinNominalVoltageTargetVoltageCheck()).setReactivePowerDispatchMode(extension.getReactivePowerDispatchMode()).setOuterLoopNames(extension.getOuterLoopNames()).setUseActiveLimits(extension.isUseActiveLimits()).setDisableVoltageControlOfGeneratorsOutsideActivePowerLimits(extension.isDisableVoltageControlOfGeneratorsOutsideActivePowerLimits()).setLineSearchStateVectorScalingMaxIteration(extension.getLineSearchStateVectorScalingMaxIteration()).setLineSearchStateVectorScalingStepFold(extension.getLineSearchStateVectorScalingStepFold()).setMaxVoltageChangeStateVectorScalingMaxDv(extension.getMaxVoltageChangeStateVectorScalingMaxDv()).setMaxVoltageChangeStateVectorScalingMaxDphi(extension.getMaxVoltageChangeStateVectorScalingMaxDphi()).setLinePerUnitMode(extension.getLinePerUnitMode()).setUseLoadModel(extension.isUseLoadModel()).setDcApproximationType(extension.getDcApproximationType()).setAcSolverType(extension.getAcSolverType()).setMaxNewtonKrylovIterations(extension.getMaxNewtonKrylovIterations()).setNewtonKrylovLineSearch(extension.isNewtonKrylovLineSearch()).setSimulateAutomationSystems(extension.isSimulateAutomationSystems()).setWriteReferenceTerminals(extension.isWriteReferenceTerminals()).setMaxActivePowerMismatch(extension.getMaxActivePowerMismatch()).setMaxReactivePowerMismatch(extension.getMaxReactivePowerMismatch()).setMaxVoltageMismatch(extension.getMaxVoltageMismatch()).setMaxAngleMismatch(extension.getMaxAngleMismatch()).setMaxRatioMismatch(extension.getMaxRatioMismatch()).setMaxSusceptanceMismatch(extension.getMaxSusceptanceMismatch()).setNewtonRaphsonStoppingCriteriaType(extension.getNewtonRaphsonStoppingCriteriaType()).setReferenceBusSelectionMode(extension.getReferenceBusSelectionMode()).setVoltageTargetPriorities(extension.getVoltageTargetPriorities()).setTransformerVoltageControlUseInitialTapPosition(extension.isTransformerVoltageControlUseInitialTapPosition()).setGeneratorVoltageControlMinNominalVoltage(extension.getGeneratorVoltageControlMinNominalVoltage()).setFictitiousGeneratorVoltageControlCheckMode(extension.getFictitiousGeneratorVoltageControlCheckMode())) != null) {
            parameters2.addExtension(OpenLoadFlowParameters.class, (Extension)extension2);
        }
        return parameters2;
    }

    public static enum SlackDistributionFailureBehavior {
        THROW,
        FAIL,
        LEAVE_ON_SLACK_BUS,
        DISTRIBUTE_ON_REFERENCE_GENERATOR;

    }

    public static enum LowImpedanceBranchMode {
        REPLACE_BY_ZERO_IMPEDANCE_LINE,
        REPLACE_BY_MIN_IMPEDANCE_LINE;

    }

    public static enum VoltageInitModeOverride {
        NONE,
        VOLTAGE_MAGNITUDE,
        FULL_VOLTAGE;

    }

    public static enum TransformerVoltageControlMode {
        WITH_GENERATOR_VOLTAGE_CONTROL,
        AFTER_GENERATOR_VOLTAGE_CONTROL,
        INCREMENTAL_VOLTAGE_CONTROL;

    }

    public static enum ShuntVoltageControlMode {
        WITH_GENERATOR_VOLTAGE_CONTROL,
        INCREMENTAL_VOLTAGE_CONTROL;

    }

    public static enum ReactiveRangeCheckMode {
        MIN_MAX,
        MAX,
        TARGET_P;

    }

    public static enum PhaseShifterControlMode {
        CONTINUOUS_WITH_DISCRETISATION,
        INCREMENTAL;

    }

    public static enum FictitiousGeneratorVoltageControlCheckMode {
        FORCED,
        NORMAL;

    }

    public static enum ReportedFeatures {
        NEWTON_RAPHSON_LOAD_FLOW,
        NEWTON_RAPHSON_SECURITY_ANALYSIS,
        NEWTON_RAPHSON_SENSITIVITY_ANALYSIS;

    }
}

