/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow;

import com.google.auto.service.AutoService;
import com.google.common.base.Stopwatch;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.ReferenceTerminals;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowProvider;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.loadflow.LoadFlowResultImpl;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.math.matrix.SparseMatrixFactory;
import com.powsybl.openloadflow.AcLoadFlowFromCache;
import com.powsybl.openloadflow.NetworkCache;
import com.powsybl.openloadflow.OpenLoadFlowParameterJsonSerializer;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.AcloadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowResult;
import com.powsybl.openloadflow.graph.EvenShiloachGraphDecrementalConnectivityFactory;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.graph.NaiveGraphConnectivityFactory;
import com.powsybl.openloadflow.lf.AbstractLoadFlowResult;
import com.powsybl.openloadflow.lf.LoadFlowResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoop;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LfZeroImpedanceNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.ReactivePowerDispatchMode;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.LfNetworkLoaderImpl;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.util.ZeroImpedanceFlows;
import com.powsybl.openloadflow.util.Markers;
import com.powsybl.openloadflow.util.PowsyblOpenLoadFlowVersion;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.tools.PowsyblCoreVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={LoadFlowProvider.class})
public class OpenLoadFlowProvider
implements LoadFlowProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenLoadFlowProvider.class);
    private final MatrixFactory matrixFactory;
    private final GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory;
    private boolean forcePhaseControlOffAndAddAngle1Var = false;

    public OpenLoadFlowProvider() {
        this((MatrixFactory)new SparseMatrixFactory());
    }

    public OpenLoadFlowProvider(MatrixFactory matrixFactory) {
        this(matrixFactory, new EvenShiloachGraphDecrementalConnectivityFactory<LfBus, LfBranch>());
    }

    public OpenLoadFlowProvider(MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory) {
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        this.connectivityFactory = Objects.requireNonNull(connectivityFactory);
    }

    public void setForcePhaseControlOffAndAddAngle1Var(boolean forcePhaseControlOffAndAddAngle1Var) {
        this.forcePhaseControlOffAndAddAngle1Var = forcePhaseControlOffAndAddAngle1Var;
    }

    public String getName() {
        return "OpenLoadFlow";
    }

    public String getVersion() {
        return new PowsyblCoreVersion().getMavenProjectVersion();
    }

    private GraphConnectivityFactory<LfBus, LfBranch> getConnectivityFactory(OpenLoadFlowParameters parametersExt) {
        return parametersExt.isNetworkCacheEnabled() && !parametersExt.getActionableSwitchesIds().isEmpty() || parametersExt.isSimulateAutomationSystems() ? new NaiveGraphConnectivityFactory(LfElement::getNum) : this.connectivityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAcState(Network network, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, AcLoadFlowResult result, AcLoadFlowParameters acParameters, boolean atLeastOneComponentHasToBeUpdated) {
        if (parametersExt.isNetworkCacheEnabled()) {
            NetworkCache.INSTANCE.findEntry(network).orElseThrow().setPause(true);
        }
        try {
            if (atLeastOneComponentHasToBeUpdated || parametersExt.isAlwaysUpdateNetwork()) {
                LfNetworkStateUpdateParameters updateParameters = new LfNetworkStateUpdateParameters(parameters.isUseReactiveLimits(), parameters.isWriteSlackBus(), parameters.isPhaseShifterRegulationOn(), parameters.isTransformerVoltageControlOn(), parametersExt.isTransformerReactivePowerControl(), parameters.isDistributedSlack() && (parameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_LOAD || parameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD) && parametersExt.isLoadPowerFactorConstant(), parameters.isDc(), acParameters.getNetworkParameters().isBreakers(), parametersExt.getReactivePowerDispatchMode(), parametersExt.isWriteReferenceTerminals(), parametersExt.getReferenceBusSelectionMode(), parametersExt.isSimulateAutomationSystems());
                result.getNetwork().updateState(updateParameters);
                this.computeZeroImpedanceFlows(result.getNetwork(), LoadFlowModel.AC);
            }
        }
        finally {
            if (parametersExt.isNetworkCacheEnabled()) {
                NetworkCache.INSTANCE.findEntry(network).orElseThrow().setPause(false);
            }
        }
    }

    private LoadFlowResult runAc(Network network, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, ReportNode reportNode) {
        List<AcLoadFlowResult> results;
        GraphConnectivityFactory<LfBus, LfBranch> selectedConnectivityFactory = this.getConnectivityFactory(parametersExt);
        AcLoadFlowParameters acParameters = OpenLoadFlowParameters.createAcParameters(network, parameters, parametersExt, this.matrixFactory, selectedConnectivityFactory);
        acParameters.setDetailedReport(parametersExt.getReportedFeatures().contains((Object)OpenLoadFlowParameters.ReportedFeatures.NEWTON_RAPHSON_LOAD_FLOW));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Outer loops: {}", acParameters.getOuterLoops().stream().map(OuterLoop::getName).toList());
        }
        if (parametersExt.isNetworkCacheEnabled()) {
            results = new AcLoadFlowFromCache(network, parameters, parametersExt, acParameters, reportNode).run();
        } else {
            try (LfNetworkList lfNetworkList = Networks.load(network, acParameters.getNetworkParameters(), new LfTopoConfig(), reportNode);){
                results = AcloadFlowEngine.run(lfNetworkList.getList(), acParameters);
            }
        }
        boolean atLeastOneComponentHasToBeUpdated = results.stream().anyMatch(AcLoadFlowResult::isWithNetworkUpdate);
        if (atLeastOneComponentHasToBeUpdated || parametersExt.isAlwaysUpdateNetwork()) {
            Networks.resetState(network);
            if (parameters.isWriteSlackBus()) {
                SlackTerminal.reset((Network)network);
            }
            if (parametersExt.isWriteReferenceTerminals()) {
                ReferenceTerminals.reset((Network)network);
            }
        }
        ArrayList<LoadFlowResultImpl.ComponentResultImpl> componentResults = new ArrayList<LoadFlowResultImpl.ComponentResultImpl>(results.size());
        for (AcLoadFlowResult result : results) {
            this.updateAcState(network, parameters, parametersExt, result, acParameters, atLeastOneComponentHasToBeUpdated);
            ReferenceBusAndSlackBusesResults referenceBusAndSlackBusesResults = OpenLoadFlowProvider.buildReferenceBusAndSlackBusesResults(result);
            LoadFlowResult.Status status = result.toComponentResultStatus();
            componentResults.add(new LoadFlowResultImpl.ComponentResultImpl(result.getNetwork().getNumCC(), result.getNetwork().getNumSC(), status.status(), status.statusText(), Collections.emptyMap(), result.getSolverIterations(), referenceBusAndSlackBusesResults.referenceBusId(), referenceBusAndSlackBusesResults.slackBusResultList(), result.getDistributedActivePower() * 100.0));
        }
        boolean ok = results.stream().anyMatch(AcLoadFlowResult::isSuccess);
        return new LoadFlowResultImpl(ok, Collections.emptyMap(), null, componentResults);
    }

    private static ReferenceBusAndSlackBusesResults buildReferenceBusAndSlackBusesResults(AbstractLoadFlowResult result) {
        String referenceBusId = null;
        List<LoadFlowResult.SlackBusResult> slackBusResultList = new ArrayList<LoadFlowResult.SlackBusResult>();
        double slackBusActivePowerMismatch = result.getSlackBusActivePowerMismatch() * 100.0;
        if (result.getNetwork().getValidity() == LfNetwork.Validity.VALID) {
            referenceBusId = result.getNetwork().getReferenceBus().getId();
            List<LfBus> slackBuses = result.getNetwork().getSlackBuses();
            slackBusResultList = slackBuses.stream().map(b -> new LoadFlowResultImpl.SlackBusResultImpl(b.getId(), slackBusActivePowerMismatch / (double)slackBuses.size())).toList();
        }
        return new ReferenceBusAndSlackBusesResults(referenceBusId, slackBusResultList);
    }

    private void computeZeroImpedanceFlows(LfNetwork network, LoadFlowModel loadFlowModel) {
        for (LfZeroImpedanceNetwork zeroImpedanceNetwork : network.getZeroImpedanceNetworks(loadFlowModel)) {
            new ZeroImpedanceFlows(zeroImpedanceNetwork.getGraph(), zeroImpedanceNetwork.getSpanningTree(), loadFlowModel).compute();
        }
    }

    private LoadFlowResult runDc(Network network, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, ReportNode reportNode) {
        DcLoadFlowParameters dcParameters = OpenLoadFlowParameters.createDcParameters(network, parameters, parametersExt, this.matrixFactory, this.connectivityFactory, this.forcePhaseControlOffAndAddAngle1Var);
        dcParameters.getNetworkParameters().setCacheEnabled(false);
        List<DcLoadFlowResult> results = DcLoadFlowEngine.run(network, new LfNetworkLoaderImpl(), dcParameters, reportNode);
        Networks.resetState(network);
        List<LoadFlowResult.ComponentResult> componentsResult = results.stream().map(r -> this.processResult(network, (DcLoadFlowResult)r, parameters, parametersExt, dcParameters.getNetworkParameters().isBreakers())).toList();
        boolean ok = results.stream().anyMatch(DcLoadFlowResult::isSuccess);
        return new LoadFlowResultImpl(ok, Collections.emptyMap(), null, componentsResult);
    }

    private LoadFlowResult.ComponentResult processResult(Network network, DcLoadFlowResult result, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, boolean breakers) {
        if (result.isSuccess() && parameters.isWriteSlackBus()) {
            SlackTerminal.reset((Network)network);
        }
        if (result.isSuccess()) {
            LfNetworkStateUpdateParameters updateParameters = new LfNetworkStateUpdateParameters(false, parameters.isWriteSlackBus(), parameters.isPhaseShifterRegulationOn(), parameters.isTransformerVoltageControlOn(), false, false, true, breakers, ReactivePowerDispatchMode.Q_EQUAL_PROPORTION, parametersExt.isWriteReferenceTerminals(), parametersExt.getReferenceBusSelectionMode(), false);
            result.getNetwork().updateState(updateParameters);
            this.computeZeroImpedanceFlows(result.getNetwork(), LoadFlowModel.DC);
        }
        ReferenceBusAndSlackBusesResults referenceBusAndSlackBusesResults = OpenLoadFlowProvider.buildReferenceBusAndSlackBusesResults(result);
        LoadFlowResult.Status status = result.toComponentResultStatus();
        return new LoadFlowResultImpl.ComponentResultImpl(result.getNetwork().getNumCC(), result.getNetwork().getNumSC(), status.status(), status.statusText(), Collections.emptyMap(), 0, referenceBusAndSlackBusesResults.referenceBusId(), referenceBusAndSlackBusesResults.slackBusResultList(), Double.NaN);
    }

    public CompletableFuture<LoadFlowResult> run(Network network, ComputationManager computationManager, String workingVariantId, LoadFlowParameters parameters, ReportNode reportNode) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(computationManager);
        Objects.requireNonNull(workingVariantId);
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(reportNode);
        LOGGER.info("Version: {}", (Object)new PowsyblOpenLoadFlowVersion());
        ReportNode lfReportNode = Reports.createLoadFlowReporter(reportNode, network.getId());
        return CompletableFuture.supplyAsync(() -> {
            network.getVariantManager().setWorkingVariant(workingVariantId);
            Stopwatch stopwatch = Stopwatch.createStarted();
            OpenLoadFlowParameters parametersExt = OpenLoadFlowParameters.get(parameters);
            OpenLoadFlowParameters.log(parameters, parametersExt);
            LoadFlowResult result = parameters.isDc() ? this.runDc(network, parameters, parametersExt, lfReportNode) : this.runAc(network, parameters, parametersExt, lfReportNode);
            stopwatch.stop();
            LOGGER.info(Markers.PERFORMANCE_MARKER, "Load flow ran in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return result;
        }, computationManager.getExecutor());
    }

    public Optional<ExtensionJsonSerializer> getSpecificParametersSerializer() {
        return Optional.of(new OpenLoadFlowParameterJsonSerializer());
    }

    public Optional<Extension<LoadFlowParameters>> loadSpecificParameters(PlatformConfig platformConfig) {
        return Optional.of(OpenLoadFlowParameters.load(platformConfig));
    }

    public Optional<Extension<LoadFlowParameters>> loadSpecificParameters(Map<String, String> properties) {
        return Optional.of(OpenLoadFlowParameters.load(properties));
    }

    public List<Parameter> getSpecificParameters() {
        return OpenLoadFlowParameters.SPECIFIC_PARAMETERS;
    }

    public void updateSpecificParameters(Extension<LoadFlowParameters> extension, Map<String, String> properties) {
        ((OpenLoadFlowParameters)extension).update(properties);
    }

    public Optional<Class<? extends Extension<LoadFlowParameters>>> getSpecificParametersClass() {
        return Optional.of(OpenLoadFlowParameters.class);
    }

    public Map<String, String> createMapFromSpecificParameters(Extension<LoadFlowParameters> extension) {
        return ((OpenLoadFlowParameters)extension).toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Objects.toString(e.getValue(), "")));
    }

    private record ReferenceBusAndSlackBusesResults(String referenceBusId, List<LoadFlowResult.SlackBusResult> slackBusResultList) {
    }
}

