/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.network.AbstractLfNetworkListener;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import java.util.Objects;

public class AcJacobianMatrix
extends JacobianMatrix<AcVariableType, AcEquationType> {
    private final LfNetwork network;
    private final LfNetworkListener networkListener = new AbstractLfNetworkListener(){

        private void onLoadTargetChange(LfLoad load) {
            load.getLoadModel().ifPresent(ignored -> AcJacobianMatrix.this.updateStatus(JacobianMatrix.Status.VALUES_INVALID));
        }

        @Override
        public void onLoadActivePowerTargetChange(LfLoad load, double oldTargetP, double newTargetP) {
            this.onLoadTargetChange(load);
        }

        @Override
        public void onLoadReactivePowerTargetChange(LfLoad load, double oldTargetQ, double newTargetQ) {
            this.onLoadTargetChange(load);
        }
    };

    public AcJacobianMatrix(EquationSystem<AcVariableType, AcEquationType> equationSystem, MatrixFactory matrixFactory, LfNetwork network) {
        super(equationSystem, matrixFactory);
        this.network = Objects.requireNonNull(network);
        network.addListener(this.networkListener);
    }

    @Override
    public void close() {
        super.close();
        this.network.removeListener(this.networkListener);
    }
}

