/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreationParameters;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.ac.solver.AcSolverFactory;
import com.powsybl.openloadflow.ac.solver.NewtonKrylovParameters;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonFactory;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonParameters;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AcLoadFlowParameters
extends AbstractLoadFlowParameters<AcLoadFlowParameters> {
    private AcEquationSystemCreationParameters equationSystemCreationParameters = new AcEquationSystemCreationParameters();
    private NewtonRaphsonParameters newtonRaphsonParameters = new NewtonRaphsonParameters();
    private NewtonKrylovParameters newtonKrylovParameters = new NewtonKrylovParameters();
    private List<AcOuterLoop> outerLoops = Collections.emptyList();
    private int maxOuterLoopIterations = 20;
    private VoltageInitializer voltageInitializer = new UniformValueVoltageInitializer();
    private boolean asymmetrical = false;
    private OpenLoadFlowParameters.SlackDistributionFailureBehavior slackDistributionFailureBehavior = OpenLoadFlowParameters.SlackDistributionFailureBehavior.LEAVE_ON_SLACK_BUS;
    private AcSolverFactory solverFactory = new NewtonRaphsonFactory();
    private boolean detailedReport = false;

    public AcEquationSystemCreationParameters getEquationSystemCreationParameters() {
        return this.equationSystemCreationParameters;
    }

    public AcLoadFlowParameters setEquationSystemCreationParameters(AcEquationSystemCreationParameters equationSystemCreationParameters) {
        this.equationSystemCreationParameters = Objects.requireNonNull(equationSystemCreationParameters);
        return this;
    }

    public NewtonRaphsonParameters getNewtonRaphsonParameters() {
        return this.newtonRaphsonParameters;
    }

    public AcLoadFlowParameters setNewtonRaphsonParameters(NewtonRaphsonParameters newtonRaphsonParameters) {
        this.newtonRaphsonParameters = Objects.requireNonNull(newtonRaphsonParameters);
        return this;
    }

    public NewtonKrylovParameters getNewtonKrylovParameters() {
        return this.newtonKrylovParameters;
    }

    public AcLoadFlowParameters setNewtonKrylovParameters(NewtonKrylovParameters newtonKrylovParameters) {
        this.newtonKrylovParameters = Objects.requireNonNull(newtonKrylovParameters);
        return this;
    }

    public List<AcOuterLoop> getOuterLoops() {
        return this.outerLoops;
    }

    public AcLoadFlowParameters setOuterLoops(List<AcOuterLoop> outerLoops) {
        this.outerLoops = Objects.requireNonNull(outerLoops);
        return this;
    }

    public int getMaxOuterLoopIterations() {
        return this.maxOuterLoopIterations;
    }

    public AcLoadFlowParameters setMaxOuterLoopIterations(int maxOuterLoopIterations) {
        this.maxOuterLoopIterations = maxOuterLoopIterations;
        return this;
    }

    public VoltageInitializer getVoltageInitializer() {
        return this.voltageInitializer;
    }

    public AcLoadFlowParameters setVoltageInitializer(VoltageInitializer voltageInitializer) {
        this.voltageInitializer = Objects.requireNonNull(voltageInitializer);
        return this;
    }

    public boolean isAsymmetrical() {
        return this.asymmetrical;
    }

    public AcLoadFlowParameters setAsymmetrical(boolean asymmetrical) {
        this.asymmetrical = asymmetrical;
        return this;
    }

    public OpenLoadFlowParameters.SlackDistributionFailureBehavior getSlackDistributionFailureBehavior() {
        return this.slackDistributionFailureBehavior;
    }

    public AcLoadFlowParameters setSlackDistributionFailureBehavior(OpenLoadFlowParameters.SlackDistributionFailureBehavior slackDistributionFailureBehavior) {
        this.slackDistributionFailureBehavior = Objects.requireNonNull(slackDistributionFailureBehavior);
        return this;
    }

    public AcSolverFactory getSolverFactory() {
        return this.solverFactory;
    }

    public AcLoadFlowParameters setSolverFactory(AcSolverFactory solverFactory) {
        this.solverFactory = Objects.requireNonNull(solverFactory);
        return this;
    }

    public boolean isDetailedReport() {
        return this.detailedReport;
    }

    public AcLoadFlowParameters setDetailedReport(boolean detailedReport) {
        this.detailedReport = detailedReport;
        return this;
    }

    public String toString() {
        return "AcLoadFlowParameters(networkParameters=" + this.networkParameters + ", equationSystemCreationParameters=" + this.equationSystemCreationParameters + ", newtonRaphsonParameters=" + this.newtonRaphsonParameters + ", newtonKrylovParameters=" + this.newtonKrylovParameters + ", outerLoops=" + this.outerLoops.stream().map(outerLoop -> outerLoop.getClass().getSimpleName()).toList() + ", maxOuterLoopIterations=" + this.maxOuterLoopIterations + ", matrixFactory=" + this.matrixFactory.getClass().getSimpleName() + ", voltageInitializer=" + this.voltageInitializer.getClass().getSimpleName() + ", asymmetrical=" + this.asymmetrical + ", slackDistributionFailureBehavior=" + this.slackDistributionFailureBehavior.name() + ", solverFactory=" + this.solverFactory.getClass().getSimpleName() + ", detailedReport=" + this.detailedReport + ")";
    }
}

