/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import java.util.List;
import java.util.Objects;

public class AcTargetVector
extends TargetVector<AcVariableType, AcEquationType> {
    private static double getBusTargetV(LfBus bus) {
        Objects.requireNonNull(bus);
        double targetV = bus.getHighestPriorityTargetV().orElseThrow(() -> new IllegalStateException("No active voltage control has been found for bus '" + bus.getId() + "'"));
        if (bus.hasGeneratorsWithSlope()) {
            double slope = bus.getGeneratorsControllingVoltageWithSlope().get(0).getSlope();
            targetV -= slope * (bus.getLoadTargetQ() - bus.getGenerationTargetQ());
        }
        return targetV;
    }

    private static double getGeneratorReactivePowerDistributionTarget(LfNetwork network, int busNum) {
        List<LfBus> mergedControllerBuses;
        LfBus controllerBus = network.getBus(busNum);
        double target = (controllerBus.getRemoteControlReactivePercent() - 1.0) * controllerBus.getTargetQ();
        if (controllerBus.getGeneratorVoltageControl().isPresent()) {
            mergedControllerBuses = controllerBus.getGeneratorVoltageControl().orElseThrow().getMergedControllerElements();
        } else if (controllerBus.hasGeneratorReactivePowerControl()) {
            mergedControllerBuses = controllerBus.getGeneratorReactivePowerControl().orElseThrow().getControllerBuses();
        } else {
            throw new PowsyblException("Controller bus '" + controllerBus.getId() + "' has no voltage or reactive remote control");
        }
        return AcTargetVector.updateReactivePowerDistributionTarget(target, controllerBus, mergedControllerBuses);
    }

    private static double updateReactivePowerDistributionTarget(double target, LfBus controllerBus, List<LfBus> controllerBuses) {
        double updatedTarget = target;
        for (LfBus otherControllerBus : controllerBuses) {
            if (otherControllerBus == controllerBus) continue;
            updatedTarget += controllerBus.getRemoteControlReactivePercent() * otherControllerBus.getTargetQ();
        }
        return updatedTarget;
    }

    private static double getReactivePowerControlTarget(LfBranch branch) {
        Objects.requireNonNull(branch);
        return branch.getGeneratorReactivePowerControl().map(Control::getTargetValue).orElseThrow(() -> new PowsyblException("Branch '" + branch.getId() + "' has no target in for generator reactive remote control"));
    }

    public static void init(Equation<AcVariableType, AcEquationType> equation, LfNetwork network, double[] targets) {
        switch (equation.getType()) {
            case BUS_TARGET_P: {
                targets[equation.getColumn()] = network.getBus(equation.getElementNum()).getTargetP();
                break;
            }
            case BUS_TARGET_Q: {
                targets[equation.getColumn()] = network.getBus(equation.getElementNum()).getTargetQ();
                break;
            }
            case BUS_TARGET_V: {
                targets[equation.getColumn()] = AcTargetVector.getBusTargetV(network.getBus(equation.getElementNum()));
                break;
            }
            case BUS_TARGET_PHI: {
                targets[equation.getColumn()] = 0.0;
                break;
            }
            case SHUNT_TARGET_B: {
                targets[equation.getColumn()] = network.getShunt(equation.getElementNum()).getB();
                break;
            }
            case BRANCH_TARGET_P: {
                targets[equation.getColumn()] = LfBranch.getDiscretePhaseControlTarget(network.getBranch(equation.getElementNum()), TransformerPhaseControl.Unit.MW);
                break;
            }
            case BRANCH_TARGET_Q: {
                targets[equation.getColumn()] = AcTargetVector.getReactivePowerControlTarget(network.getBranch(equation.getElementNum()));
                break;
            }
            case BRANCH_TARGET_ALPHA1: {
                targets[equation.getColumn()] = network.getBranch(equation.getElementNum()).getPiModel().getA1();
                break;
            }
            case BRANCH_TARGET_RHO1: {
                targets[equation.getColumn()] = network.getBranch(equation.getElementNum()).getPiModel().getR1();
                break;
            }
            case DISTR_Q: {
                targets[equation.getColumn()] = AcTargetVector.getGeneratorReactivePowerDistributionTarget(network, equation.getElementNum());
                break;
            }
            case ZERO_V: {
                targets[equation.getColumn()] = 0.0;
                break;
            }
            case ZERO_PHI: {
                targets[equation.getColumn()] = LfBranch.getA(network.getBranch(equation.getElementNum()));
                break;
            }
            case DISTR_RHO: 
            case DISTR_SHUNT_B: 
            case DUMMY_TARGET_P: 
            case DUMMY_TARGET_Q: 
            case BUS_DISTR_SLACK_P: 
            case BUS_TARGET_IX_ZERO: 
            case BUS_TARGET_IY_ZERO: 
            case BUS_TARGET_IX_NEGATIVE: 
            case BUS_TARGET_IY_NEGATIVE: {
                targets[equation.getColumn()] = 0.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state variable type: " + equation.getType());
            }
        }
        int n = equation.getColumn();
        targets[n] = targets[n] - equation.rhs();
    }

    public AcTargetVector(LfNetwork network, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        super(network, equationSystem, AcTargetVector::init);
    }
}

