/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.google.common.collect.Lists;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.DistributedSlackOuterLoop;
import com.powsybl.openloadflow.ac.solver.AcSolver;
import com.powsybl.openloadflow.ac.solver.AcSolverFactory;
import com.powsybl.openloadflow.ac.solver.AcSolverResult;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonFactory;
import com.powsybl.openloadflow.lf.LoadFlowEngine;
import com.powsybl.openloadflow.lf.outerloop.DistributedSlackContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import com.powsybl.openloadflow.util.Reports;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcloadFlowEngine
implements LoadFlowEngine<AcVariableType, AcEquationType, AcLoadFlowParameters, AcLoadFlowResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcloadFlowEngine.class);
    private final AcLoadFlowContext context;
    private final AcSolverFactory solverFactory;

    public AcloadFlowEngine(AcLoadFlowContext context) {
        this(context, new NewtonRaphsonFactory());
    }

    public AcloadFlowEngine(AcLoadFlowContext context, AcSolverFactory solverFactory) {
        this.context = Objects.requireNonNull(context);
        this.solverFactory = Objects.requireNonNull(solverFactory);
    }

    public AcLoadFlowContext getContext() {
        return this.context;
    }

    private void runOuterLoop(AcOuterLoop outerLoop, AcOuterLoopContext outerLoopContext, AcSolver solver, RunningContext runningContext) {
        OuterLoopResult outerLoopResult;
        ReportNode olReportNode = Reports.createOuterLoopReporter(outerLoopContext.getNetwork().getReportNode(), outerLoop.getName());
        do {
            MutableInt outerLoopIteration = runningContext.outerLoopIterationByType.computeIfAbsent(outerLoop.getName(), k -> new MutableInt());
            outerLoopContext.setIteration(outerLoopIteration.getValue());
            outerLoopContext.setOuterLoopTotalIterations(runningContext.outerLoopTotalIterations);
            outerLoopContext.setLastSolverResult(runningContext.lastSolverResult);
            outerLoopContext.setLoadFlowContext(this.context);
            runningContext.lastOuterLoopResult = outerLoopResult = outerLoop.check(outerLoopContext, olReportNode);
            if (outerLoopResult.status() != OuterLoopStatus.UNSTABLE) continue;
            LOGGER.debug("Start outer loop '{}' iteration {}", (Object)outerLoop.getName(), (Object)runningContext.outerLoopTotalIterations);
            ReportNode nrReportNode = this.context.getNetwork().getReportNode();
            if (((AcLoadFlowParameters)this.context.getParameters()).isDetailedReport()) {
                nrReportNode = Reports.createDetailedSolverReporterOuterLoop(nrReportNode, solver.getName(), this.context.getNetwork().getNumCC(), this.context.getNetwork().getNumSC(), runningContext.outerLoopTotalIterations + 1, outerLoop.getName());
            }
            runningContext.lastSolverResult = solver.run(new PreviousValueVoltageInitializer(), nrReportNode);
            runningContext.nrTotalIterations.add(runningContext.lastSolverResult.getIterations());
            ++runningContext.outerLoopTotalIterations;
            outerLoopIteration.increment();
        } while (outerLoopResult.status() == OuterLoopStatus.UNSTABLE && runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED && runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations());
        if (outerLoopResult.status() != OuterLoopStatus.STABLE) {
            Reports.reportUnsuccessfulOuterLoop(olReportNode, outerLoopResult.status().name());
        }
    }

    @Override
    public AcLoadFlowResult run() {
        LOGGER.info("Start AC loadflow on network {}", (Object)this.context.getNetwork());
        VoltageInitializer voltageInitializer = ((AcLoadFlowParameters)this.context.getParameters()).getVoltageInitializer();
        voltageInitializer.prepare(this.context.getNetwork());
        RunningContext runningContext = new RunningContext();
        AcSolver solver = this.solverFactory.create(this.context.getNetwork(), (AcLoadFlowParameters)this.context.getParameters(), this.context.getEquationSystem(), this.context.getJacobianMatrix(), this.context.getTargetVector(), this.context.getEquationVector());
        List<AcOuterLoop> outerLoops = ((AcLoadFlowParameters)this.context.getParameters()).getOuterLoops();
        List<Pair> outerLoopsAndContexts = outerLoops.stream().map(outerLoop -> Pair.of((Object)outerLoop, (Object)new AcOuterLoopContext(this.context.getNetwork()))).toList();
        for (Pair outerLoopAndContext : outerLoopsAndContexts) {
            AcOuterLoop outerLoop2 = (AcOuterLoop)outerLoopAndContext.getLeft();
            AcOuterLoopContext outerLoopContext = (AcOuterLoopContext)outerLoopAndContext.getRight();
            outerLoop2.initialize(outerLoopContext);
        }
        ReportNode nrReportNode = this.context.getNetwork().getReportNode();
        if (((AcLoadFlowParameters)this.context.getParameters()).isDetailedReport()) {
            nrReportNode = Reports.createDetailedSolverReporter(nrReportNode, solver.getName(), this.context.getNetwork().getNumCC(), this.context.getNetwork().getNumSC());
        }
        runningContext.lastSolverResult = solver.run(voltageInitializer, nrReportNode);
        runningContext.nrTotalIterations.add(runningContext.lastSolverResult.getIterations());
        if (runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED) {
            int oldNrTotalIterations;
            block1: do {
                oldNrTotalIterations = runningContext.nrTotalIterations.getValue();
                for (Pair outerLoopAndContext : outerLoopsAndContexts) {
                    this.runOuterLoop((AcOuterLoop)outerLoopAndContext.getLeft(), (AcOuterLoopContext)outerLoopAndContext.getRight(), solver, runningContext);
                    if (runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED && runningContext.lastOuterLoopResult.status() != OuterLoopStatus.FAILED && runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations()) continue;
                    continue block1;
                }
            } while (runningContext.nrTotalIterations.getValue() > oldNrTotalIterations && runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED && runningContext.lastOuterLoopResult.status() != OuterLoopStatus.FAILED && runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations());
        }
        double distributedActivePower = 0.0;
        for (Pair outerLoopAndContext : Lists.reverse(outerLoopsAndContexts)) {
            AcOuterLoop outerLoop3 = (AcOuterLoop)outerLoopAndContext.getLeft();
            AcOuterLoopContext outerLoopContext = (AcOuterLoopContext)outerLoopAndContext.getRight();
            if (outerLoop3 instanceof DistributedSlackOuterLoop) {
                distributedActivePower = ((DistributedSlackContextData)outerLoopContext.getData()).getDistributedActivePower();
            }
            outerLoop3.cleanup(outerLoopContext);
        }
        OuterLoopResult outerLoopFinalResult = runningContext.lastOuterLoopResult.status() == OuterLoopStatus.FAILED ? runningContext.lastOuterLoopResult : (runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations() ? new OuterLoopResult(runningContext.lastOuterLoopResult.outerLoopName(), OuterLoopStatus.STABLE, runningContext.lastOuterLoopResult.statusText()) : new OuterLoopResult(runningContext.lastOuterLoopResult.outerLoopName(), OuterLoopStatus.UNSTABLE, runningContext.lastOuterLoopResult.statusText()));
        AcLoadFlowResult result = new AcLoadFlowResult(this.context.getNetwork(), runningContext.outerLoopTotalIterations, runningContext.nrTotalIterations.getValue(), runningContext.lastSolverResult.getStatus(), outerLoopFinalResult, runningContext.lastSolverResult.getSlackBusActivePowerMismatch(), distributedActivePower);
        LOGGER.info("Ac loadflow complete on network {} (result={})", (Object)this.context.getNetwork(), (Object)result);
        Reports.reportAcLfComplete(this.context.getNetwork().getReportNode(), result.isSuccess(), result.getSolverStatus().name(), result.getOuterLoopResult().status().name());
        this.context.setResult(result);
        return result;
    }

    public static List<AcLoadFlowResult> run(List<LfNetwork> lfNetworks, AcLoadFlowParameters parameters) {
        return lfNetworks.stream().map(n -> {
            if (n.getValidity() == LfNetwork.Validity.VALID) {
                try (AcLoadFlowContext context = new AcLoadFlowContext((LfNetwork)n, parameters);){
                    AcLoadFlowResult acLoadFlowResult = new AcloadFlowEngine(context, parameters.getSolverFactory()).run();
                    return acLoadFlowResult;
                }
            }
            return AcLoadFlowResult.createNoCalculationResult(n);
        }).toList();
    }

    private static class RunningContext {
        private AcSolverResult lastSolverResult;
        private final Map<String, MutableInt> outerLoopIterationByType = new HashMap<String, MutableInt>();
        private int outerLoopTotalIterations = 0;
        private final MutableInt nrTotalIterations = new MutableInt();
        private OuterLoopResult lastOuterLoopResult = OuterLoopResult.stable();

        private RunningContext() {
        }
    }
}

