/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.PiModel;

abstract class AbstractBranchAcFlowEquationTerm
extends AbstractElementEquationTerm<LfBranch, AcVariableType, AcEquationType> {
    protected final double b1;
    protected final double b2;
    protected final double g1;
    protected final double g2;
    protected final double y;
    protected final double ksi;
    protected final double g12;
    protected final double b12;

    protected AbstractBranchAcFlowEquationTerm(LfBranch branch) {
        super(branch);
        PiModel piModel = branch.getPiModel();
        if (piModel.getR() == 0.0 && piModel.getX() == 0.0) {
            throw new IllegalArgumentException("Non impedant branch not supported: " + branch.getId());
        }
        this.b1 = piModel.getB1();
        this.b2 = piModel.getB2();
        this.g1 = piModel.getG1();
        this.g2 = piModel.getG2();
        this.y = piModel.getY();
        this.ksi = piModel.getKsi();
        this.g12 = piModel.getR() * this.y * this.y;
        this.b12 = -piModel.getX() * this.y * this.y;
    }
}

