/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.ac.equations.AbstractBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractClosedBranchAcFlowEquationTerm
extends AbstractBranchAcFlowEquationTerm {
    protected final Variable<AcVariableType> v1Var;
    protected final Variable<AcVariableType> v2Var;
    protected final Variable<AcVariableType> ph1Var;
    protected final Variable<AcVariableType> ph2Var;
    protected final Variable<AcVariableType> a1Var;
    protected final Variable<AcVariableType> r1Var;
    protected final List<Variable<AcVariableType>> variables = new ArrayList<Variable<AcVariableType>>();

    public static AcVariableType getVoltageMagnitudeType(Fortescue.SequenceType sequenceType) {
        return switch (sequenceType) {
            default -> throw new IncompatibleClassChangeError();
            case Fortescue.SequenceType.POSITIVE -> AcVariableType.BUS_V;
            case Fortescue.SequenceType.NEGATIVE -> AcVariableType.BUS_V_NEGATIVE;
            case Fortescue.SequenceType.ZERO -> AcVariableType.BUS_V_ZERO;
        };
    }

    public static AcVariableType getVoltageAngleType(Fortescue.SequenceType sequenceType) {
        return switch (sequenceType) {
            default -> throw new IncompatibleClassChangeError();
            case Fortescue.SequenceType.POSITIVE -> AcVariableType.BUS_PHI;
            case Fortescue.SequenceType.NEGATIVE -> AcVariableType.BUS_PHI_NEGATIVE;
            case Fortescue.SequenceType.ZERO -> AcVariableType.BUS_PHI_ZERO;
        };
    }

    protected AbstractClosedBranchAcFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1, Fortescue.SequenceType sequenceType) {
        super(branch);
        Objects.requireNonNull(bus1);
        Objects.requireNonNull(bus2);
        Objects.requireNonNull(variableSet);
        AcVariableType vType = AbstractClosedBranchAcFlowEquationTerm.getVoltageMagnitudeType(sequenceType);
        AcVariableType angleType = AbstractClosedBranchAcFlowEquationTerm.getVoltageAngleType(sequenceType);
        this.v1Var = variableSet.getVariable(bus1.getNum(), vType);
        this.v2Var = variableSet.getVariable(bus2.getNum(), vType);
        this.ph1Var = variableSet.getVariable(bus1.getNum(), angleType);
        this.ph2Var = variableSet.getVariable(bus2.getNum(), angleType);
        this.a1Var = deriveA1 ? variableSet.getVariable(branch.getNum(), AcVariableType.BRANCH_ALPHA1) : null;
        this.r1Var = deriveR1 ? variableSet.getVariable(branch.getNum(), AcVariableType.BRANCH_RHO1) : null;
        this.variables.add(this.v1Var);
        this.variables.add(this.v2Var);
        this.variables.add(this.ph1Var);
        this.variables.add(this.ph2Var);
        if (this.a1Var != null) {
            this.variables.add(this.a1Var);
        }
        if (this.r1Var != null) {
            this.variables.add(this.r1Var);
        }
    }

    public Variable<AcVariableType> getA1Var() {
        return this.a1Var;
    }

    protected double v1() {
        return this.sv.get(this.v1Var.getRow());
    }

    protected double v2() {
        return this.sv.get(this.v2Var.getRow());
    }

    protected double ph1() {
        return this.sv.get(this.ph1Var.getRow());
    }

    protected double ph2() {
        return this.sv.get(this.ph2Var.getRow());
    }

    protected double r1() {
        return this.r1Var != null ? this.sv.get(this.r1Var.getRow()) : ((LfBranch)this.element).getPiModel().getR1();
    }

    protected double a1() {
        return this.a1Var != null ? this.sv.get(this.a1Var.getRow()) : ((LfBranch)this.element).getPiModel().getA1();
    }

    public static double theta1(double ksi, double ph1, double a1, double ph2) {
        return ksi - a1 + 0.0 - ph1 + ph2;
    }

    public static double theta2(double ksi, double ph1, double a1, double ph2) {
        return ksi + a1 - 0.0 + ph1 - ph2;
    }

    protected abstract double calculateSensi(double var1, double var3, double var5, double var7, double var9, double var11);

    @Override
    public double calculateSensi(DenseMatrix dx, int column) {
        Objects.requireNonNull(dx);
        double dph1 = dx.get(this.ph1Var.getRow(), column);
        double dph2 = dx.get(this.ph2Var.getRow(), column);
        double dv1 = dx.get(this.v1Var.getRow(), column);
        double dv2 = dx.get(this.v2Var.getRow(), column);
        double da1 = this.a1Var != null ? dx.get(this.a1Var.getRow(), column) : 0.0;
        double dr1 = this.r1Var != null ? dx.get(this.r1Var.getRow(), column) : 0.0;
        return this.calculateSensi(dph1, dph2, dv1, dv2, da1, dr1);
    }

    @Override
    public List<Variable<AcVariableType>> getVariables() {
        return this.variables;
    }
}

