/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreationParameters;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreator;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.lf.AbstractEquationSystemUpdater;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfZeroImpedanceNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.EvaluableConstants;
import java.util.List;
import java.util.Objects;

public class AcEquationSystemUpdater
extends AbstractEquationSystemUpdater<AcVariableType, AcEquationType> {
    private final AcEquationSystemCreationParameters parameters;

    public AcEquationSystemUpdater(EquationSystem<AcVariableType, AcEquationType> equationSystem, AcEquationSystemCreationParameters parameters) {
        super(equationSystem, LoadFlowModel.AC);
        this.parameters = Objects.requireNonNull(parameters);
    }

    private void updateVoltageControls(LfBus bus) {
        LfZeroImpedanceNetwork zn = bus.getZeroImpedanceNetwork(this.loadFlowModel);
        if (zn == null) {
            bus.getGeneratorVoltageControl().ifPresent(voltageControl -> AcEquationSystemCreator.updateGeneratorVoltageControl((GeneratorVoltageControl)voltageControl.getMainVoltageControl(), this.equationSystem));
            bus.getTransformerVoltageControl().ifPresent(voltageControl -> AcEquationSystemCreator.updateTransformerVoltageControlEquations((TransformerVoltageControl)voltageControl.getMainVoltageControl(), this.equationSystem));
            bus.getShuntVoltageControl().ifPresent(voltageControl -> AcEquationSystemCreator.updateShuntVoltageControlEquations((ShuntVoltageControl)voltageControl.getMainVoltageControl(), this.equationSystem));
        } else {
            for (LfBus zb : zn.getGraph().vertexSet()) {
                zb.getGeneratorVoltageControl().ifPresent(voltageControl -> AcEquationSystemCreator.updateGeneratorVoltageControl((GeneratorVoltageControl)voltageControl.getMainVoltageControl(), this.equationSystem));
                zb.getTransformerVoltageControl().ifPresent(voltageControl -> AcEquationSystemCreator.updateTransformerVoltageControlEquations((TransformerVoltageControl)voltageControl.getMainVoltageControl(), this.equationSystem));
                zb.getShuntVoltageControl().ifPresent(voltageControl -> AcEquationSystemCreator.updateShuntVoltageControlEquations((ShuntVoltageControl)voltageControl.getMainVoltageControl(), this.equationSystem));
            }
        }
    }

    @Override
    public void onGeneratorVoltageControlChange(LfBus controllerBus, boolean newVoltageControllerEnabled) {
        this.updateVoltageControls(controllerBus.getGeneratorVoltageControl().orElseThrow().getControlledBus());
    }

    @Override
    public void onTransformerPhaseControlChange(LfBranch controllerBranch, boolean newPhaseControlEnabled) {
        AcEquationSystemCreator.updateTransformerPhaseControlEquations(controllerBranch.getPhaseControl().orElseThrow(), this.equationSystem);
    }

    @Override
    public void onGeneratorReactivePowerControlChange(LfBus controllerBus, boolean newReactiveControllerEnabled) {
        controllerBus.getGeneratorReactivePowerControl().ifPresent(generatorReactivePowerControl -> AcEquationSystemCreator.updateGeneratorReactivePowerControlBranchEquations(generatorReactivePowerControl, this.equationSystem));
    }

    @Override
    public void onTransformerVoltageControlChange(LfBranch controllerBranch, boolean newVoltageControllerEnabled) {
        this.updateVoltageControls(controllerBranch.getVoltageControl().orElseThrow().getControlledBus());
    }

    @Override
    public void onShuntVoltageControlChange(LfShunt controllerShunt, boolean newVoltageControllerEnabled) {
        this.updateVoltageControls(controllerShunt.getVoltageControl().orElseThrow().getControlledBus());
    }

    @Override
    protected void updateNonImpedantBranchEquations(LfBranch branch, boolean enable) {
        this.equationSystem.getEquation(branch.getNum(), AcEquationType.ZERO_PHI).orElseThrow().setActive(enable);
        this.equationSystem.getEquation(branch.getNum(), AcEquationType.DUMMY_TARGET_P).orElseThrow().setActive(!enable);
        this.equationSystem.getEquation(branch.getNum(), AcEquationType.ZERO_V).orElseThrow().setActive(enable);
        this.equationSystem.getEquation(branch.getNum(), AcEquationType.DUMMY_TARGET_Q).orElseThrow().setActive(!enable);
    }

    @Override
    public void onDisableChange(LfElement element, boolean disabled) {
        this.updateElementEquations(element, !disabled);
        switch (element.getType()) {
            case BUS: {
                LfBus bus = (LfBus)element;
                AcEquationSystemUpdater.checkSlackBus(bus, disabled);
                this.equationSystem.getEquation(bus.getNum(), AcEquationType.BUS_TARGET_PHI).ifPresent(eq -> eq.setActive(!bus.isDisabled() && bus.isReference()));
                this.equationSystem.getEquation(bus.getNum(), AcEquationType.BUS_TARGET_P).ifPresent(eq -> eq.setActive(!bus.isDisabled() && !bus.isSlack()));
                this.equationSystem.getEquation(bus.getNum(), AcEquationType.BUS_TARGET_V).orElseThrow().setActive(false);
                bus.getGeneratorVoltageControl().ifPresent(vc -> this.updateVoltageControls(vc.getControlledBus()));
                bus.getTransformerVoltageControl().ifPresent(vc -> this.updateVoltageControls(vc.getControlledBus()));
                bus.getShuntVoltageControl().ifPresent(vc -> this.updateVoltageControls(vc.getControlledBus()));
                bus.getGeneratorReactivePowerControl().ifPresent(reactivePowerControl -> AcEquationSystemCreator.updateGeneratorReactivePowerControlBranchEquations(reactivePowerControl, this.equationSystem));
                break;
            }
            case BRANCH: {
                LfBranch branch = (LfBranch)element;
                AcEquationSystemCreator.updateBranchEquations(branch);
                branch.getVoltageControl().ifPresent(vc -> this.updateVoltageControls(vc.getControlledBus()));
                branch.getPhaseControl().ifPresent(phaseControl -> AcEquationSystemCreator.updateTransformerPhaseControlEquations(phaseControl, this.equationSystem));
                branch.getGeneratorReactivePowerControl().ifPresent(reactivePowerControl -> AcEquationSystemCreator.updateGeneratorReactivePowerControlBranchEquations(reactivePowerControl, this.equationSystem));
                break;
            }
            case SHUNT_COMPENSATOR: {
                LfShunt shunt = (LfShunt)element;
                shunt.getVoltageControl().ifPresent(vc -> this.updateVoltageControls(vc.getControlledBus()));
                break;
            }
            case HVDC: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown element type: " + element.getType());
            }
        }
    }

    private void recreateDistributionEquations(LfZeroImpedanceNetwork network) {
        for (LfBus bus : network.getGraph().vertexSet()) {
            bus.getGeneratorVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> AcEquationSystemCreator.recreateReactivePowerDistributionEquations(bus.getNetwork(), voltageControl, this.equationSystem, this.parameters));
            bus.getTransformerVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> AcEquationSystemCreator.recreateR1DistributionEquations(bus.getNetwork(), voltageControl, this.equationSystem));
            bus.getShuntVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> AcEquationSystemCreator.recreateShuntSusceptanceDistributionEquations(bus.getNetwork(), voltageControl, this.equationSystem));
        }
    }

    @Override
    public void onZeroImpedanceNetworkSplit(LfZeroImpedanceNetwork initialNetwork, List<LfZeroImpedanceNetwork> splitNetworks, LoadFlowModel loadFlowModel) {
        if (loadFlowModel == LoadFlowModel.AC) {
            for (LfZeroImpedanceNetwork splitNetwork : splitNetworks) {
                this.recreateDistributionEquations(splitNetwork);
            }
        }
    }

    @Override
    public void onZeroImpedanceNetworkMerge(LfZeroImpedanceNetwork network1, LfZeroImpedanceNetwork network2, LfZeroImpedanceNetwork mergedNetwork, LoadFlowModel loadFlowModel) {
        if (loadFlowModel == LoadFlowModel.AC) {
            this.recreateDistributionEquations(mergedNetwork);
        }
    }

    @Override
    public void onBranchConnectionStatusChange(LfBranch branch, TwoSides side, boolean connected) {
        AcEquationSystemCreator.updateBranchEquations(branch);
        if (branch.isConnectedSide1() && branch.isConnectedSide2()) {
            branch.setP1(branch.getClosedP1());
            branch.setQ1(branch.getClosedQ1());
            branch.setI1(branch.getClosedI1());
            branch.setP2(branch.getClosedP2());
            branch.setQ2(branch.getClosedQ2());
            branch.setI2(branch.getClosedI2());
        } else if (!branch.isConnectedSide1() && branch.isConnectedSide2()) {
            branch.setP1(EvaluableConstants.ZERO);
            branch.setQ1(EvaluableConstants.ZERO);
            branch.setI1(EvaluableConstants.ZERO);
            branch.setP2(branch.getOpenP2());
            branch.setQ2(branch.getOpenQ2());
            branch.setI2(branch.getOpenI2());
        } else if (branch.isConnectedSide1() && !branch.isConnectedSide2()) {
            branch.setP1(branch.getOpenP1());
            branch.setQ1(branch.getOpenQ1());
            branch.setI1(branch.getOpenI1());
            branch.setP2(EvaluableConstants.ZERO);
            branch.setQ2(EvaluableConstants.ZERO);
            branch.setI2(EvaluableConstants.ZERO);
        } else {
            branch.setP1(EvaluableConstants.NAN);
            branch.setQ1(EvaluableConstants.NAN);
            branch.setI1(EvaluableConstants.NAN);
            branch.setP2(EvaluableConstants.NAN);
            branch.setQ2(EvaluableConstants.NAN);
            branch.setI2(EvaluableConstants.NAN);
        }
    }

    @Override
    protected AcEquationType getTypeBusTargetP() {
        return AcEquationType.BUS_TARGET_P;
    }

    @Override
    protected AcEquationType getTypeBusTargetPhi() {
        return AcEquationType.BUS_TARGET_PHI;
    }

    @Override
    protected AcVariableType getTypeBusPhi() {
        return AcVariableType.BUS_PHI;
    }
}

