/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchI1xFlowEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchI1xFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, sequenceType);
    }

    @Override
    public double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return 0.0;
    }

    public static double i1x(double g1, double b1, double v1, double ph1, double v2, double ph2, double g12, double b12) {
        return (g1 + g12) * v1 * FastMath.cos((double)ph1) - (b1 + b12) * v1 * FastMath.sin((double)ph1) - g12 * v2 * FastMath.cos((double)ph2) + b12 * v2 * FastMath.sin((double)ph2);
    }

    public static double di1xdv1(double g1, double b1, double ph1, double g12, double b12) {
        return (g1 + g12) * FastMath.cos((double)ph1) - (b1 + b12) * FastMath.sin((double)ph1);
    }

    public static double di1xdv2(double ph2, double g12, double b12) {
        return -g12 * FastMath.cos((double)ph2) + b12 * FastMath.sin((double)ph2);
    }

    public static double di1xdph1(double g1, double b1, double v1, double ph1, double g12, double b12) {
        return -(g1 + g12) * v1 * FastMath.sin((double)ph1) - (b1 + b12) * v1 * FastMath.cos((double)ph1);
    }

    private static double di1xdph2(double v2, double ph2, double g12, double b12) {
        return g12 * v2 * FastMath.sin((double)ph2) + b12 * v2 * FastMath.cos((double)ph2);
    }

    @Override
    public double eval() {
        return ClosedBranchI1xFlowEquationTerm.i1x(this.g1, this.b1, this.v1(), this.ph1(), this.v2(), this.ph2(), this.g12, this.b12);
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var)) {
            return ClosedBranchI1xFlowEquationTerm.di1xdv1(this.g1, this.b1, this.ph1(), this.g12, this.b12);
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchI1xFlowEquationTerm.di1xdv2(this.ph2(), this.g12, this.b12);
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchI1xFlowEquationTerm.di1xdph1(this.g1, this.b1, this.v1(), this.ph1(), this.g12, this.b12);
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchI1xFlowEquationTerm.di1xdph2(this.v2(), this.ph2(), this.g12, this.b12);
        }
        throw new IllegalStateException("Unexpected variable: " + variable);
    }

    @Override
    public String getName() {
        return "ac_ix_closed_1";
    }
}

