/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchI1yFlowEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchI1yFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, sequenceType);
    }

    @Override
    public double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return 0.0;
    }

    public static double i1y(double g1, double b1, double v1, double ph1, double v2, double ph2, double g12, double b12) {
        return (b1 + b12) * v1 * FastMath.cos((double)ph1) + (g1 + g12) * v1 * FastMath.sin((double)ph1) - b12 * v2 * FastMath.cos((double)ph2) - g12 * v2 * FastMath.sin((double)ph2);
    }

    private static double di1ydv1(double g1, double b1, double ph1, double g12, double b12) {
        return (b1 + b12) * FastMath.cos((double)ph1) + (g1 + g12) * FastMath.sin((double)ph1);
    }

    private static double di1ydv2(double ph2, double g12, double b12) {
        return -b12 * FastMath.cos((double)ph2) - g12 * FastMath.sin((double)ph2);
    }

    private static double di1ydph1(double g1, double b1, double v1, double ph1, double g12, double b12) {
        return -(b1 + b12) * v1 * FastMath.sin((double)ph1) + (g1 + g12) * v1 * FastMath.cos((double)ph1);
    }

    private static double di1ydph2(double v2, double ph2, double g12, double b12) {
        return b12 * v2 * FastMath.sin((double)ph2) - g12 * v2 * FastMath.cos((double)ph2);
    }

    @Override
    public double eval() {
        return ClosedBranchI1yFlowEquationTerm.i1y(this.g1, this.b1, this.v1(), this.ph1(), this.v2(), this.ph2(), this.g12, this.b12);
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var)) {
            return ClosedBranchI1yFlowEquationTerm.di1ydv1(this.g1, this.b1, this.ph1(), this.g12, this.b12);
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchI1yFlowEquationTerm.di1ydv2(this.ph2(), this.g12, this.b12);
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchI1yFlowEquationTerm.di1ydph1(this.g1, this.b1, this.v1(), this.ph1(), this.g12, this.b12);
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchI1yFlowEquationTerm.di1ydph2(this.v2(), this.ph2(), this.g12, this.b12);
        }
        throw new IllegalStateException("Unexpected variable: " + variable);
    }

    @Override
    public String getName() {
        return "ac_iy_closed_1";
    }
}

