/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchSide1ActiveFlowEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchSide1ActiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
    }

    public ClosedBranchSide1ActiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, sequenceType);
    }

    public static double calculateSensi(double g1, double y, double ksi, double v1, double ph1, double a1, double r1, double v2, double ph2, double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        double theta = ClosedBranchSide1ActiveFlowEquationTerm.theta1(ksi, ph1, a1, ph2);
        double cosTheta = FastMath.cos((double)theta);
        double sinTheta = FastMath.sin((double)theta);
        double sinKsi = FastMath.sin((double)ksi);
        return ClosedBranchSide1ActiveFlowEquationTerm.dp1dph1(y, v1, r1, v2, cosTheta) * dph1 + ClosedBranchSide1ActiveFlowEquationTerm.dp1dph2(y, v1, r1, v2, cosTheta) * dph2 + ClosedBranchSide1ActiveFlowEquationTerm.dp1dv1(y, sinKsi, g1, v1, r1, v2, sinTheta) * dv1 + ClosedBranchSide1ActiveFlowEquationTerm.dp1dv2(y, v1, r1, sinTheta) * dv2 + ClosedBranchSide1ActiveFlowEquationTerm.dp1da1(y, v1, r1, v2, cosTheta) * da1 + ClosedBranchSide1ActiveFlowEquationTerm.dp1dr1(y, sinKsi, g1, v1, r1, v2, sinTheta) * dr1;
    }

    @Override
    protected double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return ClosedBranchSide1ActiveFlowEquationTerm.calculateSensi(this.g1, this.y, this.ksi, this.v1(), this.ph1(), this.a1(), this.r1(), this.v2(), this.ph2(), dph1, dph2, dv1, dv2, da1, dr1);
    }

    public static double p1(double y, double sinKsi, double g1, double v1, double r1, double v2, double sinTheta) {
        return r1 * v1 * (g1 * r1 * v1 + y * r1 * v1 * sinKsi - y * 1.0 * v2 * sinTheta);
    }

    public static double dp1dv1(double y, double sinKsi, double g1, double v1, double r1, double v2, double sinTheta) {
        return r1 * (2.0 * g1 * r1 * v1 + 2.0 * y * r1 * v1 * sinKsi - y * 1.0 * v2 * sinTheta);
    }

    public static double dp1dv2(double y, double v1, double r1, double sinTheta) {
        return -y * r1 * 1.0 * v1 * sinTheta;
    }

    public static double dp1dph1(double y, double v1, double r1, double v2, double cosTheta) {
        return y * r1 * 1.0 * v1 * v2 * cosTheta;
    }

    public static double dp1dph2(double y, double v1, double r1, double v2, double cosTheta) {
        return -ClosedBranchSide1ActiveFlowEquationTerm.dp1dph1(y, v1, r1, v2, cosTheta);
    }

    public static double dp1da1(double y, double v1, double r1, double v2, double cosTheta) {
        return ClosedBranchSide1ActiveFlowEquationTerm.dp1dph1(y, v1, r1, v2, cosTheta);
    }

    public static double dp1dr1(double y, double sinKsi, double g1, double v1, double r1, double v2, double sinTheta) {
        return v1 * (2.0 * r1 * v1 * (g1 + y * sinKsi) - y * 1.0 * v2 * sinTheta);
    }

    @Override
    public double eval() {
        return ClosedBranchSide1ActiveFlowEquationTerm.p1(this.y, FastMath.sin((double)this.ksi), this.g1, this.v1(), this.r1(), this.v2(), FastMath.sin((double)ClosedBranchSide1ActiveFlowEquationTerm.theta1(this.ksi, this.ph1(), this.a1(), this.ph2())));
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        double theta = ClosedBranchSide1ActiveFlowEquationTerm.theta1(this.ksi, this.ph1(), this.a1(), this.ph2());
        if (variable.equals(this.v1Var)) {
            return ClosedBranchSide1ActiveFlowEquationTerm.dp1dv1(this.y, FastMath.sin((double)this.ksi), this.g1, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchSide1ActiveFlowEquationTerm.dp1dv2(this.y, this.v1(), this.r1(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchSide1ActiveFlowEquationTerm.dp1dph1(this.y, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchSide1ActiveFlowEquationTerm.dp1dph2(this.y, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.a1Var)) {
            return ClosedBranchSide1ActiveFlowEquationTerm.dp1da1(this.y, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.r1Var)) {
            return ClosedBranchSide1ActiveFlowEquationTerm.dp1dr1(this.y, FastMath.sin((double)this.ksi), this.g1, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_p_closed_1";
    }
}

