/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchSide1ReactiveFlowEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchSide1ReactiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
    }

    public ClosedBranchSide1ReactiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, sequenceType);
    }

    public static double calculateSensi(double y, double ksi, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2, double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        double theta = ClosedBranchSide1ReactiveFlowEquationTerm.theta1(ksi, ph1, a1, ph2);
        double cosTheta = FastMath.cos((double)theta);
        double sinTheta = FastMath.sin((double)theta);
        double cosKsi = FastMath.cos((double)ksi);
        return ClosedBranchSide1ReactiveFlowEquationTerm.dq1dph1(y, v1, r1, v2, sinTheta) * dph1 + ClosedBranchSide1ReactiveFlowEquationTerm.dq1dph2(y, v1, r1, v2, sinTheta) * dph2 + ClosedBranchSide1ReactiveFlowEquationTerm.dq1dv1(y, cosKsi, b1, v1, r1, v2, cosTheta) * dv1 + ClosedBranchSide1ReactiveFlowEquationTerm.dq1dv2(y, v1, r1, cosTheta) * dv2 + ClosedBranchSide1ReactiveFlowEquationTerm.dq1da1(y, v1, r1, v2, sinTheta) * da1 + ClosedBranchSide1ReactiveFlowEquationTerm.dq1dr1(y, cosKsi, b1, v1, r1, v2, cosTheta) * dr1;
    }

    @Override
    protected double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return ClosedBranchSide1ReactiveFlowEquationTerm.calculateSensi(this.y, this.ksi, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2(), dph1, dph2, dv1, dv2, da1, dr1);
    }

    public static double q1(double y, double cosKsi, double b1, double v1, double r1, double v2, double cosTheta) {
        return r1 * v1 * (-b1 * r1 * v1 + y * r1 * v1 * cosKsi - y * 1.0 * v2 * cosTheta);
    }

    public static double dq1dv1(double y, double cosKsi, double b1, double v1, double r1, double v2, double cosTheta) {
        return r1 * (-2.0 * b1 * r1 * v1 + 2.0 * y * r1 * v1 * cosKsi - y * 1.0 * v2 * cosTheta);
    }

    public static double dq1dv2(double y, double v1, double r1, double cosTheta) {
        return -y * r1 * 1.0 * v1 * cosTheta;
    }

    public static double dq1dph1(double y, double v1, double r1, double v2, double sinTheta) {
        return -y * r1 * 1.0 * v1 * v2 * sinTheta;
    }

    public static double dq1dph2(double y, double v1, double r1, double v2, double sinTheta) {
        return -ClosedBranchSide1ReactiveFlowEquationTerm.dq1dph1(y, v1, r1, v2, sinTheta);
    }

    public static double dq1da1(double y, double v1, double r1, double v2, double sinTheta) {
        return ClosedBranchSide1ReactiveFlowEquationTerm.dq1dph1(y, v1, r1, v2, sinTheta);
    }

    public static double dq1dr1(double y, double cosKsi, double b1, double v1, double r1, double v2, double cosTheta) {
        return v1 * (2.0 * r1 * v1 * (-b1 + y * cosKsi) - y * 1.0 * v2 * cosTheta);
    }

    @Override
    public double eval() {
        return ClosedBranchSide1ReactiveFlowEquationTerm.q1(this.y, FastMath.cos((double)this.ksi), this.b1, this.v1(), this.r1(), this.v2(), FastMath.cos((double)ClosedBranchSide1ReactiveFlowEquationTerm.theta1(this.ksi, this.ph1(), this.a1(), this.ph2())));
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        double theta = ClosedBranchSide1ReactiveFlowEquationTerm.theta1(this.ksi, this.ph1(), this.a1(), this.ph2());
        if (variable.equals(this.v1Var)) {
            return ClosedBranchSide1ReactiveFlowEquationTerm.dq1dv1(this.y, FastMath.cos((double)this.ksi), this.b1, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchSide1ReactiveFlowEquationTerm.dq1dv2(this.y, this.v1(), this.r1(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchSide1ReactiveFlowEquationTerm.dq1dph1(this.y, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchSide1ReactiveFlowEquationTerm.dq1dph2(this.y, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.a1Var)) {
            return ClosedBranchSide1ReactiveFlowEquationTerm.dq1da1(this.y, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.r1Var)) {
            return ClosedBranchSide1ReactiveFlowEquationTerm.dq1dr1(this.y, FastMath.cos((double)this.ksi), this.b1, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_q_closed_1";
    }
}

