/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchSide2ActiveFlowEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchSide2ActiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
    }

    public ClosedBranchSide2ActiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, sequenceType);
    }

    public static double calculateSensi(double y, double ksi, double g2, double v1, double ph1, double r1, double a1, double v2, double ph2, double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        double theta = ClosedBranchSide2ActiveFlowEquationTerm.theta2(ksi, ph1, a1, ph2);
        double cosTheta = FastMath.cos((double)theta);
        double sinTheta = FastMath.sin((double)theta);
        return ClosedBranchSide2ActiveFlowEquationTerm.dp2dph1(y, v1, r1, v2, cosTheta) * dph1 + ClosedBranchSide2ActiveFlowEquationTerm.dp2dph2(y, v1, r1, v2, cosTheta) * dph2 + ClosedBranchSide2ActiveFlowEquationTerm.dp2dv1(y, r1, v2, sinTheta) * dv1 + ClosedBranchSide2ActiveFlowEquationTerm.dp2dv2(y, FastMath.sin((double)ksi), g2, v1, r1, v2, sinTheta) * dv2 + ClosedBranchSide2ActiveFlowEquationTerm.dp2da1(y, v1, r1, v2, cosTheta) * da1 + ClosedBranchSide2ActiveFlowEquationTerm.dp2dr1(y, v1, v2, sinTheta) * dr1;
    }

    @Override
    protected double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return ClosedBranchSide2ActiveFlowEquationTerm.calculateSensi(this.y, this.ksi, this.g2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2(), dph1, dph2, dv1, dv2, da1, dr1);
    }

    public static double p2(double y, double sinKsi, double g2, double v1, double r1, double v2, double sinTheta) {
        return 1.0 * v2 * (g2 * 1.0 * v2 - y * r1 * v1 * sinTheta + y * 1.0 * v2 * sinKsi);
    }

    public static double dp2dv1(double y, double r1, double v2, double sinTheta) {
        return -y * r1 * 1.0 * v2 * sinTheta;
    }

    public static double dp2dv2(double y, double sinKsi, double g2, double v1, double r1, double v2, double sinTheta) {
        return 1.0 * (2.0 * g2 * 1.0 * v2 - y * r1 * v1 * sinTheta + 2.0 * y * 1.0 * v2 * sinKsi);
    }

    public static double dp2dph1(double y, double v1, double r1, double v2, double cosTheta) {
        return -y * r1 * 1.0 * v1 * v2 * cosTheta;
    }

    public static double dp2dph2(double y, double v1, double r1, double v2, double cosTheta) {
        return -ClosedBranchSide2ActiveFlowEquationTerm.dp2dph1(y, v1, r1, v2, cosTheta);
    }

    public static double dp2da1(double y, double v1, double r1, double v2, double cosTheta) {
        return ClosedBranchSide2ActiveFlowEquationTerm.dp2dph1(y, v1, r1, v2, cosTheta);
    }

    public static double dp2dr1(double y, double v1, double v2, double sinTheta) {
        return -y * 1.0 * v1 * v2 * sinTheta;
    }

    @Override
    public double eval() {
        return ClosedBranchSide2ActiveFlowEquationTerm.p2(this.y, FastMath.sin((double)this.ksi), this.g2, this.v1(), this.r1(), this.v2(), FastMath.sin((double)ClosedBranchSide2ActiveFlowEquationTerm.theta2(this.ksi, this.ph1(), this.a1(), this.ph2())));
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        double theta = ClosedBranchSide2ActiveFlowEquationTerm.theta2(this.ksi, this.ph1(), this.a1(), this.ph2());
        if (variable.equals(this.v1Var)) {
            return ClosedBranchSide2ActiveFlowEquationTerm.dp2dv1(this.y, this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchSide2ActiveFlowEquationTerm.dp2dv2(this.y, FastMath.sin((double)this.ksi), this.g2, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchSide2ActiveFlowEquationTerm.dp2dph1(this.y, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchSide2ActiveFlowEquationTerm.dp2dph2(this.y, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.a1Var)) {
            return ClosedBranchSide2ActiveFlowEquationTerm.dp2da1(this.y, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.r1Var)) {
            return ClosedBranchSide2ActiveFlowEquationTerm.dp2dr1(this.y, this.v1(), this.v2(), FastMath.sin((double)theta));
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_p_closed_2";
    }
}

