/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractOpenSide1BranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import java.util.Objects;
import net.jafama.FastMath;

public class OpenBranchSide1ActiveFlowEquationTerm
extends AbstractOpenSide1BranchAcFlowEquationTerm {
    private final Variable<AcVariableType> v2Var;

    public OpenBranchSide1ActiveFlowEquationTerm(LfBranch branch, LfBus bus2, VariableSet<AcVariableType> variableSet) {
        super(branch, AcVariableType.BUS_V, bus2, variableSet);
        this.v2Var = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_V);
    }

    private double v2() {
        return this.sv.get(this.v2Var.getRow());
    }

    public static double p2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double v2) {
        double shunt = OpenBranchSide1ActiveFlowEquationTerm.shunt(y, cosKsi, sinKsi, g1, b1);
        return 1.0 * v2 * v2 * (g2 + y * y * g1 / shunt + (b1 * b1 + g1 * g1) * y * sinKsi / shunt);
    }

    public static double dp2dv2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double v2) {
        double shunt = OpenBranchSide1ActiveFlowEquationTerm.shunt(y, cosKsi, sinKsi, g1, b1);
        return 2.0 * v2 * (g2 + y * y * g1 / shunt + (b1 * b1 + g1 * g1) * y * sinKsi / shunt);
    }

    @Override
    public double eval() {
        return OpenBranchSide1ActiveFlowEquationTerm.p2(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.b1, this.g2, this.v2());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v2Var)) {
            return OpenBranchSide1ActiveFlowEquationTerm.dp2dv2(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.b1, this.g2, this.v2());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_p_open_1";
    }
}

