/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractOpenSide1BranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import java.util.Objects;
import net.jafama.FastMath;

public class OpenBranchSide1CurrentMagnitudeEquationTerm
extends AbstractOpenSide1BranchAcFlowEquationTerm {
    private final Variable<AcVariableType> v2Var;
    private final Variable<AcVariableType> ph2Var;

    public OpenBranchSide1CurrentMagnitudeEquationTerm(LfBranch branch, LfBus bus2, VariableSet<AcVariableType> variableSet) {
        super(branch, AcVariableType.BUS_V, bus2, variableSet);
        this.v2Var = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_V);
        this.ph2Var = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_PHI);
    }

    private double v2() {
        return this.sv.get(this.v2Var.getRow());
    }

    private double ph2() {
        return this.sv.get(this.ph2Var.getRow());
    }

    private static double gres(double y, double sinKsi, double g1, double b1, double g2, double shunt) {
        return g2 + (y * y * g1 + (b1 * b1 + g1 * g1) * y * sinKsi) / shunt;
    }

    private static double bres(double y, double cosKsi, double g1, double b1, double b2, double shunt) {
        return b2 + (y * y * b1 - (b1 * b1 + g1 * g1) * y * cosKsi) / shunt;
    }

    private static double reI2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v2, double ph2) {
        double shunt = OpenBranchSide1CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g1, b1);
        return 1.0 * v2 * (OpenBranchSide1CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, b1, g2, shunt) * FastMath.cos((double)ph2) - OpenBranchSide1CurrentMagnitudeEquationTerm.bres(y, cosKsi, g1, b1, b2, shunt) * FastMath.sin((double)ph2));
    }

    private static double imI2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v2, double ph2) {
        double shunt = OpenBranchSide1CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g1, b1);
        return 1.0 * v2 * (OpenBranchSide1CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, b1, g2, shunt) * FastMath.sin((double)ph2) + OpenBranchSide1CurrentMagnitudeEquationTerm.bres(y, cosKsi, g1, b1, b2, shunt) * FastMath.cos((double)ph2));
    }

    private static double i2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v2, double ph2) {
        return FastMath.hypot((double)OpenBranchSide1CurrentMagnitudeEquationTerm.reI2(y, cosKsi, sinKsi, g1, b1, g2, b2, v2, ph2), (double)OpenBranchSide1CurrentMagnitudeEquationTerm.imI2(y, cosKsi, sinKsi, g1, b1, g2, b2, v2, ph2));
    }

    private static double dreI2dv2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double ph2) {
        double shunt = OpenBranchSide1CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g1, b1);
        return 1.0 * (OpenBranchSide1CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, b1, g2, shunt) * FastMath.cos((double)ph2) - OpenBranchSide1CurrentMagnitudeEquationTerm.bres(y, cosKsi, g1, b1, b2, shunt) * FastMath.sin((double)ph2));
    }

    private static double dimI2dv2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double ph2) {
        double shunt = OpenBranchSide1CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g1, b1);
        return 1.0 * (OpenBranchSide1CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, b1, g2, shunt) * FastMath.sin((double)ph2) + OpenBranchSide1CurrentMagnitudeEquationTerm.bres(y, cosKsi, g1, b1, b2, shunt) * FastMath.cos((double)ph2));
    }

    public static double di2dv2(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v2, double ph2) {
        return (OpenBranchSide1CurrentMagnitudeEquationTerm.reI2(y, cosKsi, sinKsi, g1, b1, g2, b2, v2, ph2) * OpenBranchSide1CurrentMagnitudeEquationTerm.dreI2dv2(y, cosKsi, sinKsi, g1, b1, g2, b2, ph2) + OpenBranchSide1CurrentMagnitudeEquationTerm.imI2(y, cosKsi, sinKsi, g1, b1, g2, b2, v2, ph2) * OpenBranchSide1CurrentMagnitudeEquationTerm.dimI2dv2(y, cosKsi, sinKsi, g1, b1, g2, b2, ph2)) / OpenBranchSide1CurrentMagnitudeEquationTerm.i2(y, cosKsi, sinKsi, g1, b1, g2, b2, v2, ph2);
    }

    @Override
    public double eval() {
        return OpenBranchSide1CurrentMagnitudeEquationTerm.i2(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.b1, this.g2, this.b2, this.v2(), this.ph2());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v2Var)) {
            return OpenBranchSide1CurrentMagnitudeEquationTerm.di2dv2(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.b1, this.g2, this.b2, this.v2(), this.ph2());
        }
        if (variable.equals(this.ph2Var)) {
            throw new IllegalArgumentException("Derivative with respect to ph2 not implemented");
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_i_open_1";
    }
}

