/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractOpenSide2BranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import java.util.Objects;
import net.jafama.FastMath;

public class OpenBranchSide2ReactiveFlowEquationTerm
extends AbstractOpenSide2BranchAcFlowEquationTerm {
    private final Variable<AcVariableType> v1Var;

    public OpenBranchSide2ReactiveFlowEquationTerm(LfBranch branch, LfBus bus1, VariableSet<AcVariableType> variableSet) {
        super(branch, AcVariableType.BUS_V, bus1, variableSet);
        this.v1Var = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_V);
    }

    private double v1() {
        return this.sv.get(this.v1Var.getRow());
    }

    private double r1() {
        return ((LfBranch)this.element).getPiModel().getR1();
    }

    public static double q1(double y, double cosKsi, double sinKsi, double b1, double g2, double b2, double v1, double r1) {
        double shunt = OpenBranchSide2ReactiveFlowEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return -r1 * r1 * v1 * v1 * (b1 + y * y * b2 / shunt - (b2 * b2 + g2 * g2) * y * cosKsi / shunt);
    }

    public static double dq1dv1(double y, double cosKsi, double sinKsi, double b1, double g2, double b2, double v1, double r1) {
        double shunt = OpenBranchSide2ReactiveFlowEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return -2.0 * v1 * r1 * r1 * (b1 + y * y * b2 / shunt - (b2 * b2 + g2 * g2) * y * cosKsi / shunt);
    }

    @Override
    public double eval() {
        return OpenBranchSide2ReactiveFlowEquationTerm.q1(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.b1, this.g2, this.b2, this.v1(), this.r1());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var)) {
            return OpenBranchSide2ReactiveFlowEquationTerm.dq1dv1(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.b1, this.g2, this.b2, this.v1(), this.r1());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_q_open_2";
    }
}

