/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.asym.AbstractAsymmetricalBranchFlowEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.ComplexPart;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractAsymmetricalClosedBranchCoupledFlowEquationTerm
extends AbstractAsymmetricalBranchFlowEquationTerm {
    protected final Variable<AcVariableType> v1Var;
    protected final Variable<AcVariableType> v2Var;
    protected final Variable<AcVariableType> ph1Var;
    protected final Variable<AcVariableType> ph2Var;
    protected final Variable<AcVariableType> v1VarNegative;
    protected final Variable<AcVariableType> v2VarNegative;
    protected final Variable<AcVariableType> ph1VarNegative;
    protected final Variable<AcVariableType> ph2VarNegative;
    protected final Variable<AcVariableType> v1VarZero;
    protected final Variable<AcVariableType> v2VarZero;
    protected final Variable<AcVariableType> ph1VarZero;
    protected final Variable<AcVariableType> ph2VarZero;
    protected final List<Variable<AcVariableType>> variables = new ArrayList<Variable<AcVariableType>>();
    protected final ComplexPart complexPart;
    protected final TwoSides side;
    protected final Fortescue.SequenceType sequenceType;

    protected AbstractAsymmetricalClosedBranchCoupledFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, ComplexPart complexPart, TwoSides side, Fortescue.SequenceType sequenceType) {
        super(branch);
        Objects.requireNonNull(bus1);
        Objects.requireNonNull(bus2);
        Objects.requireNonNull(variableSet);
        this.complexPart = Objects.requireNonNull(complexPart);
        this.side = Objects.requireNonNull(side);
        this.sequenceType = Objects.requireNonNull(sequenceType);
        this.v1Var = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_V);
        this.v2Var = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_V);
        this.ph1Var = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_PHI);
        this.ph2Var = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_PHI);
        this.v1VarNegative = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_V_NEGATIVE);
        this.v2VarNegative = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_V_NEGATIVE);
        this.ph1VarNegative = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_PHI_NEGATIVE);
        this.ph2VarNegative = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_PHI_NEGATIVE);
        this.v1VarZero = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_V_ZERO);
        this.v2VarZero = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_V_ZERO);
        this.ph1VarZero = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_PHI_ZERO);
        this.ph2VarZero = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_PHI_ZERO);
        this.variables.add(this.v1Var);
        this.variables.add(this.v2Var);
        this.variables.add(this.ph1Var);
        this.variables.add(this.ph2Var);
        this.variables.add(this.v1VarNegative);
        this.variables.add(this.v2VarNegative);
        this.variables.add(this.ph1VarNegative);
        this.variables.add(this.ph2VarNegative);
        this.variables.add(this.v1VarZero);
        this.variables.add(this.v2VarZero);
        this.variables.add(this.ph1VarZero);
        this.variables.add(this.ph2VarZero);
    }

    protected static Fortescue.SequenceType getSequenceType(Variable<AcVariableType> variable) {
        return switch (variable.getType()) {
            case AcVariableType.BUS_V, AcVariableType.BUS_PHI -> Fortescue.SequenceType.POSITIVE;
            case AcVariableType.BUS_V_NEGATIVE, AcVariableType.BUS_PHI_NEGATIVE -> Fortescue.SequenceType.NEGATIVE;
            case AcVariableType.BUS_V_ZERO, AcVariableType.BUS_PHI_ZERO -> Fortescue.SequenceType.ZERO;
            default -> throw new IllegalStateException("Unknown variable: " + variable);
        };
    }

    protected static boolean isPhase(Variable<AcVariableType> variable) {
        return switch (variable.getType()) {
            case AcVariableType.BUS_PHI, AcVariableType.BUS_PHI_NEGATIVE, AcVariableType.BUS_PHI_ZERO -> true;
            default -> false;
        };
    }

    protected double v(Fortescue.SequenceType g, TwoSides i) {
        return switch (g) {
            default -> throw new IncompatibleClassChangeError();
            case Fortescue.SequenceType.ZERO -> {
                if (i == TwoSides.ONE) {
                    yield this.sv.get(this.v1VarZero.getRow());
                }
                yield this.sv.get(this.v2VarZero.getRow());
            }
            case Fortescue.SequenceType.POSITIVE -> {
                if (i == TwoSides.ONE) {
                    yield this.sv.get(this.v1Var.getRow());
                }
                yield this.sv.get(this.v2Var.getRow());
            }
            case Fortescue.SequenceType.NEGATIVE -> i == TwoSides.ONE ? this.sv.get(this.v1VarNegative.getRow()) : this.sv.get(this.v2VarNegative.getRow());
        };
    }

    protected double ph(Fortescue.SequenceType g, TwoSides i) {
        return switch (g) {
            default -> throw new IncompatibleClassChangeError();
            case Fortescue.SequenceType.ZERO -> {
                if (i == TwoSides.ONE) {
                    yield this.sv.get(this.ph1VarZero.getRow());
                }
                yield this.sv.get(this.ph2VarZero.getRow());
            }
            case Fortescue.SequenceType.POSITIVE -> {
                if (i == TwoSides.ONE) {
                    yield this.sv.get(this.ph1Var.getRow());
                }
                yield this.sv.get(this.ph2Var.getRow());
            }
            case Fortescue.SequenceType.NEGATIVE -> i == TwoSides.ONE ? this.sv.get(this.ph1VarNegative.getRow()) : this.sv.get(this.ph2VarNegative.getRow());
        };
    }

    protected double r1() {
        return 1.0;
    }

    protected double a1() {
        return 0.0;
    }

    protected double r(TwoSides i) {
        return i == TwoSides.ONE ? this.r1() : 1.0;
    }

    protected double a(TwoSides i) {
        return i == TwoSides.ONE ? this.a1() : 0.0;
    }

    @Override
    public List<Variable<AcVariableType>> getVariables() {
        return this.variables;
    }

    public TwoSides getSide(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var) || variable.equals(this.v1VarZero) || variable.equals(this.v1VarNegative) || variable.equals(this.ph1Var) || variable.equals(this.ph1VarZero) || variable.equals(this.ph1VarNegative)) {
            return TwoSides.ONE;
        }
        if (variable.equals(this.v2Var) || variable.equals(this.v2VarZero) || variable.equals(this.v2VarNegative) || variable.equals(this.ph2Var) || variable.equals(this.ph2VarZero) || variable.equals(this.ph2VarNegative)) {
            return TwoSides.TWO;
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }
}

