/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreationParameters;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreator;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.ClosedBranchI1xFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchI1yFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchI2xFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchI2yFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide1ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide1CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide1ReactiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide2ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide2CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide2ReactiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.asym.AsymmetricalClosedBranchCoupledCurrentEquationTerm;
import com.powsybl.openloadflow.ac.equations.asym.AsymmetricalClosedBranchCoupledPowerEquationTerm;
import com.powsybl.openloadflow.ac.equations.asym.LoadFortescuePowerEquationTerm;
import com.powsybl.openloadflow.ac.equations.asym.ShuntFortescueIxEquationTerm;
import com.powsybl.openloadflow.ac.equations.asym.ShuntFortescueIyEquationTerm;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.network.LfAsymBus;
import com.powsybl.openloadflow.network.LfAsymGenerator;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.util.ComplexPart;
import com.powsybl.openloadflow.util.Fortescue;

public class AsymmetricalAcEquationSystemCreator
extends AcEquationSystemCreator {
    private static final double EPSILON = 1.0E-5;

    public AsymmetricalAcEquationSystemCreator(LfNetwork network, AcEquationSystemCreationParameters creationParameters) {
        super(network, creationParameters);
    }

    @Override
    protected void createBusEquation(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        super.createBusEquation(bus, equationSystem);
        LfAsymBus asymBus = bus.getAsym();
        Equation<AcVariableType, AcEquationType> ixh = equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IX_ZERO);
        asymBus.setIxZ(ixh);
        Equation<AcVariableType, AcEquationType> iyh = equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IY_ZERO);
        asymBus.setIyZ(iyh);
        Equation<AcVariableType, AcEquationType> ixi = equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IX_NEGATIVE);
        asymBus.setIxN(ixi);
        Equation<AcVariableType, AcEquationType> iyi = equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IY_NEGATIVE);
        asymBus.setIyN(iyi);
        for (LfGenerator gen : bus.getGenerators()) {
            LfAsymGenerator asymGen;
            if (gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.REMOTE_REACTIVE_POWER || gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.MONITORING_VOLTAGE) {
                throw new IllegalStateException("Generator with control type " + gen.getGeneratorControlType() + " not yet supported in asymmetric load flow: " + gen.getId());
            }
            if (gen.getGeneratorControlType() != LfGenerator.GeneratorControlType.VOLTAGE || (asymGen = gen.getAsym()) == null) continue;
            asymBus.setBzEquiv(asymBus.getBzEquiv() + asymGen.getBz());
            asymBus.setGzEquiv(asymBus.getGzEquiv() + asymGen.getGz());
            asymBus.setBnEquiv(asymBus.getBnEquiv() + asymGen.getBn());
            asymBus.setGnEquiv(asymBus.getGnEquiv() + asymGen.getGn());
        }
        if (Math.abs(asymBus.getBzEquiv()) > 1.0E-5 || Math.abs(asymBus.getGzEquiv()) > 1.0E-5) {
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IX_ZERO).addTerm(new ShuntFortescueIxEquationTerm(bus, equationSystem.getVariableSet(), Fortescue.SequenceType.ZERO));
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IY_ZERO).addTerm(new ShuntFortescueIyEquationTerm(bus, equationSystem.getVariableSet(), Fortescue.SequenceType.ZERO));
        }
        if (Math.abs(asymBus.getGnEquiv()) > 1.0E-5 || Math.abs(asymBus.getBnEquiv()) > 1.0E-5) {
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IX_NEGATIVE).addTerm(new ShuntFortescueIxEquationTerm(bus, equationSystem.getVariableSet(), Fortescue.SequenceType.NEGATIVE));
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IY_NEGATIVE).addTerm(new ShuntFortescueIyEquationTerm(bus, equationSystem.getVariableSet(), Fortescue.SequenceType.NEGATIVE));
        }
        if (Math.abs(bus.getLoadTargetP()) > 1.0E-5 || Math.abs(bus.getLoadTargetQ()) > 1.0E-5) {
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IX_ZERO).addTerm(new LoadFortescuePowerEquationTerm(bus, equationSystem.getVariableSet(), ComplexPart.REAL, Fortescue.SequenceType.ZERO));
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_P).addTerm(new LoadFortescuePowerEquationTerm(bus, equationSystem.getVariableSet(), ComplexPart.REAL, Fortescue.SequenceType.POSITIVE));
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IX_NEGATIVE).addTerm(new LoadFortescuePowerEquationTerm(bus, equationSystem.getVariableSet(), ComplexPart.REAL, Fortescue.SequenceType.NEGATIVE));
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IY_ZERO).addTerm(new LoadFortescuePowerEquationTerm(bus, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, Fortescue.SequenceType.ZERO));
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_Q).addTerm(new LoadFortescuePowerEquationTerm(bus, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, Fortescue.SequenceType.POSITIVE));
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_IY_NEGATIVE).addTerm(new LoadFortescuePowerEquationTerm(bus, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, Fortescue.SequenceType.NEGATIVE));
        }
    }

    @Override
    protected void createImpedantBranch(LfBranch branch, LfBus bus1, LfBus bus2, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        AbstractElementEquationTerm p1 = null;
        AbstractElementEquationTerm q1 = null;
        AbstractElementEquationTerm p2 = null;
        AbstractElementEquationTerm q2 = null;
        ClosedBranchSide1CurrentMagnitudeEquationTerm i1 = null;
        ClosedBranchSide2CurrentMagnitudeEquationTerm i2 = null;
        AbstractElementEquationTerm ixz1 = null;
        AbstractElementEquationTerm iyz1 = null;
        AbstractElementEquationTerm ixz2 = null;
        AbstractElementEquationTerm iyz2 = null;
        AbstractElementEquationTerm ixn1 = null;
        AbstractElementEquationTerm iyn1 = null;
        AbstractElementEquationTerm ixn2 = null;
        AbstractElementEquationTerm iyn2 = null;
        boolean deriveA1 = AsymmetricalAcEquationSystemCreator.isDeriveA1(branch, this.creationParameters);
        boolean deriveR1 = AsymmetricalAcEquationSystemCreator.isDeriveR1(branch);
        if (bus1 != null && bus2 != null) {
            if (!branch.isAsymmetric()) {
                p1 = new ClosedBranchSide1ActiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
                q1 = new ClosedBranchSide1ReactiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
                p2 = new ClosedBranchSide2ActiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
                q2 = new ClosedBranchSide2ReactiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
                i1 = new ClosedBranchSide1CurrentMagnitudeEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
                i2 = new ClosedBranchSide2CurrentMagnitudeEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
                ixz1 = new ClosedBranchI1xFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.ZERO);
                iyz1 = new ClosedBranchI1yFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.ZERO);
                ixz2 = new ClosedBranchI2xFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.ZERO);
                iyz2 = new ClosedBranchI2yFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.ZERO);
                ixn1 = new ClosedBranchI1xFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.NEGATIVE);
                iyn1 = new ClosedBranchI1yFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.NEGATIVE);
                ixn2 = new ClosedBranchI2xFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.NEGATIVE);
                iyn2 = new ClosedBranchI2yFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1, Fortescue.SequenceType.NEGATIVE);
            } else {
                p1 = new AsymmetricalClosedBranchCoupledPowerEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.REAL, TwoSides.ONE, Fortescue.SequenceType.POSITIVE);
                q1 = new AsymmetricalClosedBranchCoupledPowerEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, TwoSides.ONE, Fortescue.SequenceType.POSITIVE);
                p2 = new AsymmetricalClosedBranchCoupledPowerEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.REAL, TwoSides.TWO, Fortescue.SequenceType.POSITIVE);
                q2 = new AsymmetricalClosedBranchCoupledPowerEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, TwoSides.TWO, Fortescue.SequenceType.POSITIVE);
                ixz1 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.REAL, TwoSides.ONE, Fortescue.SequenceType.ZERO);
                iyz1 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, TwoSides.ONE, Fortescue.SequenceType.ZERO);
                ixz2 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.REAL, TwoSides.TWO, Fortescue.SequenceType.ZERO);
                iyz2 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, TwoSides.TWO, Fortescue.SequenceType.ZERO);
                ixn1 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.REAL, TwoSides.ONE, Fortescue.SequenceType.NEGATIVE);
                iyn1 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, TwoSides.ONE, Fortescue.SequenceType.NEGATIVE);
                ixn2 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.REAL, TwoSides.TWO, Fortescue.SequenceType.NEGATIVE);
                iyn2 = new AsymmetricalClosedBranchCoupledCurrentEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), ComplexPart.IMAGINARY, TwoSides.TWO, Fortescue.SequenceType.NEGATIVE);
            }
        } else {
            if (bus1 != null) {
                throw new IllegalStateException("Line open at one side not yet supported in asymmetric load flow at bus: " + bus1.getId());
            }
            if (bus2 != null) {
                throw new IllegalStateException("Line open at one side not yet supported in asymmetric load flow  at bus: " + bus2.getId());
            }
        }
        AsymmetricalAcEquationSystemCreator.createImpedantBranchEquations(branch, bus1, bus2, equationSystem, p1, q1, i1, p2, q2, i2, p1, q1, i1, p2, q2, i2, null, null, null, null, null, null);
        if (ixz1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_IX_ZERO).orElseThrow().addTerm(ixz1);
        }
        if (iyz1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_IY_ZERO).orElseThrow().addTerm(iyz1);
        }
        if (ixz2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_IX_ZERO).orElseThrow().addTerm(ixz2);
        }
        if (iyz2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_IY_ZERO).orElseThrow().addTerm(iyz2);
        }
        if (ixn1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_IX_NEGATIVE).orElseThrow().addTerm(ixn1);
        }
        if (iyn1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_IY_NEGATIVE).orElseThrow().addTerm(iyn1);
        }
        if (ixn2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_IX_NEGATIVE).orElseThrow().addTerm(ixn2);
        }
        if (iyn2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_IY_NEGATIVE).orElseThrow().addTerm(iyn2);
        }
        this.createGeneratorReactivePowerControlBranchEquation(branch, bus1, bus2, equationSystem, deriveA1, deriveR1);
        AsymmetricalAcEquationSystemCreator.createTransformerPhaseControlEquations(branch, bus1, bus2, equationSystem, deriveA1, deriveR1);
        AsymmetricalAcEquationSystemCreator.createTransformerReactivePowerControlEquations(branch, equationSystem);
    }
}

