/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.asym.AbstractAsymmetricalClosedBranchCoupledFlowEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.ComplexPart;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class AsymmetricalClosedBranchCoupledPowerEquationTerm
extends AbstractAsymmetricalClosedBranchCoupledFlowEquationTerm {
    public AsymmetricalClosedBranchCoupledPowerEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, ComplexPart complexPart, TwoSides side, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, complexPart, side, sequenceType);
    }

    public double dpdv(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        double tmpVal = this.y.getX(i, j, g, h) * FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) + this.y.getY(i, j, g, h) * FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j)));
        if (i == derivationSide && g == derivationSequence && j == derivationSide && h == derivationSequence) {
            return 2.0 * this.r(i) * this.r(j) * this.v(g, i) * tmpVal;
        }
        if (i == derivationSide && g == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(h, j) * tmpVal;
        }
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(g, i) * tmpVal;
        }
        return 0.0;
    }

    public double dpdph(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        if (i == derivationSide && g == derivationSequence && j == derivationSide && h == derivationSequence) {
            return 0.0;
        }
        if (i == derivationSide && g == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(g, i) * this.v(h, j) * (this.y.getX(i, j, g, h) * -FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) + this.y.getY(i, j, g, h) * FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))));
        }
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(g, i) * this.v(h, j) * (this.y.getX(i, j, g, h) * -FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) - this.y.getY(i, j, g, h) * FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))));
        }
        return 0.0;
    }

    public double dqdv(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        double tmpVal = this.y.getX(i, j, g, h) * FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) - this.y.getY(i, j, g, h) * FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j)));
        if (i == derivationSide && g == derivationSequence && j == derivationSide && h == derivationSequence) {
            return 2.0 * this.r(i) * this.r(j) * this.v(g, i) * tmpVal;
        }
        if (i == derivationSide && g == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(h, j) * tmpVal;
        }
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(g, i) * tmpVal;
        }
        return 0.0;
    }

    public double dqdph(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        if (i == derivationSide && g == derivationSequence && j == derivationSide && h == derivationSequence) {
            return 0.0;
        }
        if (i == derivationSide && g == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(g, i) * this.v(h, j) * (this.y.getX(i, j, g, h) * FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) + this.y.getY(i, j, g, h) * FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))));
        }
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(g, i) * this.v(h, j) * (this.y.getX(i, j, g, h) * -FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) + this.y.getY(i, j, g, h) * FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))));
        }
        return 0.0;
    }

    public double p(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h) {
        return this.r(i) * this.r(j) * this.v(g, i) * this.v(h, j) * (this.y.getX(i, j, g, h) * FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) + this.y.getY(i, j, g, h) * FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))));
    }

    public double q(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h) {
        return this.r(i) * this.r(j) * this.v(g, i) * this.v(h, j) * (this.y.getX(i, j, g, h) * FastMath.sin((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))) - this.y.getY(i, j, g, h) * FastMath.cos((double)(this.a(i) - this.a(j) + this.ph(g, i) - this.ph(h, j))));
    }

    public double dp(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence, boolean phase) {
        if (phase) {
            return this.dpdph(i, j, g, h, derivationSide, derivationSequence);
        }
        return this.dpdv(i, j, g, h, derivationSide, derivationSequence);
    }

    public double dq(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence, boolean phase) {
        if (phase) {
            return this.dqdph(i, j, g, h, derivationSide, derivationSequence);
        }
        return this.dqdv(i, j, g, h, derivationSide, derivationSequence);
    }

    public double s() {
        TwoSides j;
        TwoSides i;
        if (this.side == TwoSides.ONE) {
            i = TwoSides.ONE;
            j = TwoSides.TWO;
        } else {
            i = TwoSides.TWO;
            j = TwoSides.ONE;
        }
        if (this.complexPart == ComplexPart.REAL) {
            return this.p(i, i, this.sequenceType, Fortescue.SequenceType.ZERO) + this.p(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.p(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE) + this.p(i, j, this.sequenceType, Fortescue.SequenceType.ZERO) + this.p(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.p(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE);
        }
        return this.q(i, i, this.sequenceType, Fortescue.SequenceType.ZERO) + this.q(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.q(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE) + this.q(i, j, this.sequenceType, Fortescue.SequenceType.ZERO) + this.q(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.q(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE);
    }

    public double ds(Variable<AcVariableType> variable) {
        TwoSides j;
        TwoSides i;
        if (this.side == TwoSides.ONE) {
            i = TwoSides.ONE;
            j = TwoSides.TWO;
        } else {
            i = TwoSides.TWO;
            j = TwoSides.ONE;
        }
        TwoSides derivationSide = this.getSide(variable);
        Fortescue.SequenceType derivationSequence = AsymmetricalClosedBranchCoupledPowerEquationTerm.getSequenceType(variable);
        boolean phase = AsymmetricalClosedBranchCoupledPowerEquationTerm.isPhase(variable);
        if (this.complexPart == ComplexPart.REAL) {
            return this.dp(i, i, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.dp(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.dp(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase) + this.dp(i, j, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.dp(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.dp(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase);
        }
        return this.dq(i, i, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.dq(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.dq(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase) + this.dq(i, j, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.dq(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.dq(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase);
    }

    @Override
    public double eval() {
        return this.s();
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        return this.ds(variable);
    }

    @Override
    public String getName() {
        return "ac_pq_coupled_closed";
    }
}

