/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfAsymBus;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.ComplexPart;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jafama.FastMath;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;

public class LoadFortescuePowerEquationTerm
extends AbstractElementEquationTerm<LfBus, AcVariableType, AcEquationType> {
    protected final Variable<AcVariableType> vVar;
    protected final Variable<AcVariableType> phVar;
    protected final Variable<AcVariableType> vVarNegative;
    protected final Variable<AcVariableType> phVarNegative;
    protected final Variable<AcVariableType> vVarZero;
    protected final Variable<AcVariableType> phVarZero;
    protected final List<Variable<AcVariableType>> variables = new ArrayList<Variable<AcVariableType>>();
    private final ComplexPart complexPart;
    private final Fortescue.SequenceType sequenceType;

    public LoadFortescuePowerEquationTerm(LfBus bus, VariableSet<AcVariableType> variableSet, ComplexPart complexPart, Fortescue.SequenceType sequenceType) {
        super(bus);
        Objects.requireNonNull(variableSet);
        this.complexPart = Objects.requireNonNull(complexPart);
        this.sequenceType = Objects.requireNonNull(sequenceType);
        this.vVar = variableSet.getVariable(bus.getNum(), AcVariableType.BUS_V);
        this.phVar = variableSet.getVariable(bus.getNum(), AcVariableType.BUS_PHI);
        this.vVarNegative = variableSet.getVariable(bus.getNum(), AcVariableType.BUS_V_NEGATIVE);
        this.phVarNegative = variableSet.getVariable(bus.getNum(), AcVariableType.BUS_PHI_NEGATIVE);
        this.vVarZero = variableSet.getVariable(bus.getNum(), AcVariableType.BUS_V_ZERO);
        this.phVarZero = variableSet.getVariable(bus.getNum(), AcVariableType.BUS_PHI_ZERO);
        this.variables.add(this.vVar);
        this.variables.add(this.phVar);
        this.variables.add(this.vVarNegative);
        this.variables.add(this.phVarNegative);
        this.variables.add(this.vVarZero);
        this.variables.add(this.phVarZero);
    }

    public double ph(Fortescue.SequenceType g) {
        switch (g) {
            case ZERO: {
                return this.sv.get(this.phVarZero.getRow());
            }
            case POSITIVE: {
                return this.sv.get(this.phVar.getRow());
            }
            case NEGATIVE: {
                return this.sv.get(this.phVarNegative.getRow());
            }
        }
        throw new IllegalStateException("Unknown Phi variable at bus: " + ((LfBus)this.element).getId());
    }

    public double v(Fortescue.SequenceType g) {
        switch (g) {
            case ZERO: {
                return this.sv.get(this.vVarZero.getRow());
            }
            case POSITIVE: {
                return this.sv.get(this.vVar.getRow());
            }
            case NEGATIVE: {
                return this.sv.get(this.vVarNegative.getRow());
            }
        }
        throw new IllegalStateException("Unknown V variable at bus: " + ((LfBus)this.element).getId());
    }

    public static double pq(LfBus bus, ComplexPart complexPart, Fortescue.SequenceType sequenceType, double vZero, double phZero, double vPositive, double phPositive, double vNegative, double phNegative) {
        LfAsymBus asymBus = bus.getAsym();
        if (asymBus == null) {
            throw new IllegalStateException("unexpected null pointer for an asymmetric bus " + bus.getId());
        }
        DenseMatrix mSabc3 = LoadFortescuePowerEquationTerm.createCartesianMatrix(asymBus.getPa() / 3.0, asymBus.getQa() / 3.0, asymBus.getPb() / 3.0, asymBus.getQb() / 3.0, asymBus.getPc() / 3.0, asymBus.getQc() / 3.0, true);
        Vector2D positiveSequence = Fortescue.getCartesianFromPolar(vPositive, phPositive);
        Vector2D zeroSequence = Fortescue.getCartesianFromPolar(vZero, phZero);
        Vector2D negativeSequence = Fortescue.getCartesianFromPolar(vNegative, phNegative);
        DenseMatrix mVfortescue = LoadFortescuePowerEquationTerm.createCartesianMatrix(zeroSequence.getX(), zeroSequence.getY(), positiveSequence.getX(), positiveSequence.getY(), negativeSequence.getX(), negativeSequence.getY(), true);
        DenseMatrix mVabc = Fortescue.createMatrix().times(mVfortescue).toDense();
        DenseMatrix mInvVabc = LoadFortescuePowerEquationTerm.createInvVabcSquare(bus, mVabc.get(0, 0), mVabc.get(1, 0), mVabc.get(2, 0), mVabc.get(3, 0), mVabc.get(4, 0), mVabc.get(5, 0));
        DenseMatrix mSquareVFortescue = LoadFortescuePowerEquationTerm.createCartesianMatrix(mVfortescue.get(0, 0), mVfortescue.get(1, 0), mVfortescue.get(2, 0), mVfortescue.get(3, 0), mVfortescue.get(4, 0), mVfortescue.get(5, 0), false);
        DenseMatrix m0T0 = mInvVabc.times(mSabc3);
        DenseMatrix mIfortescueConjugate = Fortescue.createMatrix().times(m0T0);
        DenseMatrix mSfortescue = mSquareVFortescue.times(mIfortescueConjugate);
        switch (sequenceType) {
            case ZERO: {
                return complexPart == ComplexPart.REAL ? mIfortescueConjugate.get(0, 0) : -mIfortescueConjugate.get(1, 0);
            }
            case POSITIVE: {
                return complexPart == ComplexPart.REAL ? mSfortescue.get(2, 0) : mSfortescue.get(3, 0);
            }
            case NEGATIVE: {
                return complexPart == ComplexPart.REAL ? mIfortescueConjugate.get(4, 0) : -mIfortescueConjugate.get(5, 0);
            }
        }
        throw new IllegalStateException("Unknown sequence at bus : " + bus.getId());
    }

    public static double dpq(LfBus bus, ComplexPart complexPart, Fortescue.SequenceType sequenceType, Variable<AcVariableType> derVariable, double vo, double pho, double vd, double phd, double vi, double phi) {
        LfAsymBus asymBus = bus.getAsym();
        if (asymBus == null) {
            throw new IllegalStateException("unexpected null pointer for an asymmetric bus " + bus.getId());
        }
        double dV0x = 0.0;
        double dV0y = 0.0;
        double dV1x = 0.0;
        double dV1y = 0.0;
        double dV2x = 0.0;
        double dV2y = 0.0;
        if (derVariable.getType() == AcVariableType.BUS_V) {
            dV1x = FastMath.cos((double)phd);
            dV1y = FastMath.sin((double)phd);
        } else if (derVariable.getType() == AcVariableType.BUS_V_ZERO) {
            dV0x = FastMath.cos((double)pho);
            dV0y = FastMath.sin((double)pho);
        } else if (derVariable.getType() == AcVariableType.BUS_V_NEGATIVE) {
            dV2x = FastMath.cos((double)phi);
            dV2y = FastMath.sin((double)phi);
        } else if (derVariable.getType() == AcVariableType.BUS_PHI) {
            dV1x = vd * -FastMath.sin((double)phd);
            dV1y = vd * FastMath.cos((double)phd);
        } else if (derVariable.getType() == AcVariableType.BUS_PHI_ZERO) {
            dV0x = vo * -FastMath.sin((double)pho);
            dV0y = vo * FastMath.cos((double)pho);
        } else if (derVariable.getType() == AcVariableType.BUS_PHI_NEGATIVE) {
            dV2x = vi * -FastMath.sin((double)phi);
            dV2y = vi * FastMath.cos((double)phi);
        } else {
            throw new IllegalStateException("Unknown derivation variable: " + derVariable + " at bus : " + bus.getId());
        }
        Vector2D positiveComponent = Fortescue.getCartesianFromPolar(vd, phd);
        Vector2D zeroComponent = Fortescue.getCartesianFromPolar(vo, pho);
        Vector2D negativeComponent = Fortescue.getCartesianFromPolar(vi, phi);
        DenseMatrix mVfortescue = LoadFortescuePowerEquationTerm.createCartesianMatrix(zeroComponent.getX(), zeroComponent.getY(), positiveComponent.getX(), positiveComponent.getY(), negativeComponent.getX(), negativeComponent.getY(), true);
        DenseMatrix mVabc = Fortescue.createMatrix().times(mVfortescue).toDense();
        DenseMatrix mSabc3 = LoadFortescuePowerEquationTerm.createCartesianMatrix(asymBus.getPa() / 3.0, asymBus.getQa() / 3.0, asymBus.getPb() / 3.0, asymBus.getQb() / 3.0, asymBus.getPc() / 3.0, asymBus.getQc() / 3.0, true);
        DenseMatrix mInvVabc = LoadFortescuePowerEquationTerm.createInvVabcSquare(bus, mVabc.get(0, 0), mVabc.get(1, 0), mVabc.get(2, 0), mVabc.get(3, 0), mVabc.get(4, 0), mVabc.get(5, 0));
        DenseMatrix mdVSquare = LoadFortescuePowerEquationTerm.createCartesianMatrix(dV0x, dV0y, dV1x, dV1y, dV2x, dV2y, false);
        DenseMatrix m0T1 = mInvVabc.times(mSabc3);
        DenseMatrix m1T1 = Fortescue.createMatrix().times(m0T1);
        DenseMatrix mT1 = mdVSquare.times(m1T1);
        DenseMatrix mSquareVFortescue = LoadFortescuePowerEquationTerm.createCartesianMatrix(mVfortescue.get(0, 0), mVfortescue.get(1, 0), mVfortescue.get(2, 0), mVfortescue.get(3, 0), mVfortescue.get(4, 0), mVfortescue.get(5, 0), false);
        DenseMatrix mMinusSabc3Square = LoadFortescuePowerEquationTerm.createCartesianMatrix(-asymBus.getPa() / 3.0, -asymBus.getQa() / 3.0, -asymBus.getPb() / 3.0, -asymBus.getQb() / 3.0, -asymBus.getPc() / 3.0, -asymBus.getQc() / 3.0, false);
        DenseMatrix mdV = LoadFortescuePowerEquationTerm.createCartesianMatrix(dV0x, dV0y, dV1x, dV1y, dV2x, dV2y, true);
        DenseMatrix m0T2 = Fortescue.createMatrix().times(mdV);
        DenseMatrix m1T2 = mInvVabc.times(m0T2);
        DenseMatrix m2T2 = mInvVabc.times(m1T2);
        DenseMatrix m3T2 = mMinusSabc3Square.times(m2T2);
        DenseMatrix mdIFortescueConjugate = Fortescue.createMatrix().times(m3T2);
        DenseMatrix mT2 = mSquareVFortescue.times(mdIFortescueConjugate);
        switch (sequenceType) {
            case ZERO: {
                return complexPart == ComplexPart.REAL ? mdIFortescueConjugate.get(0, 0) : -mdIFortescueConjugate.get(1, 0);
            }
            case POSITIVE: {
                return complexPart == ComplexPart.REAL ? mT1.get(2, 0) + mT2.get(2, 0) : mT1.get(3, 0) + mT2.get(3, 0);
            }
            case NEGATIVE: {
                return complexPart == ComplexPart.REAL ? mdIFortescueConjugate.get(4, 0) : -mdIFortescueConjugate.get(5, 0);
            }
        }
        throw new IllegalStateException("Unknown sequence at bus : " + bus.getId());
    }

    @Override
    public double eval() {
        return LoadFortescuePowerEquationTerm.pq((LfBus)this.element, this.complexPart, this.sequenceType, this.v(Fortescue.SequenceType.ZERO), this.ph(Fortescue.SequenceType.ZERO), this.v(Fortescue.SequenceType.POSITIVE), this.ph(Fortescue.SequenceType.POSITIVE), this.v(Fortescue.SequenceType.NEGATIVE), this.ph(Fortescue.SequenceType.NEGATIVE));
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        return LoadFortescuePowerEquationTerm.dpq((LfBus)this.element, this.complexPart, this.sequenceType, variable, this.v(Fortescue.SequenceType.ZERO), this.ph(Fortescue.SequenceType.ZERO), this.v(Fortescue.SequenceType.POSITIVE), this.ph(Fortescue.SequenceType.POSITIVE), this.v(Fortescue.SequenceType.NEGATIVE), this.ph(Fortescue.SequenceType.NEGATIVE));
    }

    @Override
    public String getName() {
        return "ac_pq_fortescue_load";
    }

    @Override
    public List<Variable<AcVariableType>> getVariables() {
        return this.variables;
    }

    public static DenseMatrix createInvVabcSquare(LfBus bus, double vAx, double vAy, double vBx, double vBy, double vCx, double vCy) {
        double epsilon = 1.0E-8;
        double vAcongVa = vAx * vAx + vAy * vAy;
        String cantBuildLoad = " is null at bus : " + bus.getId() + " : cannot build load model";
        if (vAcongVa < epsilon) {
            throw new IllegalStateException("Va" + cantBuildLoad);
        }
        double vBcongVb = vBx * vBx + vBy * vBy;
        if (vBcongVb < epsilon) {
            throw new IllegalStateException("Vb" + cantBuildLoad);
        }
        double vCcongVc = vCx * vCx + vCy * vCy;
        if (vCcongVc < epsilon) {
            throw new IllegalStateException("Vc" + cantBuildLoad);
        }
        double invVax = vAx / vAcongVa;
        double invVay = -vAy / vAcongVa;
        double invVbx = vBx / vBcongVb;
        double invVby = -vBy / vBcongVb;
        double invVcx = vCx / vCcongVc;
        double invVcy = -vCy / vCcongVc;
        return LoadFortescuePowerEquationTerm.createCartesianMatrix(invVax, invVay, invVbx, invVby, invVcx, invVcy, false);
    }

    public static DenseMatrix createCartesianMatrix(double m1x, double m1y, double m2x, double m2y, double m3x, double m3y, boolean isVector) {
        DenseMatrix mCartesian;
        if (isVector) {
            mCartesian = new DenseMatrix(6, 1);
            mCartesian.add(0, 0, m1x);
            mCartesian.add(1, 0, m1y);
            mCartesian.add(2, 0, m2x);
            mCartesian.add(3, 0, m2y);
            mCartesian.add(4, 0, m3x);
            mCartesian.add(5, 0, m3y);
        } else {
            mCartesian = new DenseMatrix(6, 6);
            mCartesian.add(0, 0, m1x);
            mCartesian.add(1, 1, m1x);
            mCartesian.add(0, 1, -m1y);
            mCartesian.add(1, 0, m1y);
            mCartesian.add(2, 2, m2x);
            mCartesian.add(3, 3, m2x);
            mCartesian.add(2, 3, -m2y);
            mCartesian.add(3, 2, m2y);
            mCartesian.add(4, 4, m3x);
            mCartesian.add(5, 5, m3x);
            mCartesian.add(4, 5, -m3y);
            mCartesian.add(5, 4, m3y);
        }
        return mCartesian;
    }
}

