/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.asym.AbstractShuntFortescueCurrentEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ShuntFortescueIyEquationTerm
extends AbstractShuntFortescueCurrentEquationTerm {
    public ShuntFortescueIyEquationTerm(LfBus bus, VariableSet<AcVariableType> variableSet, Fortescue.SequenceType sequenceType) {
        super(bus, variableSet, sequenceType);
    }

    private static double iy(double v, double phi, double g, double b) {
        return g * v * FastMath.sin((double)phi) + b * v * FastMath.cos((double)phi);
    }

    private static double diydv(double phi, double g, double b) {
        return g * FastMath.sin((double)phi) + b * FastMath.cos((double)phi);
    }

    private static double diydph(double v, double phi, double g, double b) {
        return g * v * FastMath.cos((double)phi) - b * v * FastMath.sin((double)phi);
    }

    @Override
    public double eval() {
        return ShuntFortescueIyEquationTerm.iy(this.v(), this.ph(), this.g(), this.b());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.vVar)) {
            return ShuntFortescueIyEquationTerm.diydv(this.ph(), this.g(), this.b());
        }
        if (variable.equals(this.phVar)) {
            return ShuntFortescueIyEquationTerm.diydph(this.v(), this.ph(), this.g(), this.b());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    public String getName() {
        return "ac_iy_fortescue_shunt";
    }
}

