/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.DistributedSlackContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.util.Reports;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedSlackOuterLoop
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedSlackOuterLoop.class);
    public static final String NAME = "DistributedSlack";
    private final double slackBusPMaxMismatch;
    private final ActivePowerDistribution activePowerDistribution;

    public DistributedSlackOuterLoop(ActivePowerDistribution activePowerDistribution, double slackBusPMaxMismatch) {
        this.activePowerDistribution = Objects.requireNonNull(activePowerDistribution);
        this.slackBusPMaxMismatch = slackBusPMaxMismatch;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        DistributedSlackContextData contextData = new DistributedSlackContextData();
        context.setData(contextData);
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        boolean shouldDistributeSlack;
        double slackBusActivePowerMismatch = context.getLastSolverResult().getSlackBusActivePowerMismatch();
        double absMismatch = Math.abs(slackBusActivePowerMismatch);
        boolean bl = shouldDistributeSlack = absMismatch > this.slackBusPMaxMismatch / 100.0 && absMismatch > ActivePowerDistribution.P_RESIDUE_EPS;
        if (!shouldDistributeSlack) {
            LOGGER.debug("Already balanced");
            return new OuterLoopResult(this, OuterLoopStatus.STABLE);
        }
        ReportNode iterationReportNode = Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1);
        ActivePowerDistribution.Result result = this.activePowerDistribution.run(context.getNetwork(), slackBusActivePowerMismatch);
        double remainingMismatch = result.remainingMismatch();
        double distributedActivePower = slackBusActivePowerMismatch - remainingMismatch;
        DistributedSlackContextData contextData = (DistributedSlackContextData)context.getData();
        contextData.addDistributedActivePower(distributedActivePower);
        if (Math.abs(remainingMismatch) > ActivePowerDistribution.P_RESIDUE_EPS) {
            OpenLoadFlowParameters.SlackDistributionFailureBehavior slackDistributionFailureBehavior = ((AcLoadFlowParameters)((AcLoadFlowContext)context.getLoadFlowContext()).getParameters()).getSlackDistributionFailureBehavior();
            LfGenerator referenceGenerator = context.getNetwork().getReferenceGenerator();
            if (OpenLoadFlowParameters.SlackDistributionFailureBehavior.DISTRIBUTE_ON_REFERENCE_GENERATOR == slackDistributionFailureBehavior) {
                if (referenceGenerator == null) {
                    slackDistributionFailureBehavior = OpenLoadFlowParameters.SlackDistributionFailureBehavior.FAIL;
                    Reports.reportMismatchDistributionFailure(iterationReportNode, remainingMismatch * 100.0);
                }
            } else {
                Reports.reportMismatchDistributionFailure(iterationReportNode, remainingMismatch * 100.0);
            }
            switch (slackDistributionFailureBehavior) {
                case THROW: {
                    throw new PowsyblException("Failed to distribute slack bus active power mismatch, " + remainingMismatch * 100.0 + " MW remains");
                }
                case LEAVE_ON_SLACK_BUS: {
                    LOGGER.warn("Failed to distribute slack bus active power mismatch, {} MW remains", (Object)(remainingMismatch * 100.0));
                    return new OuterLoopResult(this, result.movedBuses() ? OuterLoopStatus.UNSTABLE : OuterLoopStatus.STABLE);
                }
                case DISTRIBUTE_ON_REFERENCE_GENERATOR: {
                    Objects.requireNonNull(referenceGenerator, () -> "No reference generator in " + context.getNetwork());
                    LOGGER.debug("{} MW distributed to reference generator '{}'", (Object)(remainingMismatch * 100.0), (Object)referenceGenerator.getId());
                    contextData.addDistributedActivePower(remainingMismatch);
                    referenceGenerator.setTargetP(referenceGenerator.getTargetP() + remainingMismatch);
                    result = new ActivePowerDistribution.Result(result.iteration() + 1, 0.0, true);
                    DistributedSlackOuterLoop.reportAndLogSuccess(iterationReportNode, slackBusActivePowerMismatch, result);
                    return new OuterLoopResult(this, OuterLoopStatus.UNSTABLE);
                }
                case FAIL: {
                    String statusText = String.format(Locale.US, "Failed to distribute slack bus active power mismatch, %.2f MW remains", remainingMismatch * 100.0);
                    LOGGER.error("{}", (Object)statusText);
                    contextData.addDistributedActivePower(-distributedActivePower);
                    return new OuterLoopResult(this, OuterLoopStatus.FAILED, statusText);
                }
            }
            throw new IllegalArgumentException("Unknown slackDistributionFailureBehavior");
        }
        DistributedSlackOuterLoop.reportAndLogSuccess(iterationReportNode, slackBusActivePowerMismatch, result);
        return new OuterLoopResult(this, OuterLoopStatus.UNSTABLE);
    }

    private static void reportAndLogSuccess(ReportNode reportNode, double slackBusActivePowerMismatch, ActivePowerDistribution.Result result) {
        Reports.reportMismatchDistributionSuccess(reportNode, slackBusActivePowerMismatch * 100.0, result.iteration());
        LOGGER.info("Slack bus active power ({} MW) distributed in {} distribution iteration(s)", (Object)(slackBusActivePowerMismatch * 100.0), (Object)result.iteration());
    }
}

