/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AbstractTransformerReactivePowerControlOuterLoop;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.outerloop.IncrementalContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerReactivePowerControl;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.Reports;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalTransformerReactivePowerControlOuterLoop
extends AbstractTransformerReactivePowerControlOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalTransformerReactivePowerControlOuterLoop.class);
    public static final String NAME = "IncrementalTransformerReactivePowerControl";
    private static final int MAX_DIRECTION_CHANGE = 3;
    private final int maxTapShift;

    public IncrementalTransformerReactivePowerControlOuterLoop(int maxTapShift) {
        this.maxTapShift = maxTapShift;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static boolean isOutOfDeadband(TransformerReactivePowerControl reactivePowerControl) {
        boolean outOfDeadband;
        double diffQ = IncrementalTransformerReactivePowerControlOuterLoop.getDiffQ(reactivePowerControl);
        double halfTargetDeadband = IncrementalTransformerReactivePowerControlOuterLoop.getHalfTargetDeadband(reactivePowerControl);
        boolean bl = outOfDeadband = Math.abs(diffQ) > halfTargetDeadband;
        if (outOfDeadband) {
            LfBranch controllerBranch = reactivePowerControl.getControllerBranch();
            LfBranch controlledBranch = reactivePowerControl.getControlledBranch();
            LOGGER.trace("Controlled branch '{}' ({} controller) is outside of its deadband (half is {} MVar) and could need a reactive power adjustment of {} MVar", new Object[]{controlledBranch.getId(), controllerBranch.getId(), halfTargetDeadband * 100.0, diffQ * 100.0});
        }
        return outOfDeadband;
    }

    public static List<LfBranch> getControllerBranches(LfNetwork network) {
        return network.getBranches().stream().filter(branch -> !branch.isDisabled() && branch.isTransformerReactivePowerController()).toList();
    }

    public static List<LfBranch> getControlledBranchesOutOfDeadband(LfNetwork network) {
        return network.getBranches().stream().filter(LfBranch::isTransformerReactivePowerControlled).filter(branch -> IncrementalTransformerReactivePowerControlOuterLoop.isOutOfDeadband(branch.getTransformerReactivePowerControl().orElseThrow())).filter(Predicate.not(LfElement::isDisabled)).toList();
    }

    public static List<LfBranch> getControllerBranchesOutOfDeadband(List<LfBranch> controlledBranchesOutOfDeadband) {
        return controlledBranchesOutOfDeadband.stream().map(controlledBranch -> controlledBranch.getTransformerReactivePowerControl().orElseThrow().getControllerBranch()).filter(Predicate.not(LfElement::isDisabled)).toList();
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        IncrementalContextData contextData = new IncrementalContextData();
        context.setData(contextData);
        for (LfBranch branch : IncrementalTransformerReactivePowerControlOuterLoop.getControllerBranches(context.getNetwork())) {
            contextData.getControllersContexts().put(branch.getId(), new IncrementalContextData.ControllerContext(3));
        }
    }

    private boolean adjustWithController(LfBranch controllerBranch, LfBranch controlledBranch, TwoSides controlledSide, IncrementalContextData contextData, double diffQ, SensitivityContext sensitivities, List<String> controlledBranchesWithAllItsControllersToLimit) {
        IncrementalContextData.ControllerContext controllerContext = contextData.getControllersContexts().get(controllerBranch.getId());
        double sensitivity = sensitivities.calculateSensitivityFromRToQ(controllerBranch, controlledBranch, controlledSide);
        PiModel piModel = controllerBranch.getPiModel();
        int previousTapPosition = piModel.getTapPosition();
        double deltaR1 = diffQ / sensitivity;
        return piModel.updateTapPositionToReachNewR1(deltaR1, this.maxTapShift, controllerContext.getAllowedDirection()).map(direction -> {
            controllerContext.updateAllowedDirection((Direction)((Object)direction));
            Range<Integer> tapPositionRange = piModel.getTapPositionRange();
            LOGGER.debug("Controller branch '{}' change tap from {} to {} (full range: {})", new Object[]{controllerBranch.getId(), previousTapPosition, piModel.getTapPosition(), tapPositionRange});
            if (piModel.getTapPosition() == ((Integer)tapPositionRange.getMinimum()).intValue() || piModel.getTapPosition() == ((Integer)tapPositionRange.getMaximum()).intValue()) {
                controlledBranchesWithAllItsControllersToLimit.add(controlledBranch.getId());
            }
            return direction;
        }).isPresent();
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        ReportNode iterationReportNode;
        MutableObject status = new MutableObject((Object)OuterLoopStatus.STABLE);
        LfNetwork network = context.getNetwork();
        AcLoadFlowContext loadFlowContext = (AcLoadFlowContext)context.getLoadFlowContext();
        IncrementalContextData contextData = (IncrementalContextData)context.getData();
        List<LfBranch> controlledBranchesOutOfDeadband = IncrementalTransformerReactivePowerControlOuterLoop.getControlledBranchesOutOfDeadband(network);
        List<LfBranch> controllerBranchesOutOfDeadband = IncrementalTransformerReactivePowerControlOuterLoop.getControllerBranchesOutOfDeadband(controlledBranchesOutOfDeadband);
        if (controllerBranchesOutOfDeadband.isEmpty()) {
            return new OuterLoopResult(this, (OuterLoopStatus)((Object)status.getValue()));
        }
        SensitivityContext sensitivityContext = new SensitivityContext(network, controllerBranchesOutOfDeadband, loadFlowContext.getEquationSystem(), loadFlowContext.getJacobianMatrix());
        ArrayList controlledBranchesAdjusted = new ArrayList();
        ArrayList controlledBranchesWithAllItsControllersToLimit = new ArrayList();
        controlledBranchesOutOfDeadband.forEach(controlledBranch -> {
            TwoSides controlledSide;
            TransformerReactivePowerControl reactivePowerControl = controlledBranch.getTransformerReactivePowerControl().orElseThrow();
            double diffQ = IncrementalTransformerReactivePowerControlOuterLoop.getDiffQ(reactivePowerControl);
            LfBranch controller = reactivePowerControl.getControllerBranch();
            boolean adjusted = this.adjustWithController(controller, (LfBranch)controlledBranch, controlledSide = reactivePowerControl.getControlledSide(), contextData, diffQ, sensitivityContext, controlledBranchesWithAllItsControllersToLimit);
            if (adjusted) {
                controlledBranchesAdjusted.add(controlledBranch.getId());
                status.setValue((Object)OuterLoopStatus.UNSTABLE);
            }
        });
        Object object = iterationReportNode = !controlledBranchesOutOfDeadband.isEmpty() || !controlledBranchesAdjusted.isEmpty() || !controlledBranchesWithAllItsControllersToLimit.isEmpty() ? Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1) : null;
        if (!controlledBranchesOutOfDeadband.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                Map largestMismatches = controllerBranchesOutOfDeadband.stream().map(controlledBranch -> Pair.of((Object)controlledBranch.getId(), (Object)Math.abs(IncrementalTransformerReactivePowerControlOuterLoop.getDiffQ(controlledBranch.getTransformerReactivePowerControl().get())))).sorted((p1, p2) -> Double.compare((Double)p2.getRight() * 100.0, (Double)p1.getRight() * 100.0)).limit(3L).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (key1, key2) -> key1, LinkedHashMap::new));
                LOGGER.info("{} controlled branch reactive power are outside of their target deadband, largest ones are: {}", (Object)controllerBranchesOutOfDeadband.size(), (Object)largestMismatches);
            }
            Reports.reportTransformerControlBranchesOutsideDeadband(Objects.requireNonNull(iterationReportNode), controlledBranchesOutOfDeadband.size());
        }
        if (!controlledBranchesAdjusted.isEmpty()) {
            LOGGER.info("{} controlled branch reactive power have been adjusted by changing at least one tap", (Object)controlledBranchesAdjusted.size());
            Reports.reportTransformerControlChangedTaps(Objects.requireNonNull(iterationReportNode), controlledBranchesAdjusted.size());
        }
        if (!controlledBranchesWithAllItsControllersToLimit.isEmpty()) {
            LOGGER.info("{} controlled branches have all its controllers to a tap limit: {}", (Object)controlledBranchesWithAllItsControllersToLimit.size(), controlledBranchesWithAllItsControllersToLimit);
            Reports.reportTransformerControlTapLimit(Objects.requireNonNull(iterationReportNode), controlledBranchesWithAllItsControllersToLimit.size());
        }
        return new OuterLoopResult(this, (OuterLoopStatus)((Object)status.getValue()));
    }

    private static double getDiffQ(TransformerReactivePowerControl reactivePowerControl) {
        double targetQ = IncrementalTransformerReactivePowerControlOuterLoop.getHighestPriorityReactivePowerTarget(reactivePowerControl.getControlledBranch());
        double q = reactivePowerControl.getControlledSide() == TwoSides.ONE ? reactivePowerControl.getControlledBranch().getQ1().eval() : reactivePowerControl.getControlledBranch().getQ2().eval();
        return targetQ - q;
    }

    private static double getHighestPriorityReactivePowerTarget(LfBranch controlledBranch) {
        return controlledBranch.getGeneratorReactivePowerControl().map(Control::getTargetValue).orElseGet(() -> controlledBranch.getTransformerReactivePowerControl().orElseThrow().getTargetValue());
    }

    static class SensitivityContext {
        private final DenseMatrix sensitivities;
        private final int[] controllerBranchIndex;

        public SensitivityContext(LfNetwork network, List<LfBranch> controllerBranches, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j) {
            this.controllerBranchIndex = LfBranch.createIndex(network, controllerBranches);
            this.sensitivities = SensitivityContext.calculateSensitivityValues(controllerBranches, this.controllerBranchIndex, equationSystem, j);
        }

        private static DenseMatrix calculateSensitivityValues(List<LfBranch> controllerBranches, int[] controllerBranchIndex, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j) {
            DenseMatrix rhs = new DenseMatrix(equationSystem.getIndex().getSortedEquationsToSolve().size(), controllerBranches.size());
            for (LfBranch controllerBranch : controllerBranches) {
                equationSystem.getEquation(controllerBranch.getNum(), AcEquationType.BRANCH_TARGET_RHO1).ifPresent(equation -> rhs.set(equation.getColumn(), controllerBranchIndex[controllerBranch.getNum()], 1.0));
            }
            j.solveTransposed(rhs);
            return rhs;
        }

        private static EquationTerm<AcVariableType, AcEquationType> getCalculatedQ(LfBranch controlledBranch, TwoSides controlledSide) {
            Evaluable calculatedQ = controlledSide == TwoSides.ONE ? controlledBranch.getQ1() : controlledBranch.getQ2();
            return (EquationTerm)calculatedQ;
        }

        double calculateSensitivityFromRToQ(LfBranch controllerBranch, LfBranch controlledBranch, TwoSides controlledSide) {
            return SensitivityContext.getCalculatedQ(controlledBranch, controlledSide).calculateSensi(this.sensitivities, this.controllerBranchIndex[controllerBranch.getNum()]);
        }
    }
}

