/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.Reports;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveLimitsOuterLoop
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveLimitsOuterLoop.class);
    public static final String NAME = "ReactiveLimits";
    private static final Comparator<ControllerBusToPqBus> BY_NOMINAL_V_COMPARATOR = Comparator.comparingDouble(controllerBusToPqBus -> controllerBusToPqBus.controllerBus.getGeneratorVoltageControl().map(vc -> -vc.getControlledBus().getNominalV()).orElse(-controllerBusToPqBus.controllerBus.getNominalV()));
    private static final Comparator<ControllerBusToPqBus> BY_TARGET_P_COMPARATOR = Comparator.comparingDouble(controllerBusToPqBus -> -controllerBusToPqBus.controllerBus.getTargetP());
    private static final Comparator<ControllerBusToPqBus> BY_ID_COMPARATOR = Comparator.comparing(controllerBusToPqBus -> controllerBusToPqBus.controllerBus.getId());
    public static final int MAX_SWITCH_PQ_PV_DEFAULT_VALUE = 3;
    private final int maxPqPvSwitch;
    private final double maxReactivePowerMismatch;

    public ReactiveLimitsOuterLoop(int maxPqPvSwitch, double maxReactivePowerMismatch) {
        this.maxPqPvSwitch = maxPqPvSwitch;
        this.maxReactivePowerMismatch = maxReactivePowerMismatch;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private boolean switchPvPq(List<ControllerBusToPqBus> pvToPqBuses, int remainingPvBusCount, ContextData contextData, ReportNode reportNode) {
        boolean done = false;
        int modifiedRemainingPvBusCount = remainingPvBusCount;
        if (modifiedRemainingPvBusCount == 0) {
            ControllerBusToPqBus strongestPvToPqBus = pvToPqBuses.stream().min(BY_NOMINAL_V_COMPARATOR.thenComparing(BY_TARGET_P_COMPARATOR).thenComparing(BY_ID_COMPARATOR)).orElseThrow(IllegalStateException::new);
            pvToPqBuses.remove(strongestPvToPqBus);
            ++modifiedRemainingPvBusCount;
            LOGGER.warn("All PV buses should switch PQ, strongest one '{}' will stay PV", (Object)strongestPvToPqBus.controllerBus.getId());
            Reports.reportBusForcedToBePv(reportNode, strongestPvToPqBus.controllerBus.getId());
        }
        if (!pvToPqBuses.isEmpty()) {
            done = true;
            for (ControllerBusToPqBus pvToPqBus : pvToPqBuses) {
                LfBus controllerBus = pvToPqBus.controllerBus;
                controllerBus.setGenerationTargetQ(pvToPqBus.qLimit);
                controllerBus.setQLimitType(pvToPqBus.limitDirection.equals((Object)ReactiveLimitDirection.MIN) ? LfBus.QLimitType.MIN_Q : LfBus.QLimitType.MAX_Q);
                controllerBus.setGeneratorVoltageControlEnabled(false);
                contextData.incrementPvPqSwitchCount(controllerBus.getId());
                if (!LOGGER.isTraceEnabled()) continue;
                if (pvToPqBus.limitDirection == ReactiveLimitDirection.MAX) {
                    LOGGER.trace("Switch bus '{}' PV -> PQ, q={} > maxQ={}", new Object[]{controllerBus.getId(), pvToPqBus.q * 100.0, pvToPqBus.qLimit * 100.0});
                    continue;
                }
                LOGGER.trace("Switch bus '{}' PV -> PQ, q={} < minQ={}", new Object[]{controllerBus.getId(), pvToPqBus.q * 100.0, pvToPqBus.qLimit * 100.0});
            }
        }
        Reports.reportPvToPqBuses(reportNode, pvToPqBuses.size(), modifiedRemainingPvBusCount);
        LOGGER.info("{} buses switched PV -> PQ ({} bus remains PV)", (Object)pvToPqBuses.size(), (Object)modifiedRemainingPvBusCount);
        return done;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        context.setData(new ContextData());
    }

    private static boolean switchPqPv(List<PqToPvBus> pqToPvBuses, ContextData contextData, ReportNode reportNode, int maxPqPvSwitch) {
        int pqPvSwitchCount = 0;
        for (PqToPvBus pqToPvBus : pqToPvBuses) {
            LfBus controllerBus = pqToPvBus.controllerBus;
            int pvPqSwitchCount = contextData.getPvPqSwitchCount(controllerBus.getId());
            if (pvPqSwitchCount >= maxPqPvSwitch) {
                LOGGER.trace("Bus '{}' blocked PQ as it has reach its max number of PQ -> PV switch ({})", (Object)controllerBus.getId(), (Object)pvPqSwitchCount);
                continue;
            }
            controllerBus.setGeneratorVoltageControlEnabled(true);
            controllerBus.setGenerationTargetQ(0.0);
            controllerBus.setQLimitType(null);
            ++pqPvSwitchCount;
            if (!LOGGER.isTraceEnabled()) continue;
            if (pqToPvBus.limitDirection == ReactiveLimitDirection.MAX) {
                LOGGER.trace("Switch bus '{}' PQ -> PV, q=maxQ and v={} > targetV={}", new Object[]{controllerBus.getId(), controllerBus.getV(), ReactiveLimitsOuterLoop.getBusTargetV(controllerBus)});
                continue;
            }
            LOGGER.trace("Switch bus '{}' PQ -> PV, q=minQ and v={} < targetV={}", new Object[]{controllerBus.getId(), controllerBus.getV(), ReactiveLimitsOuterLoop.getBusTargetV(controllerBus)});
        }
        Reports.reportPqToPvBuses(reportNode, pqPvSwitchCount, pqToPvBuses.size() - pqPvSwitchCount);
        LOGGER.info("{} buses switched PQ -> PV ({} buses blocked PQ because have reach max number of switch)", (Object)pqPvSwitchCount, (Object)(pqToPvBuses.size() - pqPvSwitchCount));
        return pqPvSwitchCount > 0;
    }

    private static void checkControllerBus(LfBus controllerBus, List<ControllerBusToPqBus> buses, MutableInt remainingUnchangedBusCount) {
        double minQ = controllerBus.getMinQ();
        double maxQ = controllerBus.getMaxQ();
        double q = controllerBus.getQ().eval() + controllerBus.getLoadTargetQ();
        if (q < minQ) {
            buses.add(new ControllerBusToPqBus(controllerBus, q, minQ, ReactiveLimitDirection.MIN));
        } else if (q > maxQ) {
            buses.add(new ControllerBusToPqBus(controllerBus, q, maxQ, ReactiveLimitDirection.MAX));
        } else {
            remainingUnchangedBusCount.increment();
        }
    }

    private static void checkPqBus(LfBus controllerCapableBus, List<PqToPvBus> pqToPvBuses, List<LfBus> busesWithUpdatedQLimits, double maxReactivePowerMismatch, boolean canSwitchPqToPv) {
        double minQ = controllerCapableBus.getMinQ();
        double maxQ = controllerCapableBus.getMaxQ();
        double q = controllerCapableBus.getGenerationTargetQ();
        controllerCapableBus.getQLimitType().ifPresent(qLimitType -> {
            if (qLimitType == LfBus.QLimitType.MIN_Q) {
                if (ReactiveLimitsOuterLoop.getBusV(controllerCapableBus) < ReactiveLimitsOuterLoop.getBusTargetV(controllerCapableBus) && canSwitchPqToPv) {
                    pqToPvBuses.add(new PqToPvBus(controllerCapableBus, ReactiveLimitDirection.MIN));
                } else if (Math.abs(minQ - q) > maxReactivePowerMismatch) {
                    LOGGER.trace("PQ bus {} with updated Q limits, previous minQ {} new minQ {}", new Object[]{controllerCapableBus.getId(), q, minQ});
                    controllerCapableBus.setGenerationTargetQ(minQ);
                    busesWithUpdatedQLimits.add(controllerCapableBus);
                }
            } else if (qLimitType == LfBus.QLimitType.MAX_Q) {
                if (ReactiveLimitsOuterLoop.getBusV(controllerCapableBus) > ReactiveLimitsOuterLoop.getBusTargetV(controllerCapableBus) && canSwitchPqToPv) {
                    pqToPvBuses.add(new PqToPvBus(controllerCapableBus, ReactiveLimitDirection.MAX));
                } else if (Math.abs(maxQ - q) > maxReactivePowerMismatch) {
                    LOGGER.trace("PQ bus {} with updated Q limits, previous maxQ {} new maxQ {}", new Object[]{controllerCapableBus.getId(), q, maxQ});
                    controllerCapableBus.setGenerationTargetQ(maxQ);
                    busesWithUpdatedQLimits.add(controllerCapableBus);
                }
            }
        });
    }

    private static boolean switchReactiveControllerBusPq(List<ControllerBusToPqBus> reactiveControllerBusesToPqBuses, ReportNode reportNode) {
        int switchCount = 0;
        for (ControllerBusToPqBus bus : reactiveControllerBusesToPqBuses) {
            LfBus controllerBus = bus.controllerBus;
            controllerBus.setGeneratorReactivePowerControlEnabled(false);
            controllerBus.setGenerationTargetQ(bus.qLimit);
            ++switchCount;
            if (!LOGGER.isTraceEnabled()) continue;
            if (bus.limitDirection == ReactiveLimitDirection.MAX) {
                LOGGER.trace("Remote reactive power controller bus '{}' -> PQ, q={} > maxQ={}", new Object[]{controllerBus.getId(), bus.q * 100.0, bus.qLimit * 100.0});
                continue;
            }
            LOGGER.trace("Remote reactive power controller bus '{}' -> PQ, q={} < minQ={}", new Object[]{controllerBus.getId(), bus.q * 100.0, bus.qLimit * 100.0});
        }
        Reports.reportReactiveControllerBusesToPqBuses(reportNode, switchCount);
        LOGGER.info("{} remote reactive power controller buses switched PQ", (Object)switchCount);
        return switchCount > 0;
    }

    private static double getBusTargetV(LfBus bus) {
        return bus.getGeneratorVoltageControl().map(Control::getTargetValue).orElse(Double.NaN);
    }

    private static double getBusV(LfBus bus) {
        return bus.getGeneratorVoltageControl().map(vc -> vc.getControlledBus().getV()).orElse(Double.NaN);
    }

    public static List<LfBus> getReactivePowerControllerElements(LfNetwork network) {
        return network.getBuses().stream().filter(LfBus::hasGeneratorReactivePowerControl).flatMap(bus -> bus.getGeneratorReactivePowerControl().orElseThrow().getControllerBuses().stream()).filter(Predicate.not(LfElement::isDisabled)).toList();
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        ArrayList<ControllerBusToPqBus> pvToPqBuses = new ArrayList<ControllerBusToPqBus>();
        ArrayList<PqToPvBus> pqToPvBuses = new ArrayList<PqToPvBus>();
        ArrayList busesWithUpdatedQLimits = new ArrayList();
        MutableInt remainingPvBusCount = new MutableInt();
        ArrayList<ControllerBusToPqBus> reactiveControllerBusesToPqBuses = new ArrayList<ControllerBusToPqBus>();
        MutableInt remainingBusWithReactivePowerControlCount = new MutableInt();
        context.getNetwork().getControllerElements(VoltageControl.Type.GENERATOR).forEach(bus -> {
            if (bus.isGeneratorVoltageControlEnabled()) {
                ReactiveLimitsOuterLoop.checkControllerBus(bus, pvToPqBuses, remainingPvBusCount);
            } else {
                ReactiveLimitsOuterLoop.checkPqBus(bus, pqToPvBuses, busesWithUpdatedQLimits, this.maxReactivePowerMismatch, !bus.hasGeneratorsWithSlope());
            }
        });
        ReactiveLimitsOuterLoop.getReactivePowerControllerElements(context.getNetwork()).forEach(bus -> {
            if (bus.isGeneratorReactivePowerControlEnabled()) {
                ReactiveLimitsOuterLoop.checkControllerBus(bus, reactiveControllerBusesToPqBuses, remainingBusWithReactivePowerControlCount);
            }
        });
        ContextData contextData = (ContextData)context.getData();
        ReportNode iterationReportNode = reportNode;
        if (!(pvToPqBuses.isEmpty() && pqToPvBuses.isEmpty() && busesWithUpdatedQLimits.isEmpty() && reactiveControllerBusesToPqBuses.isEmpty())) {
            iterationReportNode = Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1);
        }
        if (!pvToPqBuses.isEmpty() && this.switchPvPq(pvToPqBuses, remainingPvBusCount.intValue(), contextData, iterationReportNode)) {
            status = OuterLoopStatus.UNSTABLE;
        }
        if (!pqToPvBuses.isEmpty() && ReactiveLimitsOuterLoop.switchPqPv(pqToPvBuses, contextData, iterationReportNode, this.maxPqPvSwitch)) {
            status = OuterLoopStatus.UNSTABLE;
        }
        if (!busesWithUpdatedQLimits.isEmpty()) {
            LOGGER.info("{} buses blocked at a reactive limit have been adjusted because the reactive limit changed", (Object)busesWithUpdatedQLimits.size());
            Reports.reportBusesWithUpdatedQLimits(iterationReportNode, busesWithUpdatedQLimits.size());
            status = OuterLoopStatus.UNSTABLE;
        }
        if (!reactiveControllerBusesToPqBuses.isEmpty() && ReactiveLimitsOuterLoop.switchReactiveControllerBusPq(reactiveControllerBusesToPqBuses, iterationReportNode)) {
            status = OuterLoopStatus.UNSTABLE;
        }
        return new OuterLoopResult(this, status);
    }

    private static final class ControllerBusToPqBus {
        private final LfBus controllerBus;
        private final double q;
        private final double qLimit;
        private final ReactiveLimitDirection limitDirection;

        private ControllerBusToPqBus(LfBus controllerBus, double q, double qLimit, ReactiveLimitDirection limitDirection) {
            this.controllerBus = controllerBus;
            this.q = q;
            this.qLimit = qLimit;
            this.limitDirection = limitDirection;
        }
    }

    private static enum ReactiveLimitDirection {
        MIN,
        MAX;

    }

    private static final class ContextData {
        private final Map<String, MutableInt> pvPqSwitchCount = new HashMap<String, MutableInt>();

        private ContextData() {
        }

        void incrementPvPqSwitchCount(String busId) {
            this.pvPqSwitchCount.computeIfAbsent(busId, k -> new MutableInt(0)).increment();
        }

        int getPvPqSwitchCount(String busId) {
            MutableInt counter = this.pvPqSwitchCount.get(busId);
            if (counter == null) {
                return 0;
            }
            return counter.getValue();
        }
    }

    private static final class PqToPvBus {
        private final LfBus controllerBus;
        private final ReactiveLimitDirection limitDirection;

        private PqToPvBus(LfBus controllerBus, ReactiveLimitDirection limitDirection) {
            this.controllerBus = controllerBus;
            this.limitDirection = limitDirection;
        }
    }
}

