/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfSecondaryVoltageControl;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.VoltageControl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryVoltageControlOuterLoop
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecondaryVoltageControlOuterLoop.class);
    public static final String NAME = "SecondaryVoltageControl";
    private static final double DV_EPS = 1.0E-4;
    private static final double DK_DIFF_MAX_EPS = 0.001;
    private final double minPlausibleTargetVoltage;
    private final double maxPlausibleTargetVoltage;

    @Override
    public String getName() {
        return NAME;
    }

    public SecondaryVoltageControlOuterLoop(double minPlausibleTargetVoltage, double maxPlausibleTargetVoltage) {
        this.minPlausibleTargetVoltage = minPlausibleTargetVoltage;
        this.maxPlausibleTargetVoltage = maxPlausibleTargetVoltage;
    }

    private static Map<Integer, Integer> buildBusIndex(List<LfBus> buses) {
        LinkedHashMap<Integer, Integer> busIndex = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < buses.size(); ++i) {
            LfBus bus = buses.get(i);
            busIndex.put(bus.getNum(), i);
        }
        return busIndex;
    }

    private static double qToK(double q, LfBus controllerBus) {
        return (2.0 * q - controllerBus.getMaxQ() - controllerBus.getMinQ()) / (controllerBus.getMaxQ() - controllerBus.getMinQ());
    }

    private static double calculateK(LfBus controllerBus) {
        double q = controllerBus.getQ().eval() + controllerBus.getLoadTargetQ();
        return SecondaryVoltageControlOuterLoop.qToK(q, controllerBus);
    }

    private static DenseMatrix createA(List<LfSecondaryVoltageControl> secondaryVoltageControls, Map<Integer, Integer> controllerBusIndex) {
        int n = controllerBusIndex.size();
        DenseMatrix a = new DenseMatrix(n, n);
        for (LfSecondaryVoltageControl secondaryVoltageControl : secondaryVoltageControls) {
            List<LfBus> controllerBuses = secondaryVoltageControl.getControllerBuses();
            int nControl = controllerBuses.size();
            for (LfBus controllerBusI : controllerBuses) {
                for (LfBus controllerBusJ : controllerBuses) {
                    int j;
                    int i;
                    a.set(i, j, (i = controllerBusIndex.get(controllerBusI.getNum()).intValue()) == (j = controllerBusIndex.get(controllerBusJ.getNum()).intValue()) ? 1.0 - 1.0 / (double)nControl : -1.0 / (double)nControl);
                }
            }
        }
        return a;
    }

    private static DenseMatrix createK0(List<LfBus> controllerBuses, Map<Integer, Integer> controllerBusIndex) {
        int n = controllerBuses.size();
        DenseMatrix k0 = new DenseMatrix(n, 1);
        for (LfBus controllerBus : controllerBuses) {
            int i = controllerBusIndex.get(controllerBus.getNum());
            k0.set(i, 0, SecondaryVoltageControlOuterLoop.calculateK(controllerBus));
        }
        return k0;
    }

    private static DenseMatrix createJk(SensitivityContext sensitivityContext, List<LfBus> controllerBuses, Map<Integer, Integer> controllerBusIndex) {
        int n = controllerBuses.size();
        DenseMatrix jK = new DenseMatrix(n, n);
        for (LfBus controllerBusI : controllerBuses) {
            for (LfBus controllerBusJ : controllerBuses) {
                int i = controllerBusIndex.get(controllerBusI.getNum());
                int j = controllerBusIndex.get(controllerBusJ.getNum());
                LfBus controlledBus2 = controllerBusJ.getGeneratorVoltageControl().orElseThrow().getControlledBus();
                jK.set(i, j, sensitivityContext.calculateSensiK(controllerBusI, controlledBus2));
            }
        }
        return jK;
    }

    private static DenseMatrix createJvpp(SensitivityContext sensitivityContext, LfBus pilotBus, List<LfBus> controllerBuses, Map<Integer, Integer> controllerBusIndex) {
        int n = controllerBuses.size();
        DenseMatrix jVpp = new DenseMatrix(n, 1);
        for (LfBus controllerBus : controllerBuses) {
            int i = controllerBusIndex.get(controllerBus.getNum());
            LfBus controlledBus = controllerBus.getGeneratorVoltageControl().orElseThrow().getControlledBus();
            jVpp.set(i, 0, sensitivityContext.calculateSensiVpp(controlledBus, pilotBus));
        }
        return jVpp;
    }

    private static KStats calculateKStats(List<LfBus> controllerBuses) {
        double[] ks = controllerBuses.stream().mapToDouble(SecondaryVoltageControlOuterLoop::calculateK).toArray();
        double dkDiffMax = Arrays.stream(ks).max().orElseThrow() - Arrays.stream(ks).min().orElseThrow();
        double kAverage = Arrays.stream(ks).average().orElseThrow();
        boolean allAtLimits = Arrays.stream(ks).allMatch(k -> k > 1.0) || Arrays.stream(ks).allMatch(k -> k < -1.0);
        return new KStats(kAverage, dkDiffMax, allAtLimits);
    }

    private static double calculatePilotPointDv(LfSecondaryVoltageControl secondaryVoltageControl) {
        return secondaryVoltageControl.getTargetValue() - secondaryVoltageControl.getPilotBus().getV();
    }

    private Optional<List<String>> processSecondaryVoltageControl(List<LfSecondaryVoltageControl> secondaryVoltageControls, SensitivityContext sensitivityContext) {
        int i;
        ArrayList<String> adjustedZoneNames = new ArrayList<String>();
        for (LfSecondaryVoltageControl secondaryVoltageControl : secondaryVoltageControls) {
            double pilotDv = SecondaryVoltageControlOuterLoop.calculatePilotPointDv(secondaryVoltageControl);
            List<LfBus> controllerBuses = secondaryVoltageControl.getControllerBuses();
            KStats kStats = SecondaryVoltageControlOuterLoop.calculateKStats(controllerBuses);
            if (!(Math.abs(pilotDv) > 1.0E-4) && (kStats.allAtLimits() || !(Math.abs(kStats.dkDiffMax()) > 0.001))) continue;
            LfBus pilotBus = secondaryVoltageControl.getPilotBus();
            if (LOGGER.isDebugEnabled()) {
                int allControllerBusesCount = secondaryVoltageControl.getControllerBuses().size();
                LOGGER.debug("Secondary voltage control of zone '{}': {}/{} controller buses available, pilot point dv is {} kV, controller buses dk diff max is {} (k average is {})", new Object[]{secondaryVoltageControl.getZoneName(), controllerBuses.size(), allControllerBusesCount, pilotDv * pilotBus.getNominalV(), kStats.dkDiffMax(), kStats.kAverage()});
            }
            adjustedZoneNames.add(secondaryVoltageControl.getZoneName());
        }
        if (adjustedZoneNames.isEmpty()) {
            return Optional.of(Collections.emptyList());
        }
        List<LfBus> allControllerBuses = secondaryVoltageControls.stream().flatMap(control -> control.getEnabledControllerBuses().stream()).toList();
        Map<Integer, Integer> controllerBusIndex = SecondaryVoltageControlOuterLoop.buildBusIndex(allControllerBuses);
        DenseMatrix a = SecondaryVoltageControlOuterLoop.createA(secondaryVoltageControls, controllerBusIndex);
        DenseMatrix k0 = SecondaryVoltageControlOuterLoop.createK0(allControllerBuses, controllerBusIndex);
        DenseMatrix rhs = a.times(k0, -1.0);
        DenseMatrix jK = SecondaryVoltageControlOuterLoop.createJk(sensitivityContext, allControllerBuses, controllerBusIndex);
        DenseMatrix b = a.times(jK);
        for (LfSecondaryVoltageControl secondaryVoltageControl : secondaryVoltageControls) {
            List<LfBus> controllerBuses = secondaryVoltageControl.getControllerBuses();
            LfBus lastControllerBus = controllerBuses.get(controllerBuses.size() - 1);
            i = controllerBusIndex.get(lastControllerBus.getNum());
            DenseMatrix jVpp = SecondaryVoltageControlOuterLoop.createJvpp(sensitivityContext, secondaryVoltageControl.getPilotBus(), allControllerBuses, controllerBusIndex);
            for (int j = 0; j < b.getColumnCount(); ++j) {
                b.set(i, j, jVpp.get(j, 0));
            }
            double pilotDv = SecondaryVoltageControlOuterLoop.calculatePilotPointDv(secondaryVoltageControl);
            rhs.set(i, 0, pilotDv);
        }
        try (LUDecomposition luDecomposition = b.decomposeLU();){
            luDecomposition.solve(rhs);
        }
        DenseMatrix dv = rhs;
        HashMap<LfBus, Double> newControlledBusTargetV = new HashMap<LfBus, Double>(allControllerBuses.size());
        for (LfBus controllerBus : allControllerBuses) {
            i = controllerBusIndex.get(controllerBus.getNum());
            GeneratorVoltageControl vc = controllerBus.getGeneratorVoltageControl().orElseThrow();
            LfBus controlledBus = vc.getControlledBus();
            double newTargetV = vc.getTargetValue() + dv.get(i, 0);
            newControlledBusTargetV.put(controlledBus, newTargetV);
        }
        Map<LfBus, Double> notPlausibleNewControlledBusTargetV = newControlledBusTargetV.entrySet().stream().filter(e -> {
            double newTargetV = (Double)e.getValue();
            return !VoltageControl.isTargetVoltagePlausible(newTargetV, this.minPlausibleTargetVoltage, this.maxPlausibleTargetVoltage);
        }).map(e -> {
            LfBus controlledBus = (LfBus)e.getKey();
            double newTargetV = (Double)e.getValue();
            return Pair.of((Object)controlledBus, (Object)(newTargetV * controlledBus.getNominalV()));
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        if (notPlausibleNewControlledBusTargetV.isEmpty()) {
            for (Map.Entry e2 : newControlledBusTargetV.entrySet()) {
                LfBus controlledBus = (LfBus)e2.getKey();
                double newTargetV = (Double)e2.getValue();
                GeneratorVoltageControl vc = controlledBus.getGeneratorVoltageControl().orElseThrow();
                LOGGER.trace("Adjust target voltage of controlled bus '{}': {} -> {}", new Object[]{controlledBus.getId(), vc.getTargetValue() * controlledBus.getNominalV(), newTargetV * controlledBus.getNominalV()});
                vc.setTargetValue(newTargetV);
            }
        } else {
            LOGGER.error("Skipping all controlled bus target voltage adjustment because some of the calculated new target voltages are not plausible: {}", notPlausibleNewControlledBusTargetV);
            return Optional.empty();
        }
        return Optional.of(adjustedZoneNames);
    }

    private static void tryToReEnableHelpfulControllerBuses(LfNetwork network) {
        network.getEnabledSecondaryVoltageControls().forEach(LfSecondaryVoltageControl::tryToReEnableHelpfulControllerBuses);
    }

    private static void logZonesWithAllBusControllersAtReactivePowerLimit(LfNetwork network) {
        List<String> zoneNames = network.getEnabledSecondaryVoltageControls().stream().filter(control -> control.getEnabledControllerBuses().isEmpty()).map(LfSecondaryVoltageControl::getZoneName).toList();
        if (!zoneNames.isEmpty()) {
            LOGGER.info("Controller buses of secondary voltage control zones {} cannot produce or absorb more reactive power", zoneNames);
        }
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        LfNetwork network = context.getNetwork();
        SecondaryVoltageControlOuterLoop.tryToReEnableHelpfulControllerBuses(network);
        SecondaryVoltageControlOuterLoop.logZonesWithAllBusControllersAtReactivePowerLimit(network);
        List<LfSecondaryVoltageControl> secondaryVoltageControls = network.getEnabledSecondaryVoltageControls().stream().filter(control -> control.findAnyControlledBusWithAtLeastOneControllerBusWithVoltageControlEnabled().isPresent()).toList();
        if (secondaryVoltageControls.isEmpty()) {
            return new OuterLoopResult(this, OuterLoopStatus.STABLE);
        }
        List<LfBus> allControlledBuses = secondaryVoltageControls.stream().flatMap(control -> control.getControlledBuses().stream()).toList();
        SensitivityContext sensitivityContext = SensitivityContext.create(allControlledBuses, (AcLoadFlowContext)context.getLoadFlowContext());
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        List adjustedZoneNames = this.processSecondaryVoltageControl(secondaryVoltageControls, sensitivityContext).orElse(null);
        if (adjustedZoneNames == null) {
            status = OuterLoopStatus.FAILED;
        } else if (!adjustedZoneNames.isEmpty()) {
            status = OuterLoopStatus.UNSTABLE;
            LOGGER.info("{} secondary voltage control zones have been adjusted: {}", (Object)adjustedZoneNames.size(), (Object)adjustedZoneNames);
        }
        return new OuterLoopResult(this, status);
    }

    static class SensitivityContext {
        private final Map<Integer, Integer> busNumToSensiColumn;
        private final DenseMatrix sensitivities;

        SensitivityContext(Map<Integer, Integer> busNumToSensiColumn, DenseMatrix sensitivities) {
            this.busNumToSensiColumn = Objects.requireNonNull(busNumToSensiColumn);
            this.sensitivities = Objects.requireNonNull(sensitivities);
        }

        static SensitivityContext create(List<LfBus> controlledBuses, AcLoadFlowContext context) {
            Map<Integer, Integer> busNumToSensiColumn = SecondaryVoltageControlOuterLoop.buildBusIndex(controlledBuses);
            DenseMatrix sensitivities = SensitivityContext.calculateSensitivityValues(controlledBuses, busNumToSensiColumn, context.getEquationSystem(), context.getJacobianMatrix());
            return new SensitivityContext(busNumToSensiColumn, sensitivities);
        }

        private static DenseMatrix calculateSensitivityValues(List<LfBus> controlledBuses, Map<Integer, Integer> busNumToSensiColumn, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j) {
            DenseMatrix rhs = new DenseMatrix(equationSystem.getIndex().getSortedEquationsToSolve().size(), controlledBuses.size());
            for (LfBus controlledBus : controlledBuses) {
                equationSystem.getEquation(controlledBus.getNum(), AcEquationType.BUS_TARGET_V).ifPresent(equation -> rhs.set(equation.getColumn(), ((Integer)busNumToSensiColumn.get(controlledBus.getNum())).intValue(), 1.0));
            }
            j.solveTransposed(rhs);
            return rhs;
        }

        private static EquationTerm<AcVariableType, AcEquationType> getCalculatedV(LfBus pilotBus) {
            return (EquationTerm)pilotBus.getCalculatedV();
        }

        private static EquationTerm<AcEquationType, AcEquationType> getQ1(LfBranch branch) {
            return (EquationTerm)branch.getQ1();
        }

        private static EquationTerm<AcEquationType, AcEquationType> getQ2(LfBranch branch) {
            return (EquationTerm)branch.getQ2();
        }

        private static EquationTerm<AcEquationType, AcEquationType> getQ(LfShunt shunt) {
            return (EquationTerm)shunt.getQ();
        }

        double calculateSensiK(LfBus controllerBus, LfBus controlledBus) {
            return 2.0 * this.calculateSensiQ(controllerBus, controlledBus) / (controllerBus.getMaxQ() - controllerBus.getMinQ());
        }

        double calculateSensiQ(LfBus controllerBus, LfBus controlledBus) {
            int controlledBusSensiColumn = this.busNumToSensiColumn.get(controlledBus.getNum());
            MutableDouble sq = new MutableDouble();
            for (LfBranch branch : controllerBus.getBranches()) {
                if (branch.getBus1() == controllerBus && branch.getBus2() != null) {
                    sq.add(SensitivityContext.getQ1(branch).calculateSensi(this.sensitivities, controlledBusSensiColumn));
                    continue;
                }
                if (branch.getBus2() != controllerBus || branch.getBus1() == null) continue;
                sq.add(SensitivityContext.getQ2(branch).calculateSensi(this.sensitivities, controlledBusSensiColumn));
            }
            controllerBus.getShunt().ifPresent(shunt -> sq.add(SensitivityContext.getQ(shunt).calculateSensi(this.sensitivities, controlledBusSensiColumn)));
            controllerBus.getControllerShunt().ifPresent(shunt -> sq.add(SensitivityContext.getQ(shunt).calculateSensi(this.sensitivities, controlledBusSensiColumn)));
            controllerBus.getSvcShunt().ifPresent(shunt -> sq.add(SensitivityContext.getQ(shunt).calculateSensi(this.sensitivities, controlledBusSensiColumn)));
            return sq.getValue();
        }

        double calculateSensiVpp(LfBus controlledBus, LfBus pilotBus) {
            int controlledBusSensiColumn = this.busNumToSensiColumn.get(controlledBus.getNum());
            return SensitivityContext.getCalculatedV(pilotBus).calculateSensi(this.sensitivities, controlledBusSensiColumn);
        }
    }

    private record KStats(double kAverage, double dkDiffMax, boolean allAtLimits) {
    }
}

