/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AbstractShuntVoltageControlOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.VoltageControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuntVoltageControlOuterLoop
extends AbstractShuntVoltageControlOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuntVoltageControlOuterLoop.class);
    public static final String NAME = "ShuntVoltageControl";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        context.getNetwork().getControllerElements(VoltageControl.Type.SHUNT).forEach(controllerShunt -> controllerShunt.setVoltageControlEnabled(true));
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        if (context.getIteration() == 0) {
            for (LfShunt controllerShunt : context.getNetwork().getControllerElements(VoltageControl.Type.SHUNT)) {
                controllerShunt.setVoltageControlEnabled(false);
                double b = controllerShunt.getB();
                controllerShunt.dispatchB();
                LOGGER.trace("Round susceptance of '{}': {} -> {}", new Object[]{controllerShunt.getId(), b, controllerShunt.getB()});
                status = OuterLoopStatus.UNSTABLE;
            }
        }
        return new OuterLoopResult(this, status);
    }
}

