/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AbstractTransformerVoltageControlOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.tap.GeneratorVoltageControlManager;
import com.powsybl.openloadflow.ac.outerloop.tap.TransformerRatioManager;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;

public class TransformerVoltageControlOuterLoop
extends AbstractTransformerVoltageControlOuterLoop {
    public static final String NAME = "TransformerVoltageControl";
    private final double maxControlledNominalVoltageOverride;
    private final boolean useInitialTapPosition;

    public TransformerVoltageControlOuterLoop(boolean useInitialTapPosition, double maxControlledNominalVoltageOverride) {
        this.useInitialTapPosition = useInitialTapPosition;
        this.maxControlledNominalVoltageOverride = maxControlledNominalVoltageOverride;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        ContextData contextData = new ContextData();
        context.setData(contextData);
        for (LfBranch controllerBranch : context.getNetwork().getControllerElements(VoltageControl.Type.TRANSFORMER)) {
            controllerBranch.setVoltageControlEnabled(false);
        }
        contextData.generatorVoltageControlManager = new GeneratorVoltageControlManager(context.getNetwork(), this.maxControlledNominalVoltageOverride);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        ContextData contextData = (ContextData)context.getData();
        return switch (contextData.step) {
            default -> throw new IncompatibleClassChangeError();
            case Step.INITIAL -> this.initStep(context.getNetwork(), contextData);
            case Step.CONTROL -> this.controlStep(context.getNetwork(), contextData);
            case Step.COMPLETE -> new OuterLoopResult(this, OuterLoopStatus.STABLE);
        };
    }

    private OuterLoopResult initStep(LfNetwork network, ContextData contextData) {
        boolean needRun = false;
        for (LfBranch branch : network.getControllerElements(VoltageControl.Type.TRANSFORMER)) {
            if (!branch.getVoltageControl().isPresent()) continue;
            TransformerVoltageControl voltageControl = branch.getVoltageControl().orElseThrow();
            double targetV = voltageControl.getTargetValue();
            double v = voltageControl.getControlledBus().getV();
            double diffV = targetV - v;
            double halfTargetDeadband = TransformerVoltageControlOuterLoop.getHalfTargetDeadband(voltageControl);
            if (!(Math.abs(diffV) > halfTargetDeadband) || !branch.isConnectedAtBothSides()) continue;
            branch.setVoltageControlEnabled(true);
            needRun = true;
        }
        contextData.transformerRatioManager = new TransformerRatioManager(network, this.useInitialTapPosition);
        if (!needRun) {
            contextData.step = Step.COMPLETE;
            return new OuterLoopResult(this, OuterLoopStatus.STABLE);
        }
        contextData.generatorVoltageControlManager.disableGeneratorVoltageControlsUnderMaxControlledNominalVoltage(network);
        network.fixTransformerVoltageControls();
        contextData.step = Step.CONTROL;
        return new OuterLoopResult(this, OuterLoopStatus.UNSTABLE);
    }

    private OuterLoopResult controlStep(LfNetwork network, ContextData contextData) {
        boolean outOfBoundTap = false;
        for (LfBranch controllerBranch : network.getControllerElements(VoltageControl.Type.TRANSFORMER)) {
            if (!contextData.transformerRatioManager.roundR1ToExtremeTapPosition(controllerBranch)) continue;
            outOfBoundTap = true;
        }
        if (!outOfBoundTap) {
            this.updateContinuousRatio(network, contextData);
            this.roundVoltageRatios(network);
            contextData.generatorVoltageControlManager.enableGeneratorVoltageControlsUnderMaxControlledNominalVoltage();
            contextData.step = Step.COMPLETE;
        }
        return new OuterLoopResult(this, OuterLoopStatus.UNSTABLE);
    }

    private void updateContinuousRatio(LfNetwork network, ContextData contextData) {
        for (LfBus bus : network.getControlledBuses(VoltageControl.Type.TRANSFORMER)) {
            bus.getTransformerVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> voltageControl.getMergedControllerElements().stream().filter(b -> !b.isDisabled()).filter(LfBranch::isVoltageControlEnabled).forEach(b -> contextData.transformerRatioManager.updateContinuousRatio((LfBranch)b)));
        }
    }

    private static final class ContextData {
        private TransformerRatioManager transformerRatioManager;
        private GeneratorVoltageControlManager generatorVoltageControlManager;
        private Step step = Step.INITIAL;

        private ContextData() {
        }
    }

    private static enum Step {
        INITIAL,
        CONTROL,
        COMPLETE;

    }
}

