/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop.tap;

import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.VoltageControl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerRatioManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformerRatioManager.class);
    private final boolean useInitialTapPosition;
    private final Map<String, Pair<Double, SharedControl>> sharedControlByBranchId = new HashMap<String, Pair<Double, SharedControl>>();

    public TransformerRatioManager(LfNetwork network, boolean useInitialTapPosition) {
        this.useInitialTapPosition = useInitialTapPosition;
        for (LfBus bus : network.getControlledBuses(VoltageControl.Type.TRANSFORMER)) {
            bus.getTransformerVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> {
                List<LfBranch> controllerBranches = voltageControl.getMergedControllerElements().stream().filter(b -> !b.isDisabled()).filter(LfBranch::isVoltageControlEnabled).toList();
                if (!controllerBranches.isEmpty()) {
                    if (useInitialTapPosition) {
                        double a = 0.0;
                        double b2 = 0.0;
                        for (LfBranch branch2 : controllerBranches) {
                            double minR1;
                            PiModel piModel = branch2.getPiModel();
                            double r1 = piModel.getR1();
                            double maxR1 = piModel.getMaxR1();
                            if (maxR1 != (minR1 = piModel.getMinR1())) {
                                a += (maxR1 - r1) / (maxR1 - minR1);
                                b2 += (r1 - minR1) / (maxR1 - minR1);
                                continue;
                            }
                            a += 1.0;
                            b2 += 1.0;
                        }
                        SharedControl sharedControl = new SharedControl(controllerBranches.stream().mapToDouble(branch -> branch.getPiModel().getMaxR1()).average().orElseThrow(), controllerBranches.stream().mapToDouble(branch -> branch.getPiModel().getMinR1()).average().orElseThrow(), a, b2, controllerBranches.size());
                        controllerBranches.forEach(branch -> this.sharedControlByBranchId.put(branch.getId(), (Pair<Double, SharedControl>)Pair.of((Object)branch.getPiModel().getR1(), (Object)sharedControl)));
                    } else {
                        controllerBranches.forEach(branch -> this.sharedControlByBranchId.put(branch.getId(), (Pair<Double, SharedControl>)Pair.of((Object)branch.getPiModel().getR1(), (Object)new SharedControl(branch.getPiModel()))));
                    }
                }
            });
        }
    }

    public void updateContinuousRatio(LfBranch branch) {
        if (this.useInitialTapPosition) {
            double individualInitialR1 = (Double)this.sharedControlByBranchId.get(branch.getId()).getLeft();
            SharedControl sharedControl = (SharedControl)this.sharedControlByBranchId.get(branch.getId()).getRight();
            double maxR1 = sharedControl.maxR1();
            double minR1 = sharedControl.minR1();
            double initialR1 = sharedControl.initialR1();
            double computedR1 = branch.getPiModel().getR1();
            double updatedR1 = computedR1 >= initialR1 ? individualInitialR1 + (computedR1 - initialR1) * (branch.getPiModel().getMaxR1() - individualInitialR1) / (maxR1 - initialR1) : individualInitialR1 - (initialR1 - computedR1) * (individualInitialR1 - branch.getPiModel().getMinR1()) / (initialR1 - minR1);
            branch.getPiModel().setR1(updatedR1);
        }
    }

    public boolean roundR1ToExtremeTapPosition(LfBranch branch) {
        if (branch.isVoltageControlEnabled() && !branch.isDisabled()) {
            PiModel piModel = branch.getPiModel();
            double r1 = piModel.getR1();
            SharedControl sharedControl = (SharedControl)this.sharedControlByBranchId.get(branch.getId()).getRight();
            double minR1 = sharedControl.minR1();
            double maxR1 = sharedControl.maxR1();
            if (r1 < minR1 || r1 > maxR1) {
                LOGGER.info("Transformer {} with voltage control frozen: rounded at extreme tap position", (Object)branch.getId());
                piModel.setR1(r1 > maxR1 ? maxR1 : minR1);
                piModel.roundR1ToClosestTap();
                branch.setVoltageControlEnabled(false);
                return true;
            }
        }
        return false;
    }

    public record SharedControl(double maxR1, double minR1, double initialR1) {
        public SharedControl(PiModel piModel) {
            this(piModel.getMaxR1(), piModel.getMinR1(), piModel.getR1());
        }

        public SharedControl(double maxR1, double minR1, double a, double b, int count) {
            this(maxR1, minR1, (minR1 * a + maxR1 * b) / (double)count);
        }
    }
}

