/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.StateVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.VoltageInitializer;

public final class AcSolverUtil {
    private AcSolverUtil() {
    }

    public static void initStateVector(LfNetwork network, EquationSystem<AcVariableType, AcEquationType> equationSystem, VoltageInitializer initializer) {
        double[] x = new double[equationSystem.getIndex().getSortedVariablesToFind().size()];
        block9: for (Variable<AcVariableType> v : equationSystem.getIndex().getSortedVariablesToFind()) {
            switch (v.getType()) {
                case BUS_V: {
                    x[v.getRow()] = initializer.getMagnitude(network.getBus(v.getElementNum()));
                    continue block9;
                }
                case BUS_PHI: {
                    x[v.getRow()] = initializer.getAngle(network.getBus(v.getElementNum()));
                    continue block9;
                }
                case SHUNT_B: {
                    x[v.getRow()] = network.getShunt(v.getElementNum()).getB();
                    continue block9;
                }
                case BRANCH_ALPHA1: {
                    x[v.getRow()] = network.getBranch(v.getElementNum()).getPiModel().getA1();
                    continue block9;
                }
                case BRANCH_RHO1: {
                    x[v.getRow()] = network.getBranch(v.getElementNum()).getPiModel().getR1();
                    continue block9;
                }
                case DUMMY_P: 
                case DUMMY_Q: 
                case BUS_PHI_ZERO: 
                case BUS_PHI_NEGATIVE: {
                    x[v.getRow()] = 0.0;
                    continue block9;
                }
                case BUS_V_ZERO: 
                case BUS_V_NEGATIVE: {
                    x[v.getRow()] = 0.1;
                    continue block9;
                }
            }
            throw new IllegalStateException("Unknown variable type " + v.getType());
        }
        equationSystem.getStateVector().set(x);
    }

    public static void updateNetwork(LfNetwork network, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        StateVector stateVector = equationSystem.getStateVector();
        block12: for (Variable<AcVariableType> v : equationSystem.getIndex().getSortedVariablesToFind()) {
            switch (v.getType()) {
                case BUS_V: {
                    network.getBus(v.getElementNum()).setV(stateVector.get(v.getRow()));
                    continue block12;
                }
                case BUS_PHI: {
                    network.getBus(v.getElementNum()).setAngle(stateVector.get(v.getRow()));
                    continue block12;
                }
                case BUS_V_ZERO: {
                    network.getBus(v.getElementNum()).getAsym().setVz(stateVector.get(v.getRow()));
                    continue block12;
                }
                case BUS_PHI_ZERO: {
                    network.getBus(v.getElementNum()).getAsym().setAngleZ(stateVector.get(v.getRow()));
                    continue block12;
                }
                case BUS_V_NEGATIVE: {
                    network.getBus(v.getElementNum()).getAsym().setVn(stateVector.get(v.getRow()));
                    continue block12;
                }
                case BUS_PHI_NEGATIVE: {
                    network.getBus(v.getElementNum()).getAsym().setAngleN(stateVector.get(v.getRow()));
                    continue block12;
                }
                case SHUNT_B: {
                    network.getShunt(v.getElementNum()).setB(stateVector.get(v.getRow()));
                    continue block12;
                }
                case BRANCH_ALPHA1: {
                    network.getBranch(v.getElementNum()).getPiModel().setA1(stateVector.get(v.getRow()));
                    continue block12;
                }
                case BRANCH_RHO1: {
                    network.getBranch(v.getElementNum()).getPiModel().setR1(stateVector.get(v.getRow()));
                    continue block12;
                }
                case DUMMY_P: 
                case DUMMY_Q: {
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown variable type " + v.getType());
        }
    }
}

