/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.StateVectorScaling;
import com.powsybl.openloadflow.ac.solver.StateVectorScalingMode;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.StateVector;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.equations.Vectors;
import com.powsybl.openloadflow.util.Reports;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineSearchStateVectorScaling
implements StateVectorScaling {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineSearchStateVectorScaling.class);
    public static final int DEFAULT_MAX_ITERATION = 10;
    public static final double DEFAULT_STEP_FOLD = 1.3333333333333333;
    private double[] lastDx;
    private NewtonRaphsonStoppingCriteria.TestResult lastTestResult;
    private final int maxIteration;
    private final double stepFold;

    public LineSearchStateVectorScaling(NewtonRaphsonStoppingCriteria.TestResult initialTestResult, int maxIteration, double stepFold) {
        this.lastTestResult = Objects.requireNonNull(initialTestResult);
        this.maxIteration = maxIteration;
        this.stepFold = stepFold;
    }

    @Override
    public StateVectorScalingMode getMode() {
        return StateVectorScalingMode.LINE_SEARCH;
    }

    @Override
    public void apply(double[] dx, EquationSystem<AcVariableType, AcEquationType> equationSystem, ReportNode reportNode) {
        if (this.lastDx == null || this.lastDx.length != dx.length) {
            this.lastDx = (double[])dx.clone();
        } else {
            System.arraycopy(dx, 0, this.lastDx, 0, dx.length);
        }
    }

    @Override
    public NewtonRaphsonStoppingCriteria.TestResult applyAfter(EquationSystem<AcVariableType, AcEquationType> equationSystem, EquationVector<AcVariableType, AcEquationType> equationVector, TargetVector<AcVariableType, AcEquationType> targetVector, NewtonRaphsonStoppingCriteria stoppingCriteria, NewtonRaphsonStoppingCriteria.TestResult testResult, ReportNode reportNode) {
        StateVector stateVector = equationSystem.getStateVector();
        if (this.lastTestResult != null) {
            double stepSize = 1.0;
            NewtonRaphsonStoppingCriteria.TestResult currentTestResult = testResult;
            double[] x = null;
            for (int iteration = 1; currentTestResult.getNorm() >= this.lastTestResult.getNorm() && iteration <= this.maxIteration; ++iteration) {
                if (x == null) {
                    x = stateVector.get();
                }
                double[] newX = (double[])x.clone();
                stepSize = 1.0 / Math.pow(this.stepFold, iteration);
                Vectors.plus(newX, this.lastDx, 1.0 - stepSize);
                stateVector.set(newX);
                equationVector.minus(targetVector);
                currentTestResult = stoppingCriteria.test(equationVector.getArray(), equationSystem);
            }
            this.lastTestResult = currentTestResult;
            LOGGER.debug("Step size: {}", (Object)stepSize);
            if (reportNode != null) {
                Reports.reportLineSearchStateVectorScaling(reportNode, stepSize);
            }
        }
        return this.lastTestResult;
    }
}

