/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.StateVectorScaling;
import com.powsybl.openloadflow.ac.solver.StateVectorScalingMode;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.Vectors;
import com.powsybl.openloadflow.util.Reports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxVoltageChangeStateVectorScaling
implements StateVectorScaling {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaxVoltageChangeStateVectorScaling.class);
    public static final double DEFAULT_MAX_DV = 0.1;
    public static final double DEFAULT_MAX_DPHI = Math.toRadians(10.0);
    private final double maxDv;
    private final double maxDphi;

    public MaxVoltageChangeStateVectorScaling(double maxDv, double maxDphi) {
        this.maxDv = maxDv;
        this.maxDphi = maxDphi;
    }

    @Override
    public StateVectorScalingMode getMode() {
        return StateVectorScalingMode.MAX_VOLTAGE_CHANGE;
    }

    @Override
    public void apply(double[] dx, EquationSystem<AcVariableType, AcEquationType> equationSystem, ReportNode reportNode) {
        int vCutCount = 0;
        int phiCutCount = 0;
        double stepSize = 1.0;
        for (Variable<AcVariableType> variable : equationSystem.getIndex().getSortedVariablesToFind()) {
            int row = variable.getRow();
            double absValueChange = Math.abs(dx[row]);
            switch (variable.getType()) {
                case BUS_V: {
                    if (!(absValueChange > this.maxDv)) break;
                    stepSize = Math.min(stepSize, this.maxDv / absValueChange);
                    ++vCutCount;
                    break;
                }
                case BUS_PHI: {
                    if (!(absValueChange > this.maxDphi)) break;
                    stepSize = Math.min(stepSize, this.maxDphi / absValueChange);
                    ++phiCutCount;
                    break;
                }
            }
        }
        if (vCutCount > 0 || phiCutCount > 0) {
            LOGGER.debug("Step size: {} ({} dv and {} dphi changes outside thresholds)", new Object[]{stepSize, vCutCount, phiCutCount});
            if (reportNode != null) {
                Reports.reportMaxVoltageChangeStateVectorScaling(reportNode, stepSize, vCutCount, phiCutCount);
            }
            Vectors.mult(dx, stepSize);
        }
    }

    @Override
    public NewtonRaphsonStoppingCriteria.TestResult applyAfter(EquationSystem<AcVariableType, AcEquationType> equationSystem, EquationVector<AcVariableType, AcEquationType> equationVector, TargetVector<AcVariableType, AcEquationType> targetVector, NewtonRaphsonStoppingCriteria stoppingCriteria, NewtonRaphsonStoppingCriteria.TestResult testResult, ReportNode reportNode) {
        return testResult;
    }
}

