/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.math.matrix.MatrixException;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.AbstractAcSolver;
import com.powsybl.openloadflow.ac.solver.AcSolverResult;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.ac.solver.AcSolverUtil;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonParameters;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.StateVectorScaling;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.Vectors;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import com.powsybl.openloadflow.util.Reports;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewtonRaphson
extends AbstractAcSolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewtonRaphson.class);
    public static final List<AcEquationType> REPORTED_AC_EQUATION_TYPES = List.of(AcEquationType.BUS_TARGET_P, AcEquationType.BUS_TARGET_Q, AcEquationType.BUS_TARGET_V);
    protected final NewtonRaphsonParameters parameters;

    public NewtonRaphson(LfNetwork network, NewtonRaphsonParameters parameters, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j, TargetVector<AcVariableType, AcEquationType> targetVector, EquationVector<AcVariableType, AcEquationType> equationVector, boolean detailedReport) {
        super(network, equationSystem, j, targetVector, equationVector, detailedReport);
        this.parameters = Objects.requireNonNull(parameters);
    }

    @Override
    public String getName() {
        return "Newton Raphson";
    }

    public static List<Pair<Equation<AcVariableType, AcEquationType>, Double>> findLargestMismatches(EquationSystem<AcVariableType, AcEquationType> equationSystem, double[] mismatch, int count) {
        return equationSystem.getIndex().getSortedEquationsToSolve().stream().map(equation -> Pair.of((Object)equation, (Object)mismatch[equation.getColumn()])).filter(e -> Math.abs((Double)e.getValue()) > Math.pow(10.0, -7.0)).sorted(Comparator.comparingDouble(e -> Math.abs((Double)e.getValue())).reversed()).limit(count).toList();
    }

    public static Map<AcEquationType, Pair<Equation<AcVariableType, AcEquationType>, Double>> getLargestMismatchByAcEquationType(EquationSystem<AcVariableType, AcEquationType> equationSystem, double[] mismatch) {
        return equationSystem.getIndex().getSortedEquationsToSolve().stream().map(equation -> Pair.of((Object)equation, (Object)mismatch[equation.getColumn()])).collect(Collectors.toMap(e -> (AcEquationType)((Equation)e.getKey()).getType(), Function.identity(), BinaryOperator.maxBy(Comparator.comparingDouble(e -> Math.abs((Double)e.getValue())))));
    }

    public void reportAndLogLargestMismatchByAcEquationType(ReportNode reportNode, EquationSystem<AcVariableType, AcEquationType> equationSystem, double[] mismatch) {
        Map<AcEquationType, Pair<Equation<AcVariableType, AcEquationType>, Double>> mismatchEquations = NewtonRaphson.getLargestMismatchByAcEquationType(equationSystem, mismatch);
        for (AcEquationType acEquationType : REPORTED_AC_EQUATION_TYPES) {
            Optional.ofNullable(mismatchEquations.get(acEquationType)).ifPresent(equationPair -> {
                Equation equation = (Equation)equationPair.getKey();
                double equationMismatch = (Double)equationPair.getValue();
                int elementNum = equation.getElementNum();
                String elementId = equation.getElement(this.network).map(LfElement::getId).orElse("?");
                int busVRow = equationSystem.getVariable(elementNum, AcVariableType.BUS_V).getRow();
                int busPhiRow = equationSystem.getVariable(elementNum, AcVariableType.BUS_PHI).getRow();
                double busV = equationSystem.getStateVector().get(busVRow);
                double busPhi = equationSystem.getStateVector().get(busPhiRow);
                LfBus bus = this.network.getBus(elementNum);
                double busNominalV = bus.getNominalV();
                double busSumP = bus.getP().eval() * 100.0;
                double busSumQ = bus.getQ().eval() * 100.0;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Largest mismatch on {}: {}", (Object)this.getEquationTypeDescription(acEquationType), (Object)equationMismatch);
                    LOGGER.trace("    Bus Id: {} (nominalVoltage={})", (Object)elementId, (Object)busNominalV);
                    LOGGER.trace("    Bus  V: {} pu, {} rad", (Object)busV, (Object)busPhi);
                }
                if (reportNode != null) {
                    Reports.BusReport busReport = new Reports.BusReport(elementId, equationMismatch, busNominalV, busV, busPhi, busSumP, busSumQ);
                    Reports.reportNewtonRaphsonLargestMismatches(reportNode, this.getEquationTypeDescription(acEquationType), busReport);
                }
            });
        }
    }

    private String getEquationTypeDescription(AcEquationType acEquationType) {
        return switch (acEquationType) {
            case AcEquationType.BUS_TARGET_P -> "P";
            case AcEquationType.BUS_TARGET_Q -> "Q";
            case AcEquationType.BUS_TARGET_V -> "V";
            default -> null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcSolverStatus runIteration(StateVectorScaling svScaling, MutableInt iterations, ReportNode reportNode) {
        LOGGER.debug("Start iteration {}", (Object)iterations);
        try {
            ReportNode iterationReportNode = this.detailedReport ? Reports.createNewtonRaphsonMismatchReporter(reportNode, iterations.getValue() + 1) : null;
            try {
                this.j.solveTransposed(this.equationVector.getArray());
            }
            catch (MatrixException e2) {
                LOGGER.error(e2.toString(), (Throwable)e2);
                Reports.reportNewtonRaphsonError(reportNode, e2.toString());
                AcSolverStatus acSolverStatus = AcSolverStatus.SOLVER_FAILED;
                iterations.increment();
                return acSolverStatus;
            }
            svScaling.apply(this.equationVector.getArray(), this.equationSystem, iterationReportNode);
            this.equationSystem.getStateVector().minus(this.equationVector.getArray());
            this.equationVector.minus(this.targetVector);
            if (LOGGER.isTraceEnabled()) {
                NewtonRaphson.findLargestMismatches(this.equationSystem, this.equationVector.getArray(), 5).forEach(e -> {
                    Equation equation = (Equation)e.getKey();
                    String elementId = equation.getElement(this.network).map(LfElement::getId).orElse("?");
                    LOGGER.trace("Mismatch for {}: {} (element={})", new Object[]{equation, e.getValue(), elementId});
                });
            }
            NewtonRaphsonStoppingCriteria.TestResult testResult = this.parameters.getStoppingCriteria().test(this.equationVector.getArray(), this.equationSystem);
            testResult = svScaling.applyAfter(this.equationSystem, this.equationVector, this.targetVector, this.parameters.getStoppingCriteria(), testResult, iterationReportNode);
            LOGGER.debug("|f(x)|={}", (Object)testResult.getNorm());
            if (this.detailedReport) {
                Reports.reportNewtonRaphsonNorm(iterationReportNode, testResult.getNorm());
            }
            if (this.detailedReport || LOGGER.isTraceEnabled()) {
                this.reportAndLogLargestMismatchByAcEquationType(iterationReportNode, this.equationSystem, this.equationVector.getArray());
            }
            if (testResult.isStop()) {
                AcSolverStatus acSolverStatus = AcSolverStatus.CONVERGED;
                return acSolverStatus;
            }
            AcSolverStatus acSolverStatus = null;
            return acSolverStatus;
        }
        finally {
            iterations.increment();
        }
    }

    private boolean isStateUnrealistic(ReportNode reportNode) {
        LinkedHashMap<String, Double> busesOutOfNormalVoltageRange = new LinkedHashMap<String, Double>();
        for (Variable variable : this.equationSystem.getIndex().getSortedVariablesToFind()) {
            double value;
            if (variable.getType() != AcVariableType.BUS_V || this.network.getBus(variable.getElementNum()).isFictitious() || !((value = this.equationSystem.getStateVector().get(variable.getRow())) < this.parameters.getMinRealisticVoltage()) && !(value > this.parameters.getMaxRealisticVoltage())) continue;
            busesOutOfNormalVoltageRange.put(this.network.getBus(variable.getElementNum()).getId(), value);
        }
        if (!busesOutOfNormalVoltageRange.isEmpty()) {
            if (LOGGER.isTraceEnabled()) {
                for (Map.Entry entry : busesOutOfNormalVoltageRange.entrySet()) {
                    LOGGER.trace("Bus '{}' has an unrealistic voltage magnitude: {} pu", entry.getKey(), entry.getValue());
                }
            }
            LOGGER.error("{} buses have a voltage magnitude out of range [{}, {}]: {}", new Object[]{busesOutOfNormalVoltageRange.size(), this.parameters.getMinRealisticVoltage(), this.parameters.getMaxRealisticVoltage(), busesOutOfNormalVoltageRange});
            Reports.reportNewtonRaphsonBusesOutOfRealisticVoltageRange(reportNode, busesOutOfNormalVoltageRange, this.parameters.getMinRealisticVoltage(), this.parameters.getMaxRealisticVoltage());
        }
        return !busesOutOfNormalVoltageRange.isEmpty();
    }

    @Override
    public AcSolverResult run(VoltageInitializer voltageInitializer, ReportNode reportNode) {
        ReportNode initialReportNode;
        AcSolverUtil.initStateVector(this.network, this.equationSystem, voltageInitializer);
        Vectors.minus(this.equationVector.getArray(), this.targetVector.getArray());
        NewtonRaphsonStoppingCriteria.TestResult initialTestResult = this.parameters.getStoppingCriteria().test(this.equationVector.getArray(), this.equationSystem);
        StateVectorScaling svScaling = StateVectorScaling.fromMode(this.parameters, initialTestResult);
        LOGGER.debug("|f(x0)|={}", (Object)initialTestResult.getNorm());
        ReportNode reportNode2 = initialReportNode = this.detailedReport ? Reports.createNewtonRaphsonMismatchReporter(reportNode, 0) : null;
        if (this.detailedReport) {
            Reports.reportNewtonRaphsonNorm(initialReportNode, initialTestResult.getNorm());
        }
        if (this.detailedReport || LOGGER.isTraceEnabled()) {
            this.reportAndLogLargestMismatchByAcEquationType(initialReportNode, this.equationSystem, this.equationVector.getArray());
        }
        AcSolverStatus status = AcSolverStatus.NO_CALCULATION;
        MutableInt iterations = new MutableInt();
        while (iterations.getValue() <= this.parameters.getMaxIterations()) {
            AcSolverStatus newStatus = this.runIteration(svScaling, iterations, reportNode);
            if (newStatus == null) continue;
            status = newStatus;
            break;
        }
        if (iterations.getValue() >= this.parameters.getMaxIterations()) {
            status = AcSolverStatus.MAX_ITERATION_REACHED;
        }
        if (status == AcSolverStatus.CONVERGED || this.parameters.isAlwaysUpdateNetwork()) {
            AcSolverUtil.updateNetwork(this.network, this.equationSystem);
        }
        if (status == AcSolverStatus.CONVERGED && this.isStateUnrealistic(reportNode)) {
            status = AcSolverStatus.UNREALISTIC_STATE;
        }
        double slackBusActivePowerMismatch = this.network.getSlackBuses().stream().mapToDouble(LfBus::getMismatchP).sum();
        return new AcSolverResult(status, iterations.getValue(), slackBusActivePowerMismatch);
    }
}

