/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.Vectors;

public class PerEquationTypeStoppingCriteria
implements NewtonRaphsonStoppingCriteria {
    private final double convEpsPerEq;
    private final double maxDefaultAngleMismatch;
    private final double maxDefaultRatioMismatch;
    private final double maxDefaultSusceptanceMismatch;
    private final double maxActivePowerMismatch;
    private final double maxReactivePowerMismatch;
    private final double maxVoltageMismatch;

    public PerEquationTypeStoppingCriteria(double convEpsPerEq, double maxActivePowerMismatch, double maxReactivePowerMismatch, double maxVoltageMismatch, double maxDefaultAngleMismatch, double maxDefaultRatioMismatch, double maxDefaultSusceptanceMismatch) {
        this.convEpsPerEq = convEpsPerEq;
        this.maxActivePowerMismatch = maxActivePowerMismatch;
        this.maxReactivePowerMismatch = maxReactivePowerMismatch;
        this.maxVoltageMismatch = maxVoltageMismatch;
        this.maxDefaultAngleMismatch = maxDefaultAngleMismatch;
        this.maxDefaultRatioMismatch = maxDefaultRatioMismatch;
        this.maxDefaultSusceptanceMismatch = maxDefaultSusceptanceMismatch;
    }

    private double computeNorm(double[] fx) {
        return Vectors.norm2(fx);
    }

    private boolean computeStop(double[] fx, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        block8: for (Equation<AcVariableType, AcEquationType> eq : equationSystem.getIndex().getSortedEquationsToSolve()) {
            AcEquationType type = eq.getType();
            int idx = eq.getColumn();
            switch (type) {
                case BRANCH_TARGET_P: 
                case BUS_TARGET_P: 
                case DUMMY_TARGET_P: 
                case BUS_DISTR_SLACK_P: {
                    if (!(Math.abs(fx[idx]) * 100.0 >= this.maxActivePowerMismatch)) continue block8;
                    return false;
                }
                case BRANCH_TARGET_Q: 
                case BUS_TARGET_Q: 
                case DISTR_Q: 
                case DUMMY_TARGET_Q: {
                    if (!(Math.abs(fx[idx]) * 100.0 >= this.maxReactivePowerMismatch)) continue block8;
                    return false;
                }
                case BUS_TARGET_V: 
                case ZERO_V: {
                    if (!(Math.abs(fx[idx]) >= this.maxVoltageMismatch)) continue block8;
                    return false;
                }
                case BRANCH_TARGET_RHO1: 
                case DISTR_RHO: {
                    if (!(Math.abs(fx[idx]) >= this.maxDefaultRatioMismatch)) continue block8;
                    return false;
                }
                case DISTR_SHUNT_B: 
                case SHUNT_TARGET_B: {
                    if (!(Math.abs(fx[idx]) >= this.maxDefaultSusceptanceMismatch)) continue block8;
                    return false;
                }
                case BUS_TARGET_PHI: 
                case ZERO_PHI: 
                case BRANCH_TARGET_ALPHA1: {
                    if (!(Math.abs(fx[idx]) >= this.maxDefaultAngleMismatch)) continue block8;
                    return false;
                }
            }
            if (!(Math.abs(fx[idx]) >= this.convEpsPerEq)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NewtonRaphsonStoppingCriteria.TestResult test(double[] fx, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        return new NewtonRaphsonStoppingCriteria.TestResult(this.computeStop(fx, equationSystem), this.computeNorm(fx));
    }
}

