/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcOuterLoopContext;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.outerloop.AbstractIncrementalPhaseControlOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.IncrementalContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class DcIncrementalPhaseControlOuterLoop
extends AbstractIncrementalPhaseControlOuterLoop<DcVariableType, DcEquationType, DcLoadFlowParameters, DcLoadFlowContext, DcOuterLoopContext> {
    public DcIncrementalPhaseControlOuterLoop() {
        super(LoggerFactory.getLogger(DcIncrementalPhaseControlOuterLoop.class));
    }

    @Override
    public String getName() {
        return "DC Incremental phase control";
    }

    @Override
    public OuterLoopResult check(DcOuterLoopContext context, ReportNode reportNode) {
        DcSensitivityContext sensitivityContext;
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        IncrementalContextData contextData = (IncrementalContextData)context.getData();
        LfNetwork network = context.getNetwork();
        List<LfBranch> controllerBranches = DcIncrementalPhaseControlOuterLoop.getControllerBranches(network);
        ArrayList<TransformerPhaseControl> activePowerControlPhaseControls = new ArrayList<TransformerPhaseControl>();
        for (LfBranch controllerBranch : controllerBranches) {
            controllerBranch.getPhaseControl().ifPresent(phaseControl -> {
                if (phaseControl.getMode() == TransformerPhaseControl.Mode.CONTROLLER) {
                    activePowerControlPhaseControls.add((TransformerPhaseControl)phaseControl);
                }
            });
        }
        if (!activePowerControlPhaseControls.isEmpty() && this.checkActivePowerControlPhaseControls(sensitivityContext = new DcSensitivityContext(network, controllerBranches, ((DcLoadFlowContext)context.getLoadFlowContext()).getEquationSystem(), ((DcLoadFlowContext)context.getLoadFlowContext()).getJacobianMatrix()), contextData, activePowerControlPhaseControls) != 0) {
            status = OuterLoopStatus.UNSTABLE;
        }
        return new OuterLoopResult(this, status);
    }

    public static class DcSensitivityContext
    extends AbstractIncrementalPhaseControlOuterLoop.AbstractSensitivityContext<DcVariableType, DcEquationType> {
        public DcSensitivityContext(LfNetwork network, List<LfBranch> controllerBranches, EquationSystem<DcVariableType, DcEquationType> equationSystem, JacobianMatrix<DcVariableType, DcEquationType> jacobianMatrix) {
            super(network, controllerBranches, equationSystem, jacobianMatrix);
        }

        @Override
        public DenseMatrix calculateSensitivityValues(List<LfBranch> controllerBranches, int[] controllerBranchIndex, EquationSystem<DcVariableType, DcEquationType> equationSystem, JacobianMatrix<DcVariableType, DcEquationType> jacobianMatrix) {
            DenseMatrix rhs = new DenseMatrix(equationSystem.getIndex().getSortedEquationsToSolve().size(), controllerBranches.size());
            for (LfBranch controllerBranch : controllerBranches) {
                equationSystem.getEquation(controllerBranch.getNum(), DcEquationType.BRANCH_TARGET_ALPHA1).ifPresent(equation -> rhs.set(equation.getColumn(), controllerBranchIndex[controllerBranch.getNum()], Math.toRadians(1.0)));
            }
            jacobianMatrix.solveTransposed(rhs);
            return rhs;
        }
    }
}

