/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.MatrixException;
import com.powsybl.openloadflow.dc.DcIncrementalPhaseControlOuterLoop;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowResult;
import com.powsybl.openloadflow.dc.DcOuterLoopContext;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.lf.LoadFlowEngine;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkLoader;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import com.powsybl.openloadflow.util.Reports;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcLoadFlowEngine
implements LoadFlowEngine<DcVariableType, DcEquationType, DcLoadFlowParameters, DcLoadFlowResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcLoadFlowEngine.class);
    private final DcLoadFlowContext context;

    public DcLoadFlowEngine(DcLoadFlowContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public DcLoadFlowContext getContext() {
        return this.context;
    }

    public static void distributeSlack(Collection<LfBus> buses, LoadFlowParameters.BalanceType balanceType, boolean useActiveLimits) {
        double mismatch = DcLoadFlowEngine.getActivePowerMismatch(buses);
        ActivePowerDistribution activePowerDistribution = ActivePowerDistribution.create(balanceType, false, useActiveLimits);
        activePowerDistribution.run(buses, mismatch);
    }

    public static double getActivePowerMismatch(Collection<LfBus> buses) {
        double mismatch = 0.0;
        for (LfBus b : buses) {
            mismatch += b.getGenerationTargetP() - b.getLoadTargetP();
        }
        return -mismatch;
    }

    public static void initStateVector(LfNetwork network, EquationSystem<DcVariableType, DcEquationType> equationSystem, VoltageInitializer initializer) {
        double[] x = new double[equationSystem.getIndex().getSortedVariablesToFind().size()];
        block5: for (Variable<DcVariableType> v : equationSystem.getIndex().getSortedVariablesToFind()) {
            switch (v.getType()) {
                case BUS_PHI: {
                    x[v.getRow()] = initializer.getAngle(network.getBus(v.getElementNum()));
                    continue block5;
                }
                case BRANCH_ALPHA1: {
                    x[v.getRow()] = network.getBranch(v.getElementNum()).getPiModel().getA1();
                    continue block5;
                }
                case DUMMY_P: {
                    x[v.getRow()] = 0.0;
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown variable type " + v.getType());
        }
        equationSystem.getStateVector().set(x);
    }

    public static void updateNetwork(LfNetwork network, EquationSystem<DcVariableType, DcEquationType> equationSystem, double[] x) {
        block5: for (Variable<DcVariableType> v : equationSystem.getIndex().getSortedVariablesToFind()) {
            switch (v.getType()) {
                case BUS_PHI: {
                    network.getBus(v.getElementNum()).setAngle(x[v.getRow()]);
                    continue block5;
                }
                case BRANCH_ALPHA1: {
                    network.getBranch(v.getElementNum()).getPiModel().setA1(x[v.getRow()]);
                    continue block5;
                }
                case DUMMY_P: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown variable type " + v.getType());
        }
    }

    private boolean runPhaseControlOuterLoop(DcIncrementalPhaseControlOuterLoop outerLoop, DcOuterLoopContext outerLoopContext) {
        OuterLoopStatus outerLoopStatus;
        ReportNode olReportNode = Reports.createOuterLoopReporter(outerLoopContext.getNetwork().getReportNode(), outerLoop.getName());
        int outerLoopIteration = 0;
        boolean success = true;
        do {
            outerLoopContext.setIteration(outerLoopIteration);
            outerLoopContext.setLoadFlowContext(this.context);
            outerLoopStatus = outerLoop.check(outerLoopContext, olReportNode).status();
            if (outerLoopStatus != OuterLoopStatus.UNSTABLE) continue;
            LOGGER.debug("Start outer loop '{}' iteration {}", (Object)outerLoop.getName(), (Object)outerLoopStatus);
            double[] targetVectorArray = (double[])this.context.getTargetVector().getArray().clone();
            success = DcLoadFlowEngine.solve(targetVectorArray, this.context.getJacobianMatrix(), olReportNode);
            if (success) {
                this.context.getEquationSystem().getStateVector().set(targetVectorArray);
                DcLoadFlowEngine.updateNetwork(outerLoopContext.getNetwork(), this.context.getEquationSystem(), targetVectorArray);
            }
            ++outerLoopIteration;
        } while (outerLoopStatus == OuterLoopStatus.UNSTABLE && success && outerLoopIteration < ((DcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations());
        return success;
    }

    public static boolean solve(double[] targetVectorArray, JacobianMatrix<DcVariableType, DcEquationType> jacobianMatrix, ReportNode reportNode) {
        try {
            jacobianMatrix.solveTransposed(targetVectorArray);
            return true;
        }
        catch (MatrixException e) {
            Reports.reportDcLfSolverFailure(reportNode, e.getMessage());
            LOGGER.error("Failed to solve linear system for DC load flow", (Throwable)e);
            return false;
        }
    }

    @Override
    public DcLoadFlowResult run() {
        LfNetwork network = this.context.getNetwork();
        ReportNode reportNode = network.getReportNode();
        EquationSystem<DcVariableType, DcEquationType> equationSystem = this.context.getEquationSystem();
        DcLoadFlowParameters parameters = (DcLoadFlowParameters)this.context.getParameters();
        TargetVector<DcVariableType, DcEquationType> targetVector = this.context.getTargetVector();
        DcIncrementalPhaseControlOuterLoop phaseShifterControlOuterLoop = new DcIncrementalPhaseControlOuterLoop();
        DcOuterLoopContext outerLoopContext = new DcOuterLoopContext(network);
        if (parameters.getNetworkParameters().isPhaseControl()) {
            phaseShifterControlOuterLoop.initialize(outerLoopContext);
        }
        DcLoadFlowEngine.initStateVector(network, equationSystem, new UniformValueVoltageInitializer());
        if (parameters.isDistributedSlack()) {
            DcLoadFlowEngine.distributeSlack(network.getBuses(), parameters.getBalanceType(), parameters.getNetworkParameters().isUseActiveLimits());
        }
        double[] targetVectorArray = (double[])targetVector.getArray().clone();
        boolean success = DcLoadFlowEngine.solve(targetVectorArray, this.context.getJacobianMatrix(), reportNode);
        equationSystem.getStateVector().set(targetVectorArray);
        DcLoadFlowEngine.updateNetwork(network, equationSystem, targetVectorArray);
        if (success && parameters.getNetworkParameters().isPhaseControl()) {
            success = this.runPhaseControlOuterLoop(phaseShifterControlOuterLoop, outerLoopContext);
        }
        if (parameters.isSetVToNan()) {
            for (LfBus bus : network.getBuses()) {
                bus.setV(Double.NaN);
            }
        }
        Reports.reportDcLfComplete(reportNode, success);
        LOGGER.info("DC load flow completed (success={})", (Object)success);
        return new DcLoadFlowResult(this.context.getNetwork(), DcLoadFlowEngine.getActivePowerMismatch(this.context.getNetwork().getBuses()), success);
    }

    public static <T> List<DcLoadFlowResult> run(T network, LfNetworkLoader<T> networkLoader, DcLoadFlowParameters parameters, ReportNode reportNode) {
        return LfNetwork.load(network, networkLoader, parameters.getNetworkParameters(), reportNode).stream().map(n -> {
            if (n.getValidity() == LfNetwork.Validity.VALID) {
                try (DcLoadFlowContext context = new DcLoadFlowContext((LfNetwork)n, parameters);){
                    DcLoadFlowResult dcLoadFlowResult = new DcLoadFlowEngine(context).run();
                    return dcLoadFlowResult;
                }
            }
            return new DcLoadFlowResult((LfNetwork)n, DcLoadFlowEngine.getActivePowerMismatch(n.getBuses()), false);
        }).collect(Collectors.toList());
    }
}

