/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.openloadflow.lf.AbstractLoadFlowResult;
import com.powsybl.openloadflow.lf.LoadFlowResult;
import com.powsybl.openloadflow.network.LfNetwork;

public class DcLoadFlowResult
extends AbstractLoadFlowResult {
    private final boolean success;

    public DcLoadFlowResult(LfNetwork network, double slackBusActivePowerMismatch, boolean success) {
        super(network, slackBusActivePowerMismatch);
        this.success = success;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public LoadFlowResult.Status toComponentResultStatus() {
        if (this.network.getValidity() != LfNetwork.Validity.VALID) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.NO_CALCULATION, this.network.getValidity().toString());
        }
        if (this.success) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.CONVERGED, "Converged");
        }
        return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.FAILED, "Solver Failed");
    }
}

