/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.commons.PowsyblException;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.equations.DcApproximationType;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemCreationParameters;
import com.powsybl.openloadflow.network.BusDcState;
import com.powsybl.openloadflow.network.ElementState;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import java.util.List;
import java.util.Objects;

public class DcValueVoltageInitializer
implements VoltageInitializer {
    private final LfNetworkParameters networkParameters;
    private final boolean distributedSlack;
    private final LoadFlowParameters.BalanceType balanceType;
    private final boolean useTransformerRatio;
    private final DcApproximationType dcApproximationType;
    private final MatrixFactory matrixFactory;
    private final int maxOuterLoopIterations;

    public DcValueVoltageInitializer(LfNetworkParameters networkParameters, boolean distributedSlack, LoadFlowParameters.BalanceType balanceType, boolean useTransformerRatio, DcApproximationType dcApproximationType, MatrixFactory matrixFactory, int maxOuterLoopIterations) {
        this.networkParameters = Objects.requireNonNull(networkParameters);
        this.distributedSlack = distributedSlack;
        this.balanceType = Objects.requireNonNull(balanceType);
        this.useTransformerRatio = useTransformerRatio;
        this.dcApproximationType = Objects.requireNonNull(dcApproximationType);
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        this.maxOuterLoopIterations = maxOuterLoopIterations;
    }

    @Override
    public void prepare(LfNetwork network) {
        List<BusDcState> busStates = this.distributedSlack ? ElementState.save(network.getBuses(), BusDcState::save) : null;
        LfNetworkParameters networkParametersDcInit = new LfNetworkParameters(this.networkParameters).setPhaseControl(false);
        DcEquationSystemCreationParameters creationParameters = new DcEquationSystemCreationParameters().setUpdateFlows(false).setForcePhaseControlOffAndAddAngle1Var(false).setUseTransformerRatio(this.useTransformerRatio).setDcApproximationType(this.dcApproximationType);
        DcLoadFlowParameters parameters = ((DcLoadFlowParameters)((DcLoadFlowParameters)new DcLoadFlowParameters().setNetworkParameters(networkParametersDcInit)).setEquationSystemCreationParameters(creationParameters).setMatrixFactory(this.matrixFactory)).setDistributedSlack(this.distributedSlack).setBalanceType(this.balanceType).setSetVToNan(false).setMaxOuterLoopIterations(this.maxOuterLoopIterations);
        try (DcLoadFlowContext context = new DcLoadFlowContext(network, parameters);){
            DcLoadFlowEngine engine = new DcLoadFlowEngine(context);
            if (!engine.run().isSuccess()) {
                throw new PowsyblException("DC loadflow failed, impossible to initialize voltage angle from DC values");
            }
        }
        if (busStates != null) {
            ElementState.restore(busStates);
        }
    }

    @Override
    public double getMagnitude(LfBus bus) {
        return 1.0;
    }

    @Override
    public double getAngle(LfBus bus) {
        return bus.getAngle();
    }
}

