/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.equations;

import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.StateVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;
import java.util.List;

public abstract class AbstractHvdcAcEmulationDcFlowEquationTerm
extends AbstractElementEquationTerm<LfHvdc, DcVariableType, DcEquationType> {
    protected final Variable<DcVariableType> ph1Var;
    protected final Variable<DcVariableType> ph2Var;
    protected final List<Variable<DcVariableType>> variables;
    protected final LfHvdc hvdc;
    protected final double k;

    protected AbstractHvdcAcEmulationDcFlowEquationTerm(LfHvdc hvdc, LfBus bus1, LfBus bus2, VariableSet<DcVariableType> variableSet) {
        super(hvdc);
        this.ph1Var = variableSet.getVariable(bus1.getNum(), DcVariableType.BUS_PHI);
        this.ph2Var = variableSet.getVariable(bus2.getNum(), DcVariableType.BUS_PHI);
        this.variables = List.of(this.ph1Var, this.ph2Var);
        this.hvdc = hvdc;
        this.k = this.hvdc.getDroop() * 180.0 / Math.PI;
    }

    @Override
    public List<Variable<DcVariableType>> getVariables() {
        return this.variables;
    }

    protected double ph1() {
        return this.ph1(this.sv);
    }

    protected double ph1(StateVector sv) {
        return sv.get(this.ph1Var.getRow());
    }

    protected double ph2() {
        return this.ph2(this.sv);
    }

    protected double ph2(StateVector sv) {
        return sv.get(this.ph2Var.getRow());
    }
}

