/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.equations;

import com.powsybl.openloadflow.dc.equations.AbstractClosedBranchDcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcApproximationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import java.util.Objects;

public final class ClosedBranchSide2DcFlowEquationTerm
extends AbstractClosedBranchDcFlowEquationTerm {
    private ClosedBranchSide2DcFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<DcVariableType> variableSet, boolean deriveA1, boolean useTransformerRatio, DcApproximationType dcApproximationType) {
        super(branch, bus1, bus2, variableSet, deriveA1, useTransformerRatio, dcApproximationType);
    }

    public static ClosedBranchSide2DcFlowEquationTerm create(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<DcVariableType> variableSet, boolean deriveA1, boolean useTransformerRatio, DcApproximationType dcApproximationType) {
        Objects.requireNonNull(branch);
        Objects.requireNonNull(bus1);
        Objects.requireNonNull(bus2);
        Objects.requireNonNull(variableSet);
        return new ClosedBranchSide2DcFlowEquationTerm(branch, bus1, bus2, variableSet, deriveA1, useTransformerRatio, dcApproximationType);
    }

    @Override
    protected double calculateSensi(double ph1, double ph2, double a1) {
        double deltaPhase = ph2 - ph1 + 0.0 - a1;
        return this.power * deltaPhase;
    }

    @Override
    public double der(Variable<DcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.ph1Var)) {
            return -this.power;
        }
        if (variable.equals(this.ph2Var)) {
            return this.power;
        }
        if (variable.equals(this.a1Var)) {
            return -this.power;
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    public double rhs() {
        if (this.a1Var != null) {
            return this.power * 0.0;
        }
        return this.power * (0.0 - this.a1());
    }

    @Override
    protected String getName() {
        return "dc_p_2";
    }
}

