/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.equations;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.dc.equations.ClosedBranchDcCurrent;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide1DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide2DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemCreationParameters;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemUpdater;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.dc.equations.HvdcAcEmulationSide1DCFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.HvdcAcEmulationSide2DCFlowEquationTerm;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationSystemPostProcessor;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListenerTracer;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.util.EvaluableConstants;
import java.util.Objects;

public class DcEquationSystemCreator {
    private final LfNetwork network;
    private final DcEquationSystemCreationParameters creationParameters;

    public DcEquationSystemCreator(LfNetwork network) {
        this(network, new DcEquationSystemCreationParameters());
    }

    public DcEquationSystemCreator(LfNetwork network, DcEquationSystemCreationParameters creationParameters) {
        this.network = Objects.requireNonNull(network);
        this.creationParameters = Objects.requireNonNull(creationParameters);
    }

    private void createBuses(EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        for (LfBus bus : this.network.getBuses()) {
            Equation<DcVariableType, DcEquationType> p = equationSystem.createEquation(bus, DcEquationType.BUS_TARGET_P);
            bus.setP(p);
            if (!bus.isSlack()) continue;
            equationSystem.createEquation(bus, DcEquationType.BUS_TARGET_PHI).addTerm(equationSystem.getVariable(bus.getNum(), DcVariableType.BUS_PHI).createTerm());
            p.setActive(false);
        }
    }

    public static void createNonImpedantBranch(EquationSystem<DcVariableType, DcEquationType> equationSystem, LfBranch branch, LfBus bus1, LfBus bus2, boolean spanningTree) {
        if (bus1 != null && bus2 != null) {
            boolean hasPhi1 = equationSystem.hasEquation(bus1.getNum(), DcEquationType.BUS_TARGET_PHI);
            boolean hasPhi2 = equationSystem.hasEquation(bus2.getNum(), DcEquationType.BUS_TARGET_PHI);
            if (!hasPhi1 || !hasPhi2) {
                equationSystem.createEquation(branch, DcEquationType.ZERO_PHI).addTerm(equationSystem.getVariable(bus1.getNum(), DcVariableType.BUS_PHI).createTerm()).addTerm(equationSystem.getVariable(bus2.getNum(), DcVariableType.BUS_PHI).createTerm().minus()).setActive(!branch.isDisabled() && spanningTree);
                Variable<DcVariableType> dummyP = equationSystem.getVariable(branch.getNum(), DcVariableType.DUMMY_P);
                equationSystem.getEquation(bus1.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow().addTerm(dummyP.createTerm());
                equationSystem.getEquation(bus2.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow().addTerm(dummyP.createTerm().minus());
                equationSystem.createEquation(branch, DcEquationType.DUMMY_TARGET_P).addTerm(dummyP.createTerm()).setActive(branch.isDisabled() || !spanningTree);
            } else {
                throw new IllegalStateException("Cannot happen because only there is one slack bus per model");
            }
        }
    }

    private static void createImpedantBranch(EquationSystem<DcVariableType, DcEquationType> equationSystem, DcEquationSystemCreationParameters creationParameters, LfBranch branch, LfBus bus1, LfBus bus2) {
        if (bus1 != null && bus2 != null) {
            boolean deriveA1 = DcEquationSystemCreator.isDeriveA1(branch, creationParameters);
            ClosedBranchSide1DcFlowEquationTerm p1 = ClosedBranchSide1DcFlowEquationTerm.create(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, creationParameters.isUseTransformerRatio(), creationParameters.getDcApproximationType());
            ClosedBranchSide2DcFlowEquationTerm p2 = ClosedBranchSide2DcFlowEquationTerm.create(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, creationParameters.isUseTransformerRatio(), creationParameters.getDcApproximationType());
            equationSystem.getEquation(bus1.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow().addTerm(p1);
            equationSystem.getEquation(bus2.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow().addTerm(p2);
            if (deriveA1) {
                EquationTerm a1 = equationSystem.getVariable(branch.getNum(), DcVariableType.BRANCH_ALPHA1).createTerm();
                branch.setA1(a1);
                equationSystem.createEquation(branch, DcEquationType.BRANCH_TARGET_ALPHA1).addTerm(a1);
            }
            if (creationParameters.isUpdateFlows()) {
                branch.setP1(p1);
                branch.setClosedP1(p1);
                branch.setP2(p2);
                branch.setClosedP2(p2);
                ClosedBranchDcCurrent i1 = new ClosedBranchDcCurrent(branch, TwoSides.ONE, creationParameters.getDcPowerFactor());
                ClosedBranchDcCurrent i2 = new ClosedBranchDcCurrent(branch, TwoSides.TWO, creationParameters.getDcPowerFactor());
                branch.setI1(i1);
                branch.setI2(i2);
            }
        } else if (bus1 != null && creationParameters.isUpdateFlows()) {
            branch.setP1(EvaluableConstants.ZERO);
        } else if (bus2 != null && creationParameters.isUpdateFlows()) {
            branch.setP2(EvaluableConstants.ZERO);
        }
    }

    protected static boolean isDeriveA1(LfBranch branch, DcEquationSystemCreationParameters creationParameters) {
        return branch.isPhaseController() || creationParameters.isForcePhaseControlOffAndAddAngle1Var() && branch.hasPhaseControllerCapability() && branch.isConnectedAtBothSides();
    }

    private void createBranches(EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        for (LfBranch branch : this.network.getBranches()) {
            LfBus bus1 = branch.getBus1();
            LfBus bus2 = branch.getBus2();
            if (branch.isZeroImpedance(LoadFlowModel.DC)) {
                DcEquationSystemCreator.createNonImpedantBranch(equationSystem, branch, bus1, bus2, branch.isSpanningTreeEdge(LoadFlowModel.DC));
                continue;
            }
            DcEquationSystemCreator.createImpedantBranch(equationSystem, this.creationParameters, branch, bus1, bus2);
        }
    }

    private void createHvdcs(EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        for (LfHvdc hvdc : this.network.getHvdcs()) {
            HvdcAcEmulationSide1DCFlowEquationTerm p1 = null;
            HvdcAcEmulationSide2DCFlowEquationTerm p2 = null;
            if (hvdc.getBus1() != null && hvdc.getBus2() != null && hvdc.isAcEmulation()) {
                p1 = new HvdcAcEmulationSide1DCFlowEquationTerm(hvdc, hvdc.getBus1(), hvdc.getBus2(), equationSystem.getVariableSet());
                p2 = new HvdcAcEmulationSide2DCFlowEquationTerm(hvdc, hvdc.getBus1(), hvdc.getBus2(), equationSystem.getVariableSet());
            }
            if (p1 != null) {
                equationSystem.getEquation(hvdc.getBus1().getNum(), DcEquationType.BUS_TARGET_P).orElseThrow().addTerm(p1);
                hvdc.setP1(p1);
            }
            if (p2 == null) continue;
            equationSystem.getEquation(hvdc.getBus2().getNum(), DcEquationType.BUS_TARGET_P).orElseThrow().addTerm(p2);
            hvdc.setP2(p2);
        }
    }

    public EquationSystem<DcVariableType, DcEquationType> create(boolean withListener) {
        EquationSystem<DcVariableType, DcEquationType> equationSystem = new EquationSystem<DcVariableType, DcEquationType>();
        this.createBuses(equationSystem);
        this.createBranches(equationSystem);
        this.createHvdcs(equationSystem);
        EquationSystemPostProcessor.findAll().forEach(pp -> pp.onCreate(equationSystem));
        if (withListener) {
            this.network.addListener(LfNetworkListenerTracer.trace(new DcEquationSystemUpdater(equationSystem)));
        }
        return equationSystem;
    }
}

