/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.equations;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.lf.AbstractEquationSystemUpdater;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.util.EvaluableConstants;

public class DcEquationSystemUpdater
extends AbstractEquationSystemUpdater<DcVariableType, DcEquationType> {
    public DcEquationSystemUpdater(EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        super(equationSystem, LoadFlowModel.DC);
    }

    @Override
    protected void updateNonImpedantBranchEquations(LfBranch branch, boolean enable) {
        this.equationSystem.getEquation(branch.getNum(), DcEquationType.ZERO_PHI).orElseThrow().setActive(enable);
        this.equationSystem.getEquation(branch.getNum(), DcEquationType.DUMMY_TARGET_P).orElseThrow().setActive(!enable);
    }

    @Override
    public void onDisableChange(LfElement element, boolean disabled) {
        this.updateElementEquations(element, !disabled);
        switch (element.getType()) {
            case BUS: {
                LfBus bus = (LfBus)element;
                DcEquationSystemUpdater.checkSlackBus(bus, disabled);
                this.equationSystem.getEquation(bus.getNum(), DcEquationType.BUS_TARGET_PHI).ifPresent(eq -> eq.setActive(!bus.isDisabled() && bus.isReference()));
                this.equationSystem.getEquation(bus.getNum(), DcEquationType.BUS_TARGET_P).ifPresent(eq -> eq.setActive(!bus.isDisabled() && !bus.isSlack()));
                break;
            }
            case BRANCH: 
            case HVDC: 
            case SHUNT_COMPENSATOR: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown element type: " + element.getType());
            }
        }
    }

    @Override
    public void onBranchConnectionStatusChange(LfBranch branch, TwoSides side, boolean connected) {
        super.onBranchConnectionStatusChange(branch, side, connected);
        if (!branch.isDisabled() && !branch.isZeroImpedance(LoadFlowModel.DC)) {
            if (branch.isConnectedSide1() && branch.isConnectedSide2()) {
                EquationTerm.setActive(branch.getClosedP1(), true);
                EquationTerm.setActive(branch.getClosedP2(), true);
                branch.setP1(branch.getClosedP1());
                branch.setP2(branch.getClosedP2());
            } else if (!branch.isConnectedSide1() && branch.isConnectedSide2() || branch.isConnectedSide1() && !branch.isConnectedSide2()) {
                EquationTerm.setActive(branch.getClosedP1(), false);
                EquationTerm.setActive(branch.getClosedP2(), false);
                branch.setP1(EvaluableConstants.ZERO);
                branch.setP2(EvaluableConstants.ZERO);
            } else {
                EquationTerm.setActive(branch.getClosedP1(), false);
                EquationTerm.setActive(branch.getClosedP2(), false);
                branch.setP1(EvaluableConstants.NAN);
                branch.setP2(EvaluableConstants.NAN);
            }
        }
    }

    @Override
    protected DcEquationType getTypeBusTargetP() {
        return DcEquationType.BUS_TARGET_P;
    }

    @Override
    protected DcEquationType getTypeBusTargetPhi() {
        return DcEquationType.BUS_TARGET_PHI;
    }

    @Override
    protected DcVariableType getTypeBusPhi() {
        return DcVariableType.BUS_PHI;
    }
}

