/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.EquationTermEventType;
import com.powsybl.openloadflow.equations.StateVector;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractEquationTerm<V extends Enum<V>, E extends Enum<E>>
implements EquationTerm<V, E> {
    private Equation<V, E> equation;
    private boolean active;
    protected StateVector sv;
    protected EquationTerm<V, E> self = this;

    protected AbstractEquationTerm() {
        this(true);
    }

    protected AbstractEquationTerm(boolean active) {
        this.active = active;
    }

    @Override
    public void setStateVector(StateVector sv) {
        this.sv = Objects.requireNonNull(sv);
    }

    @Override
    public List<EquationTerm<V, E>> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Equation<V, E> getEquation() {
        return this.equation;
    }

    @Override
    public void setEquation(Equation<V, E> equation) {
        this.equation = Objects.requireNonNull(equation);
    }

    @Override
    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.equation.getEquationSystem().notifyEquationTermChange(this.self, active ? EquationTermEventType.EQUATION_TERM_ACTIVATED : EquationTermEventType.EQUATION_TERM_DEACTIVATED);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setSelf(EquationTerm<V, E> self) {
        this.self = Objects.requireNonNull(self);
    }

    @Override
    public double calculateSensi(DenseMatrix dx, int column) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean hasRhs() {
        return false;
    }

    @Override
    public double rhs() {
        return 0.0;
    }
}

